/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.core.InternalActionResponse;
import com.ibm.ws.portletcontainer.core.impl.PortletRequestImpl;
import com.ibm.ws.portletcontainer.core.impl.PortletResponseImpl;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.util.StringUtils;
import com.ibm.wsspi.portletcontainer.services.information.ResourceURLProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionResponseImpl
extends PortletResponseImpl
implements ActionResponse,
InternalActionResponse {
    private static final String CLASS_NAME = ActionResponseImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    boolean redirectAllowed = true;
    private boolean redirected;
    private String redirectLocation;
    private Map renderParameters;
    private WindowState windowState;
    private PortletMode portletMode;

    public ActionResponseImpl(PortletWindow portletWindow, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        super(portletWindow, httpServletRequest, httpServletResponse);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        logger.entering(CLASS_NAME, "setWindowState", windowState);
        if (this.redirected) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setWindowState", "set.unsupported.window.state.0");
            throw new IllegalStateException("it is not allowed to invoke setWindowState after sendRedirect has been called");
        }
        if (!PortletRequestImpl.isWindowStateAllowed(windowState, this.getPortletWindow(), this.getInformationProvider())) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setWindowState", "set.unsupported.window.state.1", windowState);
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.windowState = windowState;
        this.redirectAllowed = false;
        logger.exiting(CLASS_NAME, "setWindowState");
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        logger.entering(CLASS_NAME, "setPortletMode", portletMode);
        if (this.redirected) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setPortletMode", "set.unsupported.portlet.mode.0");
            throw new IllegalStateException("it is not allowed to invoke setPortletMode after sendRedirect has been called");
        }
        if (!PortletRequestImpl.isPortletModeAllowed(portletMode, this.getPortletWindow(), this.getInformationProvider())) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setPortletMode", "set.unsupported.portlet.mode.1", portletMode);
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.portletMode = portletMode;
        this.redirectAllowed = false;
        logger.exiting(CLASS_NAME, "setPortletMode");
    }

    public void sendRedirect(String string) throws IOException {
        logger.entering(CLASS_NAME, "sendRedirect", string);
        if (this.redirectAllowed) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "sendRedirect", "redirection allowed");
            }
            if (string != null) {
                boolean bl = logger.isLoggable(Level.FINEST);
                ResourceURLProvider resourceURLProvider = this.getInformationProvider().getResourceURLProvider(this.getPortletWindow().getPortletWindowIdentifier());
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "sendRedirect", "Using ResourceURLProvider: " + resourceURLProvider);
                }
                if (StringUtils.isAbsoluteURL(string)) {
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "sendRedirect", "Setting absolute url: " + string);
                    }
                    this.redirectLocation = resourceURLProvider.getAbsoluteURL(string);
                } else if (string.startsWith("/")) {
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "sendRedirect", "Setting full path: " + string);
                    }
                    this.redirectLocation = resourceURLProvider.getFullPath(string);
                } else {
                    logger.logp(Level.SEVERE, CLASS_NAME, "sendRedirect", "action.response.redirect.error.1", string);
                    throw new IllegalArgumentException("The argument to sendRedirect must not be a relative URL");
                }
                this.redirected = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", "portlet redirect set to " + this.redirectLocation);
                }
            }
        } else {
            logger.logp(Level.SEVERE, CLASS_NAME, "sendRedirect", "action.response.redirect.error.0");
            throw new IllegalStateException("Can't invoke sendRedirect() after certain methods have been called");
        }
        logger.exiting(CLASS_NAME, "sendRedirect");
    }

    public void setRenderParameters(Map map) {
        logger.entering(CLASS_NAME, "setRenderParameters", map);
        if (this.redirected) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setRenderParameters", "set.render.parameters.redirect.0");
            throw new IllegalStateException("Can't invoke setRenderParameters() after sendRedirect() has been called");
        }
        if (map == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setRenderParameters", "set.render.parameters.parameters.0");
            throw new IllegalArgumentException("Render parameters must not be null.");
        }
        this.renderParameters = StringUtils.copyParameters(map);
        this.redirectAllowed = false;
        logger.exiting(CLASS_NAME, "setRenderParameters");
    }

    public void setRenderParameter(String string, String string2) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setRenderParameter", new Object[]{string, string2});
        }
        if (this.redirected) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setRenderParameter", "set.render.parameter.redirect.0");
            throw new IllegalStateException("Can't invoke setRenderParameter() after sendRedirect() has been called");
        }
        if (string == null || string2 == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setRenderParameter", "set.render.parameter.entry.key.0");
            throw new IllegalArgumentException("Render parameter key or value must not be null.");
        }
        if (this.renderParameters == null) {
            this.renderParameters = new HashMap();
        }
        this.renderParameters.put(string, new String[]{string2});
        this.redirectAllowed = false;
        logger.exiting(CLASS_NAME, "setRenderParameter");
    }

    public void setRenderParameter(String string, String[] stringArray) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setRenderParameter", new Object[]{string, stringArray});
        }
        if (this.redirected) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setRenderParameter", "set.render.parameter.redirect.0");
            throw new IllegalStateException("Can't invoke setRenderParameter() after sendRedirect() has been called");
        }
        if (string == null || stringArray == null || stringArray.length == 0) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setRenderParameter", "set.render.param.array.entry.key.0");
            throw new IllegalArgumentException("Render parameter key or value must not be null or values be an empty array.");
        }
        if (this.renderParameters == null) {
            this.renderParameters = new HashMap();
        }
        this.renderParameters.put(string, StringUtils.copy(stringArray));
        this.redirectAllowed = false;
        logger.exiting(CLASS_NAME, "setRenderParameter");
    }

    public Map getRenderParameters() {
        Map map;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getRenderParameters");
        }
        if ((map = this.renderParameters) == null) {
            map = Collections.EMPTY_MAP;
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "getRenderParameters", map);
        }
        return map;
    }

    public PortletMode getChangedPortletMode() {
        return this.portletMode;
    }

    public WindowState getChangedWindowState() {
        return this.windowState;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }
}

