/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.core.InternalPortletConfig;
import com.ibm.ws.portletcontainer.om.common.Language;
import com.ibm.ws.portletcontainer.om.common.LanguageSet;
import com.ibm.ws.portletcontainer.om.common.Parameter;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.util.LocaleIterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletConfig;

public class PortletConfigImpl
implements PortletConfig,
InternalPortletConfig {
    private ServletConfig servletConfig;
    private PortletContext portletContext;
    private PortletDefinition portletDefinition;
    private static final String CLASS_NAME = PortletConfigImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public PortletConfigImpl(ServletConfig servletConfig, PortletContext portletContext, PortletDefinition portletDefinition) {
        this.servletConfig = servletConfig;
        this.portletContext = portletContext;
        this.portletDefinition = portletDefinition;
    }

    public String getPortletName() {
        return this.portletDefinition.getName();
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        logger.entering(CLASS_NAME, "getResourceBundle", locale);
        LanguageSet languageSet = this.portletDefinition.getLanguageSet();
        Language language = null;
        Object object = new LocaleIterator(locale, languageSet.getDefaultLocale());
        while (language == null && ((LocaleIterator)object).hasNext()) {
            locale = ((LocaleIterator)object).next();
            language = languageSet.get(locale);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getResourceBundle", "using locale " + locale);
        }
        if (language == null) {
            throw new IllegalStateException("could not find Language object");
        }
        object = language.getResourceBundle();
        logger.exiting(CLASS_NAME, "getResourceBundle", object);
        return object;
    }

    public String getInitParameter(String string) {
        logger.entering(CLASS_NAME, "getInitParameter", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getResourceBundle", "portlet.api.param.0");
            throw new IllegalArgumentException("Parameter name == null");
        }
        Parameter parameter = this.portletDefinition.getInitParameterSet().get(string);
        String string2 = parameter == null ? null : parameter.getValue();
        logger.exiting(CLASS_NAME, "getInitParameter", string2);
        return string2;
    }

    public Enumeration getInitParameterNames() {
        logger.entering(CLASS_NAME, "getInitParameterNames");
        Enumeration enumeration = new Enumeration(){
            private Iterator iterator;
            {
                this.iterator = PortletConfigImpl.this.portletDefinition.getInitParameterSet().iterator();
            }

            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                if (this.iterator.hasNext()) {
                    return ((Parameter)this.iterator.next()).getName();
                }
                return null;
            }
        };
        logger.exiting(CLASS_NAME, "getInitParameterNames", enumeration);
        return enumeration;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public PortletDefinition getInternalPortletDefinition() {
        return this.portletDefinition;
    }
}

