/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.core.InternalPortletContext;
import com.ibm.ws.portletcontainer.core.impl.PortletRequestDispatcherImpl;
import com.ibm.ws.portletcontainer.om.portlet.PortletApplicationDefinition;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;

public class PortletContextImpl
implements PortletContext,
InternalPortletContext {
    private PortletApplicationDefinition portletApplicationDefinition;
    private ServletContext servletContext;
    private static final String CLASS_NAME = PortletContextImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public PortletContextImpl(ServletContext servletContext, PortletApplicationDefinition portletApplicationDefinition) {
        this.servletContext = servletContext;
        this.portletApplicationDefinition = portletApplicationDefinition;
    }

    public String getServerInfo() {
        logger.entering(CLASS_NAME, "getServerInfo");
        logger.exiting(CLASS_NAME, "getServerInfo", "IBM WebSphere Portlet Container/1.0");
        return "IBM WebSphere Portlet Container/1.0";
    }

    public PortletRequestDispatcher getRequestDispatcher(String string) {
        logger.entering(CLASS_NAME, "getRequestDispatcher", string);
        PortletRequestDispatcherImpl portletRequestDispatcherImpl = null;
        if (string.startsWith("/")) {
            RequestDispatcher requestDispatcher;
            String string2 = null;
            int n = string.indexOf(63);
            if (n >= 0) {
                string2 = string.substring(n + 1);
            }
            if ((requestDispatcher = this.servletContext.getRequestDispatcher(string)) != null) {
                portletRequestDispatcherImpl = new PortletRequestDispatcherImpl(requestDispatcher, string2);
            }
        }
        logger.exiting(CLASS_NAME, "getRequestDispatcher", portletRequestDispatcherImpl);
        return portletRequestDispatcherImpl;
    }

    public PortletRequestDispatcher getNamedDispatcher(String string) {
        logger.entering(CLASS_NAME, "getNamedDispatcher", string);
        RequestDispatcher requestDispatcher = this.servletContext.getNamedDispatcher(string);
        PortletRequestDispatcherImpl portletRequestDispatcherImpl = requestDispatcher != null ? new PortletRequestDispatcherImpl(requestDispatcher) : null;
        logger.exiting(CLASS_NAME, "getNamedDispatcher", portletRequestDispatcherImpl);
        return portletRequestDispatcherImpl;
    }

    public InputStream getResourceAsStream(String string) {
        logger.entering(CLASS_NAME, "getResourceAsStream", string);
        InputStream inputStream = this.servletContext.getResourceAsStream(string);
        logger.exiting(CLASS_NAME, "getResourceAsStream", inputStream);
        return inputStream;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String string) {
        logger.entering(CLASS_NAME, "getMimeType", string);
        String string2 = this.servletContext.getMimeType(string);
        logger.exiting(CLASS_NAME, "getMimeType", string2);
        return string2;
    }

    public String getRealPath(String string) {
        logger.entering(CLASS_NAME, "getRealPath", string);
        String string2 = this.servletContext.getRealPath(string);
        logger.exiting(CLASS_NAME, "getRealPath", string2);
        return string2;
    }

    public Set getResourcePaths(String string) {
        logger.entering(CLASS_NAME, "getResourcePaths", string);
        Set set = this.servletContext.getResourcePaths(string);
        logger.exiting(CLASS_NAME, "getResourcePaths", set);
        return set;
    }

    public URL getResource(String string) throws MalformedURLException {
        logger.entering(CLASS_NAME, "getResource", string);
        if (string == null || !string.startsWith("/")) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getResource", "portlet.context.get.resource.0");
            throw new MalformedURLException("path must start with a '/'");
        }
        URL uRL = this.servletContext.getResource(string);
        logger.exiting(CLASS_NAME, "getResource", uRL);
        return uRL;
    }

    public Object getAttribute(String string) {
        logger.entering(CLASS_NAME, "getAttribute", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getAttribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("Attribute name == null");
        }
        Object object = this.servletContext.getAttribute(string);
        logger.exiting(CLASS_NAME, "getAttribute", object);
        return object;
    }

    public Enumeration getAttributeNames() {
        logger.entering(CLASS_NAME, "getAttributeNames");
        Enumeration enumeration = this.servletContext.getAttributeNames();
        logger.exiting(CLASS_NAME, "getAttributeNames", enumeration);
        return enumeration;
    }

    public String getInitParameter(String string) {
        logger.entering(CLASS_NAME, "getInitParameter", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getInitParameter", "portlet.api.param.0");
            throw new IllegalArgumentException("Parameter name == null");
        }
        String string2 = this.servletContext.getInitParameter(string);
        logger.exiting(CLASS_NAME, "getInitParameter", string2);
        return string2;
    }

    public Enumeration getInitParameterNames() {
        logger.entering(CLASS_NAME, "getInitParameterNames");
        Enumeration enumeration = this.servletContext.getInitParameterNames();
        logger.exiting(CLASS_NAME, "getInitParameterNames", enumeration);
        return enumeration;
    }

    public void log(String string) {
        this.servletContext.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.servletContext.log(string, throwable);
    }

    public void removeAttribute(String string) {
        logger.entering(CLASS_NAME, "removeAttribute", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "removeAttribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.removeAttribute(string);
        logger.exiting(CLASS_NAME, "removeAttribute");
    }

    public void setAttribute(String string, Object object) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setAttribute", new Object[]{string, object});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "removeAttribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.setAttribute(string, object);
        logger.exiting(CLASS_NAME, "setAttribute");
    }

    public String getPortletContextName() {
        logger.entering(CLASS_NAME, "getPortletContextName");
        String string = this.servletContext.getServletContextName();
        logger.exiting(CLASS_NAME, "getPortletContextName", string);
        return string;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletApplicationDefinition getInternalPortletApplicationDefinition() {
        return this.portletApplicationDefinition;
    }
}

