/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.Constants;
import com.ibm.ws.portletcontainer.core.impl.ValidatorPreferencesWrapper;
import com.ibm.ws.portletcontainer.om.ControllerObjectAccess;
import com.ibm.ws.portletcontainer.om.common.Preference;
import com.ibm.ws.portletcontainer.om.common.PreferenceCtrl;
import com.ibm.ws.portletcontainer.om.common.PreferenceSet;
import com.ibm.ws.portletcontainer.om.common.PreferenceSetCtrl;
import com.ibm.ws.portletcontainer.om.common.WSPreferenceSet;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.om.window.PortletWindowCtrl;
import com.ibm.ws.portletcontainer.service.persistence.PersistenceProviderAccess;
import com.ibm.ws.portletcontainer.util.StringUtils;
import com.ibm.wsspi.portletcontainer.services.persistence.PersistenceProvider;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceAccessMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesImpl
implements PortletPreferences {
    private WSPreferenceSet portalPreferences;
    private PreferenceSet portletXmlPreferences;
    private HashMap changedPreferences;
    private HashSet removedPreferences;
    private Integer methodId;
    private PreferenceAccessMode prefAccessMode;
    private PortletWindow portletWindow;
    private PortletDefinition portletDefinition;
    private PersistenceProvider provider;
    private static final String CLASS_NAME = PortletPreferencesImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public PortletPreferencesImpl(Integer n, PortletWindow portletWindow) {
        this.methodId = n;
        this.portletWindow = portletWindow;
        this.portletDefinition = portletWindow.getPortletDefinition();
        this.portalPreferences = (WSPreferenceSet)portletWindow.getPreferenceSet();
        this.portletXmlPreferences = this.portletDefinition.getPreferenceSet();
    }

    public boolean isReadOnly(String string) {
        logger.entering(CLASS_NAME, "isReadOnly", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "isReadOnly", "portlet.pref.key.0");
            throw new IllegalArgumentException("key == null");
        }
        boolean bl = this.alwaysReadOnly();
        if (!bl) {
            Preference preference = this.portalPreferences.get(string);
            if (preference == null && (preference = this.portalPreferences.getDefault(string)) == null) {
                preference = this.portletXmlPreferences.get(string);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isReadOnly", "Preference found: " + preference);
            }
            if (preference != null) {
                bl = preference.isReadOnly();
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "isReadOnly", bl);
        }
        return bl;
    }

    public String getValue(String string, String string2) {
        Object object;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getValue", new Object[]{string, string2});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getValue", "portlet.pref.key.0");
            throw new IllegalArgumentException("key == null");
        }
        boolean bl2 = logger.isLoggable(Level.FINEST);
        if (this.changedPreferences != null && this.changedPreferences.containsKey(string) && (object = (String[])this.changedPreferences.get(string)) != null) {
            if (bl2) {
                logger.logp(Level.FINE, CLASS_NAME, "getValue", "Preference " + string + " has recently changed.");
            }
            if (bl) {
                logger.exiting(CLASS_NAME, "getValue", object[0]);
            }
            return object[0];
        }
        object = null;
        if (this.removedPreferences == null || !this.removedPreferences.contains(string)) {
            object = this.portalPreferences.get(string);
        } else if (bl2) {
            logger.logp(Level.FINE, CLASS_NAME, "getValue", "Preference " + string + " has been recently removed.");
        }
        if (object == null && (object = this.portalPreferences.getDefault(string)) == null) {
            object = this.portletXmlPreferences.get(string);
        }
        String string3 = null;
        if (object == null || !object.isValueSet()) {
            if (bl2) {
                if (object == null) {
                    logger.logp(Level.FINE, CLASS_NAME, "getValue", "Preference " + string + " does not exist.");
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "getValue", "Preference " + string + " has no value.");
                }
            }
            if (bl) {
                logger.exiting(CLASS_NAME, "getValue", string2);
            }
            string3 = string2;
        } else {
            Iterator iterator;
            List list = object.getValues();
            Iterator iterator2 = iterator = list != null ? list.iterator() : null;
            if (iterator != null && iterator.hasNext()) {
                string3 = (String)iterator.next();
            }
            if (bl2) {
                logger.logp(Level.FINE, CLASS_NAME, "getValue", "Preference " + string + " exists.");
            }
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "getValue", string3);
        }
        return string3;
    }

    public String[] getValues(String string, String[] stringArray) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getValues", new Object[]{string, stringArray});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getValues", "portlet.pref.key.0");
            throw new IllegalArgumentException("key == null");
        }
        boolean bl2 = logger.isLoggable(Level.FINEST);
        if (this.changedPreferences != null && this.changedPreferences.containsKey(string)) {
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "getValues", "Preference " + string + " has recently changed.");
            }
            String[] stringArray2 = StringUtils.copy((String[])this.changedPreferences.get(string));
            if (bl) {
                logger.exiting(CLASS_NAME, "getValues", stringArray2);
            }
            return stringArray2;
        }
        Preference preference = null;
        if (this.removedPreferences == null || !this.removedPreferences.contains(string)) {
            preference = this.portalPreferences.get(string);
        } else if (bl2) {
            logger.logp(Level.FINE, CLASS_NAME, "getValue", "Preference " + string + " has been recently removed.");
        }
        if (preference == null && (preference = this.portalPreferences.getDefault(string)) == null) {
            preference = this.portletXmlPreferences.get(string);
        }
        String[] stringArray3 = null;
        if (preference == null || !preference.isValueSet()) {
            if (bl2) {
                if (preference == null) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getValues", "Preference " + string + " does not exist.");
                } else {
                    logger.logp(Level.FINEST, CLASS_NAME, "getValues", "Preference " + string + " has no value.");
                }
            }
            stringArray3 = stringArray;
        } else {
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "getValues", "Preference " + string + " exists.");
            }
            stringArray3 = StringUtils.copy(this.getValuesFromPreference(preference));
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "getValues", stringArray3);
        }
        return stringArray3;
    }

    public void setValue(String string, String string2) throws ReadOnlyException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setValue", new Object[]{string, string2});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setValue", "portlet.pref.key.0");
            throw new IllegalArgumentException("key == null");
        }
        String[] stringArray = new String[]{string2};
        this.setValuesInternal(string, stringArray);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setValue");
        }
    }

    public void setValues(String string, String[] stringArray) throws ReadOnlyException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setValues", new Object[]{string, stringArray});
        }
        this.setValuesInternal(string, StringUtils.copy(stringArray));
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setValues");
        }
    }

    private void setValuesInternal(String string, String[] stringArray) throws ReadOnlyException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setValuesInternal", new Object[]{string, stringArray});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setValuesInternal", "portlet.pref.key.0");
            throw new IllegalArgumentException("key == null");
        }
        if (this.cannotWrite(string)) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setValuesInternal", "read.only.ex.1", string);
            throw new ReadOnlyException("Preference attribute called " + string + " may not be modified");
        }
        this.getChangedPreferences().put(string, StringUtils.copy(stringArray));
        if (this.removedPreferences != null) {
            this.removedPreferences.remove(string);
        }
        logger.exiting(CLASS_NAME, "setValuesInternal");
    }

    public Enumeration getNames() {
        Object object;
        logger.entering(CLASS_NAME, "getNames");
        boolean bl = logger.isLoggable(Level.FINEST);
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = this.portalPreferences.iterator();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getNames", "Original preferences from " + this.portalPreferences);
        }
        while (iterator.hasNext()) {
            object = ((Preference)iterator.next()).getName();
            hashSet.add(object);
        }
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getNames", "Changed preferences from " + this.changedPreferences);
        }
        if (this.changedPreferences != null && !this.changedPreferences.isEmpty()) {
            hashSet.addAll(this.changedPreferences.keySet());
        }
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getNames", "Removed preferences from " + this.removedPreferences);
        }
        if (this.removedPreferences != null && !this.removedPreferences.isEmpty()) {
            hashSet.removeAll(this.removedPreferences);
        }
        iterator = this.portalPreferences.defaultIterator();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getNames", "default preferences from " + this.portalPreferences);
        }
        while (iterator.hasNext()) {
            object = ((Preference)iterator.next()).getName();
            hashSet.add(object);
        }
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getNames", "Original preferences from " + this.portletXmlPreferences);
        }
        iterator = this.portletXmlPreferences.iterator();
        while (iterator.hasNext()) {
            object = ((Preference)iterator.next()).getName();
            hashSet.add(object);
        }
        object = Collections.enumeration(hashSet);
        logger.exiting(CLASS_NAME, "getNames", object);
        return object;
    }

    public Map getMap() {
        logger.entering(CLASS_NAME, "getMap");
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, this.getValues(string, null));
        }
        logger.exiting(CLASS_NAME, "getMap", hashMap);
        return hashMap;
    }

    public void reset(String string) throws ReadOnlyException {
        logger.entering(CLASS_NAME, "reset", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "reset", "portlet.pref.key.0");
            throw new IllegalArgumentException("key == null");
        }
        if (this.cannotWrite(string)) {
            logger.logp(Level.SEVERE, CLASS_NAME, "reset", "read.only.ex.1", string);
            throw new ReadOnlyException("preference attribute called " + string + " may not be modified");
        }
        if (this.changedPreferences != null) {
            this.changedPreferences.remove(string);
        }
        this.getRemovedPreferences().add(string);
        logger.exiting(CLASS_NAME, "reset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException, ValidatorException {
        logger.entering(CLASS_NAME, "store");
        boolean bl = logger.isLoggable(Level.FINEST);
        boolean bl2 = logger.isLoggable(Level.FINER);
        if (!this.methodId.equals(Constants.METHOD_ACTION)) {
            logger.logp(Level.SEVERE, CLASS_NAME, "store", "portlet.pref.store.0");
            throw new IllegalStateException("store is only allowed inside a processAction call");
        }
        PreferencesValidator preferencesValidator = this.portletDefinition.getPreferenceSet().getPreferencesValidator();
        if (preferencesValidator != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "store", "PreferencesValidator found is " + preferencesValidator);
            }
            preferencesValidator.validate(new ValidatorPreferencesWrapper(this));
        }
        WSPreferenceSet wSPreferenceSet = this.portalPreferences;
        Object object = wSPreferenceSet;
        synchronized (object) {
            String string;
            Iterator<Object> iterator;
            PreferenceSetCtrl preferenceSetCtrl = (PreferenceSetCtrl)ControllerObjectAccess.get(wSPreferenceSet);
            if (bl2) {
                logger.logp(Level.FINER, CLASS_NAME, "store", "Storing preferences in " + wSPreferenceSet);
            }
            if (this.changedPreferences != null && !this.changedPreferences.isEmpty()) {
                if (bl2) {
                    logger.logp(Level.FINER, CLASS_NAME, "store", "Change preferences: " + this.changedPreferences);
                }
                iterator = this.changedPreferences.keySet().iterator();
                while (iterator.hasNext()) {
                    Preference preference;
                    string = (String)iterator.next();
                    String[] stringArray = (String[])this.changedPreferences.get(string);
                    ArrayList<String> arrayList = null;
                    if (stringArray != null) {
                        arrayList = new ArrayList<String>(stringArray.length);
                        for (int i = 0; i < stringArray.length; ++i) {
                            arrayList.add(stringArray[i]);
                        }
                    }
                    if ((preference = wSPreferenceSet.get(string)) != null) {
                        if (bl) {
                            logger.logp(Level.FINEST, CLASS_NAME, "store", "Updating existing preference " + preference + " with " + string + " / " + arrayList);
                        }
                        PreferenceCtrl preferenceCtrl = (PreferenceCtrl)ControllerObjectAccess.get(preference);
                        preferenceCtrl.setValues(arrayList);
                        continue;
                    }
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "store", "Adding new preference with " + string + " / " + arrayList);
                    }
                    preferenceSetCtrl.add(string, arrayList);
                }
                this.changedPreferences.clear();
            }
            if (this.removedPreferences != null && !this.removedPreferences.isEmpty()) {
                if (bl2) {
                    logger.logp(Level.FINER, CLASS_NAME, "store", "Remove preferences: " + this.removedPreferences);
                }
                iterator = this.removedPreferences.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    preferenceSetCtrl.remove(string);
                }
                this.removedPreferences.clear();
            }
        }
        if (this.portletWindow != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "store", "Storing preferences for portlet window: " + this.portletWindow);
            }
            object = (PortletWindowCtrl)ControllerObjectAccess.get(this.portletWindow);
            object.store();
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "store", "Storing preferences for portlet definition: " + this.portletDefinition);
            }
            object = (PortletDefinitionCtrl)ControllerObjectAccess.get(this.portletDefinition);
            object.store();
        }
        logger.exiting(CLASS_NAME, "store");
    }

    private String[] getValuesFromPreference(Preference preference) {
        if (preference == null) {
            return null;
        }
        List list = preference.getValues();
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private Map getChangedPreferences() {
        if (this.changedPreferences == null) {
            this.changedPreferences = new HashMap();
        }
        return this.changedPreferences;
    }

    private Set getRemovedPreferences() {
        if (this.removedPreferences == null) {
            this.removedPreferences = new HashSet();
        }
        return this.removedPreferences;
    }

    private boolean cannotWrite(String string) {
        if (this.getPreferenceAccessMode().equals(PreferenceAccessMode.WRITEABLE_TRUE)) {
            return false;
        }
        return this.isReadOnly(string);
    }

    private boolean alwaysReadOnly() {
        return this.getPreferenceAccessMode().equals(PreferenceAccessMode.WRITEABLE_FALSE);
    }

    private PreferenceAccessMode getPreferenceAccessMode() {
        if (this.prefAccessMode == null) {
            this.prefAccessMode = this.getPersistenceProvider().getPreferenceAccessMode(this.portletWindow.getPortletWindowIdentifier());
            if (this.prefAccessMode == null) {
                logger.logp(Level.SEVERE, CLASS_NAME, "getPreferenceAccessMode", "preferences.mode.null.1", this.portletWindow.getPortletWindowIdentifier());
                throw new IllegalStateException("Error occurred loading preferences access mode via the persistence provider.");
            }
        }
        return this.prefAccessMode;
    }

    private PersistenceProvider getPersistenceProvider() {
        if (this.provider == null) {
            this.provider = PersistenceProviderAccess.getProvider();
        }
        return this.provider;
    }
}

