/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.core.InternalPortletRequest;
import com.ibm.ws.portletcontainer.factory.PortletObjectAccess;
import com.ibm.ws.portletcontainer.om.portlet.CustomPortletMode;
import com.ibm.ws.portletcontainer.om.portlet.CustomWindowState;
import com.ibm.ws.portletcontainer.om.portlet.UserAttribute;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.service.information.InformationProviderAccess;
import com.ibm.ws.portletcontainer.service.property.PropertyManager;
import com.ibm.ws.portletcontainer.service.userinformation.UserInformationProviderAccess;
import com.ibm.ws.portletcontainer.util.Enumerator;
import com.ibm.ws.portletcontainer.util.NamespaceMapperAccess;
import com.ibm.ws.portletcontainer.util.StringUtils;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.services.information.InformationProvider;
import com.ibm.wsspi.portletcontainer.services.userinformation.UserInformationProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public abstract class PortletRequestImpl
extends HttpServletRequestWrapper
implements PortletRequest,
InternalPortletRequest {
    private static final String CLASS_NAME = PortletRequestImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private PortletWindow portletWindow;
    private PortletSession portletSession;
    private InformationProvider provider;
    private boolean bodyAccessed;
    private boolean included;
    private String includeQueryString;
    private PortletPreferences portletPreferences;
    private Map propertyManagerProperties;
    private boolean propertyManagerAccessed;
    private LinkedList parameterStack;
    private Map parameters;
    private Map origParameters;
    private Map portletAttributes;

    public PortletRequestImpl(PortletWindow portletWindow, HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this.portletWindow = portletWindow;
        this.parameterStack = new LinkedList();
        this.parameters = null;
        this.origParameters = this.getInformationProvider().getRequestParameterProvider(portletWindow.getPortletWindowIdentifier()).getMap();
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        logger.entering(CLASS_NAME, "isWindowStateAllowed", windowState);
        boolean bl = PortletRequestImpl.isWindowStateAllowed(windowState, this.portletWindow, this.getInformationProvider());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "isWindowStateAllowed", bl);
        }
        return bl;
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        logger.entering(CLASS_NAME, "isPortletModeAllowed", portletMode);
        boolean bl = PortletRequestImpl.isPortletModeAllowed(portletMode, this.portletWindow, this.getInformationProvider());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "isPortletModeAllowed", bl);
        }
        return bl;
    }

    public PortletMode getPortletMode() {
        logger.entering(CLASS_NAME, "getPortletMode");
        PortletMode portletMode = this.getInformationProvider().getPortletMode(this.portletWindow.getPortletWindowIdentifier());
        logger.exiting(CLASS_NAME, "getPortletMode", portletMode);
        return portletMode;
    }

    public WindowState getWindowState() {
        logger.entering(CLASS_NAME, "getWindowState");
        WindowState windowState = this.getInformationProvider().getWindowState(this.portletWindow.getPortletWindowIdentifier());
        logger.exiting(CLASS_NAME, "getWindowState", windowState);
        return windowState;
    }

    public abstract PortletPreferences getPreferences();

    protected PortletPreferences getPreferences(Integer n) {
        logger.entering(CLASS_NAME, "getPreferences");
        if (this.portletPreferences == null) {
            this.portletPreferences = PortletObjectAccess.getPortletPreferences(n, this.getPortletWindow());
        }
        logger.exiting(CLASS_NAME, "getPreferences", this.portletPreferences);
        return this.portletPreferences;
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean bl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPortletSession", bl);
        }
        HttpSession httpSession = this._getHttpServletRequest().getSession(false);
        if (this.portletSession != null && httpSession == null) {
            logger.logp(Level.FINEST, CLASS_NAME, "getPortletSession", "No HttpSession is available.");
            this.portletSession = null;
        } else if (httpSession != null) {
            logger.logp(Level.FINEST, CLASS_NAME, "getPortletSession", "HttpSession is available.");
            bl = true;
        }
        if (bl && this.portletSession == null) {
            logger.logp(Level.FINEST, CLASS_NAME, "getPortletSession", "Creating HttpSession, if not yet available.");
            httpSession = this._getHttpServletRequest().getSession(bl);
            if (httpSession != null) {
                logger.logp(Level.FINEST, CLASS_NAME, "getPortletSession", "Creating PortletSession.");
                this.portletSession = PortletObjectAccess.getPortletSession(this.portletWindow, httpSession);
            }
        }
        logger.exiting(CLASS_NAME, "getPortletSession", this.portletSession);
        return this.portletSession;
    }

    public String getProperty(String string) {
        logger.entering(CLASS_NAME, "getProperty", string);
        if (string == null) {
            logger.logp(Level.WARNING, CLASS_NAME, "getProperty", "portlet.api.property.key.0");
            throw new IllegalArgumentException("Attribute name == null");
        }
        String string2 = this._getHttpServletRequest().getHeader(string);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getProperty", "Properties received from request header:" + string2);
        }
        if (string2 == null) {
            String[] stringArray;
            if (!this.propertyManagerAccessed) {
                this.propertyManagerAccessed = true;
                this.propertyManagerProperties = PropertyManager.getRequestProperties(this.portletWindow);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "getProperty", "Properties received from PropertyManager:" + this.propertyManagerProperties);
            }
            if (this.propertyManagerProperties != null && (stringArray = (String[])this.propertyManagerProperties.get(string)) != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
        }
        logger.exiting(CLASS_NAME, "getProperty", string2);
        return string2;
    }

    public Enumeration getProperties(String string) {
        String[] stringArray;
        logger.entering(CLASS_NAME, "getProperties", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getProperties", "portlet.api.property.key.0");
            throw new IllegalArgumentException("Property name == null");
        }
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this._getHttpServletRequest().getHeaders(string);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getProperties", "Properties received from request header:" + enumeration);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
        }
        Map map = PropertyManager.getRequestProperties(this.portletWindow);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getProperties", "Properties received from PropertyManager:" + map);
        }
        if (map != null && (stringArray = (String[])map.get(string)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        stringArray = Collections.enumeration(hashSet);
        logger.exiting(CLASS_NAME, "getProperties", stringArray);
        return stringArray;
    }

    public Enumeration getPropertyNames() {
        logger.entering(CLASS_NAME, "getPropertyNames");
        HashSet<Object> hashSet = new HashSet<Object>();
        Map map = PropertyManager.getRequestProperties(this.portletWindow);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getPropertyNames", "Properties received from PropertyManager:" + map);
        }
        if (map != null) {
            hashSet.addAll(map.keySet());
        }
        Enumeration enumeration = this._getHttpServletRequest().getHeaderNames();
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getPropertyNames", "Properties received from request header:" + enumeration);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
        }
        Enumeration enumeration2 = Collections.enumeration(hashSet);
        logger.exiting(CLASS_NAME, "getPropertyNames", enumeration2);
        return enumeration2;
    }

    public PortalContext getPortalContext() {
        logger.entering(CLASS_NAME, "getPortalContext");
        PortalContext portalContext = PortletObjectAccess.getPortalContext();
        logger.exiting(CLASS_NAME, "getPortalContext", portalContext);
        return portalContext;
    }

    public String getAuthType() {
        return this._getHttpServletRequest().getAuthType();
    }

    public String getContextPath() {
        logger.entering(CLASS_NAME, "getContextPath");
        String string = this.portletWindow.getPortletDefinition().getPortletApplicationDefinition().getWebApplicationDefinition().getContextRoot();
        logger.exiting(CLASS_NAME, "getContextPath", string);
        return string;
    }

    public String getRemoteUser() {
        return this._getHttpServletRequest().getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this._getHttpServletRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String string) {
        return this._getHttpServletRequest().isUserInRole(string);
    }

    public Object getAttribute(String string) {
        logger.entering(CLASS_NAME, "getAttribute", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getAttribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("Attribute name == null");
        }
        Object object = this.getPortletAttributes().get(string);
        if (object == null && this.isNameReserved(string)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getAttribute", "Trying to get attribute from HttpServletRequest.");
            object = this._getHttpServletRequest().getAttribute(string);
        }
        if (object == null && "javax.portlet.userinfo".equals(string)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getAttribute", "Trying to get User Information.");
            UserInformationProvider userInformationProvider = UserInformationProviderAccess.getProvider();
            if (userInformationProvider != null) {
                HashSet<String> hashSet = null;
                List list = this.portletWindow.getPortletDefinition().getPortletApplicationDefinition().getUserAttributes();
                if (list != null) {
                    hashSet = new HashSet<String>(list.size());
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        UserAttribute userAttribute = (UserAttribute)iterator.next();
                        hashSet.add(userAttribute.getName());
                    }
                }
                object = userInformationProvider.getUserInformation(hashSet);
                this.setAttribute("javax.portlet.userinfo", object);
            }
        }
        logger.exiting(CLASS_NAME, "getAttribute", object);
        return object;
    }

    public Enumeration getAttributeNames() {
        logger.entering(CLASS_NAME, "getAttributeNames");
        Set set = this.getPortletAttributes().keySet();
        logger.exiting(CLASS_NAME, "getAttributeNames", set);
        return Collections.enumeration(set);
    }

    public String getParameter(String string) {
        logger.entering(CLASS_NAME, "getParameter", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getParameter", "portlet.api.param.0");
            throw new IllegalArgumentException("Parameter name == null");
        }
        String[] stringArray = (String[])this.getParameterMapInternal().get(string);
        logger.exiting(CLASS_NAME, "getParameter", stringArray);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        logger.entering(CLASS_NAME, "getParameterNames");
        Set set = this.getParameterMapInternal().keySet();
        logger.exiting(CLASS_NAME, "getParameterNames", set);
        return Collections.enumeration(set);
    }

    public String[] getParameterValues(String string) {
        logger.entering(CLASS_NAME, "getParameterValues", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getParameterValues", "portlet.api.param.0");
            throw new IllegalArgumentException("Parameter name == null");
        }
        String[] stringArray = StringUtils.copy((String[])this.getParameterMapInternal().get(string));
        logger.exiting(CLASS_NAME, "getParameterValues", stringArray);
        return stringArray;
    }

    public Map getParameterMap() {
        logger.entering(CLASS_NAME, "getParameterMap");
        Map map = StringUtils.copyParameters(this.getParameterMapInternal());
        logger.exiting(CLASS_NAME, "getParameterMap", map);
        return map;
    }

    public boolean isSecure() {
        return this._getHttpServletRequest().isSecure();
    }

    public void setAttribute(String string, Object object) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "setAttribute", new Object[]{string, object});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setAtribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("Attribute name == null");
        }
        if (object == null) {
            this.removeAttribute(string);
        } else if (this.isNameReserved(string)) {
            logger.logp(Level.FINEST, CLASS_NAME, "setAtribute", "Setting attribute to HttpServletRequest directly.");
            this._getHttpServletRequest().setAttribute(string, object);
        } else {
            logger.logp(Level.FINEST, CLASS_NAME, "setAtribute", "Setting attribute to HttpServletRequest after namespacing.");
            this.getPortletAttributes().put(string, object);
        }
        logger.exiting(CLASS_NAME, "setAttribute");
    }

    public void removeAttribute(String string) {
        logger.entering(CLASS_NAME, "removeAttribute", string);
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "removeAtribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("Attribute name == null");
        }
        if (this.isNameReserved(string)) {
            logger.logp(Level.FINEST, CLASS_NAME, "removeAttribute", "Remove attribute from HttpServletRequest directly.");
            this._getHttpServletRequest().removeAttribute(string);
        } else {
            logger.logp(Level.FINEST, CLASS_NAME, "removeAttribute", "Remove attribute from HttpServletRequest after namespacing.");
            this.getPortletAttributes().remove(string);
        }
        logger.exiting(CLASS_NAME, "removeAttribute");
    }

    public String getRequestedSessionId() {
        return this._getHttpServletRequest().getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this._getHttpServletRequest().isRequestedSessionIdValid();
    }

    public String getResponseContentType() {
        logger.entering(CLASS_NAME, "getResponseContentType");
        String string = this.getInformationProvider().getContentTypeProvider(this.portletWindow.getPortletWindowIdentifier()).getResponseContentType();
        logger.exiting(CLASS_NAME, "getResponseContentType", string);
        return string;
    }

    public Enumeration getResponseContentTypes() {
        logger.entering(CLASS_NAME, "getResponseContentTypes");
        List list = this.getInformationProvider().getContentTypeProvider(this.portletWindow.getPortletWindowIdentifier()).getResponseContentTypes();
        logger.exiting(CLASS_NAME, "getResponseContentTypes", list);
        return new Enumerator(list);
    }

    public Locale getLocale() {
        return this.getInformationProvider().getLocale();
    }

    public Enumeration getLocales() {
        return this.getInformationProvider().getLocales();
    }

    public String getScheme() {
        return this._getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this._getHttpServletRequest().getServerName();
    }

    public int getServerPort() {
        return this._getHttpServletRequest().getServerPort();
    }

    public HttpServletRequest lateInit(HttpServletRequest httpServletRequest) {
        logger.entering(CLASS_NAME, "lateInit", httpServletRequest);
        HttpServletRequest httpServletRequest2 = this._getHttpServletRequest();
        this.setRequest((ServletRequest)httpServletRequest);
        logger.exiting(CLASS_NAME, "lateInit");
        return httpServletRequest2;
    }

    public void reverseInit(HttpServletRequest httpServletRequest) {
        logger.entering(CLASS_NAME, "lateInit", httpServletRequest);
        this.setRequest((ServletRequest)httpServletRequest);
        logger.exiting(CLASS_NAME, "lateInit");
    }

    public PortletWindow getPortletWindow() {
        return this.portletWindow;
    }

    public void setIncluded(boolean bl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setIncluded", bl);
        }
        this.included = bl;
        logger.exiting(CLASS_NAME, "setIncluded");
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncludeQueryString(String string) {
        this.includeQueryString = string;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._getHttpServletRequest();
    }

    public void pushParameterState() {
        this.parameterStack.addFirst(this.parameters);
        this.parameters = null;
    }

    public void popParameterState() {
        this.parameters = (HashMap)this.parameterStack.removeFirst();
    }

    protected final InformationProvider getInformationProvider() {
        if (this.provider == null) {
            this.provider = InformationProviderAccess.getProvider();
        }
        return this.provider;
    }

    private HttpServletRequest _getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    private boolean isNameReserved(String string) {
        return string.startsWith("java.") || string.startsWith("javax.");
    }

    private Map getParameterMapInternal() {
        logger.entering(CLASS_NAME, "getParameterMapInternal");
        this.bodyAccessed = true;
        if (this.parameters == null) {
            this.parameters = new HashMap(this.origParameters);
            this.tweakParameterMap(this.parameters);
        }
        logger.exiting(CLASS_NAME, "getParameterMapInternal", this.parameters);
        return this.parameters;
    }

    protected void tweakParameterMap(Map map) {
    }

    public String getCharacterEncoding() {
        if (this.included) {
            return null;
        }
        return this._getHttpServletRequest().getCharacterEncoding();
    }

    public String getContentType() {
        if (this.included) {
            return null;
        }
        return this.getInformationProvider().getContentTypeProvider(this.portletWindow.getPortletWindowIdentifier()).getRequestContentType();
    }

    public int getContentLength() {
        if (this.included) {
            return 0;
        }
        return this._getHttpServletRequest().getContentLength();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.included) {
            return null;
        }
        BufferedReader bufferedReader = this._getHttpServletRequest().getReader();
        this.bodyAccessed = true;
        return bufferedReader;
    }

    public Cookie[] getCookies() {
        return this._getHttpServletRequest().getCookies();
    }

    public long getDateHeader(String string) {
        return this._getHttpServletRequest().getDateHeader(string);
    }

    public String getHeader(String string) {
        return this._getHttpServletRequest().getHeader(string);
    }

    public Enumeration getHeaders(String string) {
        return this._getHttpServletRequest().getHeaders(string);
    }

    public Enumeration getHeaderNames() {
        return this._getHttpServletRequest().getHeaderNames();
    }

    public int getIntHeader(String string) {
        return this._getHttpServletRequest().getIntHeader(string);
    }

    public String getPathInfo() {
        if (this.included) {
            return (String)super.getAttribute("javax.servlet.include.path_info");
        }
        return super.getPathInfo();
    }

    public String getPathTranslated() {
        if (this.included) {
            String string = this.getPathInfo();
            if (string != null) {
                try {
                    ServletContext servletContext = this.portletWindow.getPortletDefinition().getPortletApplicationDefinition().getWebApplicationDefinition().getServletContext();
                    return servletContext.getRealPath(string);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.portletcontainer.core.impl.PortletRequestImpl.getPathTranslated", (String)"783", (Object)this);
                    logger.logp(Level.FINE, CLASS_NAME, "getPathTranslated", "Exception occured during getPathTranslated", throwable);
                }
            }
            return null;
        }
        return super.getPathTranslated();
    }

    public String getRequestURI() {
        String string = (String)super.getAttribute("javax.servlet.include.request_uri");
        if (string == null) {
            return super.getRequestURI();
        }
        return string;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        String string = (String)super.getAttribute("javax.servlet.include.servlet_path");
        return string != null ? string : super.getServletPath();
    }

    public HttpSession getSession(boolean bl) {
        return this._getHttpServletRequest().getSession(bl);
    }

    public HttpSession getSession() {
        return this._getHttpServletRequest().getSession();
    }

    public String getMethod() {
        if (this.isIncluded()) {
            return "GET";
        }
        return this._getHttpServletRequest().getMethod();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._getHttpServletRequest().isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._getHttpServletRequest().isRequestedSessionIdFromCookie();
    }

    public String getProtocol() {
        return null;
    }

    public String getQueryString() {
        if (this.included) {
            return this.includeQueryString;
        }
        return this._getHttpServletRequest().getQueryString();
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRealPath(String string) {
        return null;
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this.bodyAccessed) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setCharacterEncoding", "set.character.encoding.error.0");
            throw new IllegalStateException("This method must not be called after the HTTP-Body was accessed !");
        }
        this._getHttpServletRequest().setCharacterEncoding(string);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.included) {
            return null;
        }
        ServletInputStream servletInputStream = this._getHttpServletRequest().getInputStream();
        this.bodyAccessed = true;
        return servletInputStream;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return this._getHttpServletRequest().getRequestDispatcher(string);
    }

    private Map getPortletAttributes() {
        if (this.portletAttributes == null) {
            String string = NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(IdentifierNamespace.REQUEST), "attr");
            this.portletAttributes = (Map)this._getHttpServletRequest().getAttribute(string);
            if (this.portletAttributes == null) {
                this.portletAttributes = new HashMap();
                this._getHttpServletRequest().setAttribute(string, (Object)this.portletAttributes);
            }
        }
        return this.portletAttributes;
    }

    static boolean isPortletModeAllowed(PortletMode portletMode, PortletWindow portletWindow, InformationProvider informationProvider) {
        Object object;
        boolean bl = logger.isLoggable(Level.FINER);
        boolean bl2 = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.entering(CLASS_NAME, "isPortletModeAllowed", new Object[]{portletMode, portletWindow, informationProvider});
        }
        if (portletMode == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "isPortletModeAllowed", "portlet.api.portlet.mode.0");
            throw new IllegalArgumentException("portlet mode must not be null");
        }
        boolean bl3 = portletWindow.getPortletDefinition().getContentTypeSet().supportsPortletMode(portletMode);
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "isPortletModeAllowed", "Portlet mode supported by portlet: " + bl3);
        }
        if (bl3 && !PortletRequestImpl.isStandardPortletMode(portletMode)) {
            bl3 = false;
            object = portletMode.toString();
            Iterator iterator = portletWindow.getPortletDefinition().getPortletApplicationDefinition().getCustomPortletModes().iterator();
            while (!bl3 && iterator.hasNext()) {
                bl3 = ((String)object).equalsIgnoreCase(((CustomPortletMode)iterator.next()).getModeName());
            }
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "isPortletModeAllowed", "Custom portlet mode allowed by portlet: " + bl3);
            }
        }
        if (bl3 && (object = informationProvider.getAllowedPortletModes(portletWindow.getPortletWindowIdentifier())) != null) {
            bl3 = object.contains(portletMode);
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "isPortletModeAllowed", bl3);
        }
        return bl3;
    }

    private static boolean isStandardPortletMode(PortletMode portletMode) {
        return PortletMode.VIEW.equals(portletMode) || PortletMode.EDIT.equals(portletMode) || PortletMode.HELP.equals(portletMode);
    }

    static boolean isWindowStateAllowed(WindowState windowState, PortletWindow portletWindow, InformationProvider informationProvider) {
        Object object;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "isWindowStateAllowed", new Object[]{windowState, portletWindow, informationProvider});
        }
        if (windowState == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "isWindowStateAllowed", "portlet.api.window.state.0");
            throw new IllegalArgumentException("window state must not be null");
        }
        boolean bl2 = PortletRequestImpl.isStandardWindowState(windowState);
        if (!bl2) {
            object = windowState.toString();
            Iterator iterator = portletWindow.getPortletDefinition().getPortletApplicationDefinition().getCustomWindowStates().iterator();
            while (!bl2 && iterator.hasNext()) {
                bl2 = ((String)object).equalsIgnoreCase(((CustomWindowState)iterator.next()).getStateName());
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isWindowStateAllowed", "Custom window state allowed by portlet: " + bl2);
            }
        }
        if (bl2 && (object = informationProvider.getAllowedWindowStates(portletWindow.getPortletWindowIdentifier())) != null) {
            bl2 = object.contains(windowState);
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "isWindowStateAllowed", bl2);
        }
        return bl2;
    }

    private static boolean isStandardWindowState(WindowState windowState) {
        return WindowState.MINIMIZED.equals(windowState) || WindowState.NORMAL.equals(windowState) || WindowState.MAXIMIZED.equals(windowState);
    }
}

