/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.core.InternalPortletResponse;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.service.information.InformationProviderAccess;
import com.ibm.ws.portletcontainer.service.property.PropertyManager;
import com.ibm.ws.portletcontainer.util.PrintWriterServletOutputStream;
import com.ibm.ws.portletcontainer.util.StringUtils;
import com.ibm.wsspi.portletcontainer.services.information.InformationProvider;
import com.ibm.wsspi.portletcontainer.services.information.ResourceURLProvider;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class PortletResponseImpl
extends HttpServletResponseWrapper
implements InternalPortletResponse,
PortletResponse {
    private static final String CLASS_NAME = PortletResponseImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private PortletWindow portletWindow;
    private Map properties;
    private InformationProvider provider;
    private HttpServletRequest webModuleServletRequest;
    private boolean usingWriter;
    private boolean usingStream;
    private ServletOutputStream wrappedWriter;
    private boolean included;

    public PortletResponseImpl(PortletWindow portletWindow, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.webModuleServletRequest = httpServletRequest;
        this.portletWindow = portletWindow;
    }

    public void addProperty(String string, String string2) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addProperty", new Object[]{string, string2});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "addProperty", "portlet.api.property.key.0");
            throw new IllegalArgumentException("Property key == null");
        }
        Map map = this._getProperties();
        String[] stringArray = (String[])map.get(string);
        String[] stringArray2 = null;
        if (stringArray == null) {
            stringArray2 = new String[]{string2};
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "addProperty", "Adding new Value...");
            }
            int n = stringArray.length;
            stringArray2 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n] = string2;
        }
        map.put(string, stringArray2);
        PropertyManager.setResponseProperties(this.portletWindow, map);
        logger.exiting(CLASS_NAME, "addProperty", stringArray2);
    }

    public void setProperty(String string, String string2) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setProperty", new Object[]{string, string2});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setProperty", "portlet.api.property.key.0");
            throw new IllegalArgumentException("Property key == null");
        }
        Map map = this._getProperties();
        String[] stringArray = new String[]{string2};
        map.put(string, stringArray);
        PropertyManager.setResponseProperties(this.portletWindow, map);
        logger.exiting(CLASS_NAME, "setProperty");
    }

    public String encodeURL(String string) {
        logger.entering(CLASS_NAME, "encodeURL", string);
        ResourceURLProvider resourceURLProvider = this.getInformationProvider().getResourceURLProvider(this.portletWindow.getPortletWindowIdentifier());
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "encodeURL", "Using ResourceURLProvider: " + resourceURLProvider);
        }
        String string2 = string;
        if (StringUtils.isAbsoluteURL(string)) {
            string2 = resourceURLProvider.getAbsoluteURL(string);
        } else if (string.startsWith("/")) {
            string2 = resourceURLProvider.getFullPath(string);
        } else {
            logger.logp(Level.SEVERE, CLASS_NAME, "encodeURL", "portlet.api.encodeURL.0");
            throw new IllegalArgumentException("only absolute URLs or full path URIs are allowed");
        }
        logger.exiting(CLASS_NAME, "encodeURL", string2);
        return string2;
    }

    public HttpServletResponse lateInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpServletResponse httpServletResponse2 = this._getHttpServletResponse();
        this.webModuleServletRequest = httpServletRequest;
        this.setResponse((ServletResponse)httpServletResponse);
        return httpServletResponse2;
    }

    public void reverseInit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.webModuleServletRequest = httpServletRequest;
        this.setResponse((ServletResponse)httpServletResponse);
    }

    public void setIncluded(boolean bl) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "setIncluded", bl);
            logger.exiting(CLASS_NAME, "setIncluded");
        }
        this.included = bl;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._getHttpServletResponse();
    }

    protected InformationProvider getInformationProvider() {
        if (this.provider == null) {
            this.provider = InformationProviderAccess.getProvider();
        }
        return this.provider;
    }

    protected HttpServletResponse _getHttpServletResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.webModuleServletRequest;
    }

    protected Map _getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public void addCookie(Cookie cookie) {
        this._getHttpServletResponse().addCookie(cookie);
    }

    public boolean containsHeader(String string) {
        return this._getHttpServletResponse().containsHeader(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.included ? null : this._getHttpServletResponse().encodeRedirectUrl(string);
    }

    public String encodeRedirectURL(String string) {
        return this.included ? null : this._getHttpServletResponse().encodeRedirectURL(string);
    }

    public void sendRedirect(String string) throws IOException {
        this._getHttpServletResponse().sendRedirect(string);
    }

    public void setDateHeader(String string, long l) {
        this._getHttpServletResponse().setDateHeader(string, l);
    }

    public void sendError(int n, String string) throws IOException {
        this._getHttpServletResponse().sendError(n, string);
    }

    public void sendError(int n) throws IOException {
        this._getHttpServletResponse().sendError(n);
    }

    public void addHeader(String string, String string2) {
        this._getHttpServletResponse().addHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this._getHttpServletResponse().setIntHeader(string, n);
    }

    public void addDateHeader(String string, long l) {
        this._getHttpServletResponse().addDateHeader(string, l);
    }

    public void setHeader(String string, String string2) {
        this._getHttpServletResponse().setHeader(string, string2);
    }

    public void setStatus(int n) {
        this._getHttpServletResponse().setStatus(n);
    }

    public void setStatus(int n, String string) {
        this._getHttpServletResponse().setStatus(n, string);
    }

    public void addIntHeader(String string, int n) {
        this._getHttpServletResponse().addIntHeader(string, n);
    }

    public void setContentLength(int n) {
        this._getHttpServletResponse().setContentLength(n);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public void setLocale(Locale locale) {
        this._getHttpServletResponse().setLocale(locale);
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this.usingWriter) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getOutputStream", "portlet.response.outputstream.error.0");
            throw new IllegalStateException("getPortletOutputStream can't be used after getWriter was invoked");
        }
        if (this.wrappedWriter == null) {
            this.wrappedWriter = new PrintWriterServletOutputStream(this._getHttpServletResponse().getWriter(), this._getHttpServletResponse().getCharacterEncoding());
        }
        this.usingStream = true;
        return this.wrappedWriter;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException, IllegalStateException, IOException {
        if (this.usingStream) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getWriter", "portlet.response.write.error.0");
            throw new IllegalStateException("getWriter can't be used after getOutputStream was invoked");
        }
        this.usingWriter = true;
        return this._getHttpServletResponse().getWriter();
    }

    public PortletWindow getPortletWindow() {
        return this.portletWindow;
    }

    public Map getProperties() {
        if (this.properties == null) {
            return Collections.EMPTY_MAP;
        }
        return this.properties;
    }
}

