/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.factory.PortletObjectAccess;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.util.SessionSerializationTracer;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.PortletSessionUtil;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class PortletSessionImpl
implements PortletSession {
    private static final String CLASS_NAME = PortletSessionImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static final int DEFAULT_SCOPE = 2;
    private static final String PORTLET_SCOPE_PREFIX = "javax.portlet.p.";
    private static final int PORTLET_SCOPE_PREFIX_LENGTH = "javax.portlet.p.".length();
    private HttpSession httpSession;
    private PortletContext portletContext = null;
    private PortletWindow portletWindow;
    private String portletWindowId;

    public PortletSessionImpl(PortletWindow portletWindow, HttpSession httpSession) {
        this.portletWindow = portletWindow;
        this.portletWindowId = portletWindow.getId(IdentifierNamespace.SESSION).toString();
        this.httpSession = httpSession;
    }

    public Object getAttribute(String string) {
        logger.entering(CLASS_NAME, "getAttribute", string);
        Object object = this.getAttribute(string, 2);
        logger.exiting(CLASS_NAME, "getAttribute", object);
        return object;
    }

    public Enumeration getAttributeNames() {
        logger.entering(CLASS_NAME, "getAttributeNames");
        Enumeration enumeration = this.getAttributeNames(2);
        logger.exiting(CLASS_NAME, "getAttributeNames", enumeration);
        return enumeration;
    }

    public long getCreationTime() throws IllegalStateException {
        return this.httpSession.getCreationTime();
    }

    public String getId() throws IllegalStateException {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() throws IllegalStateException {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public void invalidate() throws IllegalStateException {
        this.httpSession.invalidate();
    }

    public boolean isNew() throws IllegalStateException {
        return this.httpSession.isNew();
    }

    public void removeAttribute(String string) {
        logger.entering(CLASS_NAME, "removeAttribute", string);
        this.removeAttribute(string, 2);
        logger.exiting(CLASS_NAME, "removeAttribute");
    }

    public void setAttribute(String string, Object object) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setAttribute", new Object[]{string, object});
        }
        this.setAttribute(string, object, 2);
        logger.exiting(CLASS_NAME, "setAttribute");
    }

    public void setMaxInactiveInterval(int n) {
        this.httpSession.setMaxInactiveInterval(n);
    }

    public Object getAttribute(String string, int n) throws IllegalStateException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttribute", new Object[]{string, new Integer(n)});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getAttribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("name must not be null");
        }
        if (n == 1) {
            logger.exiting(CLASS_NAME, "getAttribute", this.httpSession.getAttribute(string));
            return this.httpSession.getAttribute(string);
        }
        Object object = this.httpSession.getAttribute(this.encodeScopedAttributeName(string));
        logger.exiting(CLASS_NAME, "getAttribute", object);
        return object;
    }

    public Enumeration getAttributeNames(int n) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttributeNames", new Integer(n));
        }
        if (n == 1) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASS_NAME, "getAttributeNames", this.httpSession.getAttributeNames());
            }
            return this.httpSession.getAttributeNames();
        }
        Enumeration enumeration = this.httpSession.getAttributeNames();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            int n2 = PortletSessionUtil.decodeScope(string2);
            if (n2 != 2 || !string2.startsWith(this.portletWindowId, PORTLET_SCOPE_PREFIX_LENGTH) || (string = PortletSessionUtil.decodeAttributeName(string2)) == null) continue;
            vector.add(string);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "getAttributeNames", vector.elements());
        }
        return vector.elements();
    }

    public void removeAttribute(String string, int n) throws IllegalStateException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "removeAttribute", new Object[]{string, new Integer(n)});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "removeAttribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("name must not be null");
        }
        if (n == 1) {
            this.httpSession.removeAttribute(string);
        } else {
            this.httpSession.removeAttribute(this.encodeScopedAttributeName(string));
        }
        logger.exiting(CLASS_NAME, "removeAttribute");
    }

    public void setAttribute(String string, Object object, int n) throws IllegalStateException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setAttribute", new Object[]{string, object, new Integer(n)});
        }
        if (string == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setAttribute", "portlet.api.attribute.0");
            throw new IllegalArgumentException("name must not be null");
        }
        SessionSerializationTracer.check(string, object);
        if (n == 1) {
            this.httpSession.setAttribute(string, object);
        } else {
            this.httpSession.setAttribute(this.encodeScopedAttributeName(string), object);
        }
        logger.exiting(CLASS_NAME, "setAttribute");
    }

    public PortletContext getPortletContext() {
        return this.getInternalPortletContext();
    }

    public ServletContext getServletContext() {
        return this.httpSession.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this.httpSession.getSessionContext();
    }

    public Object getValue(String string) {
        return this.getAttribute(string, 2);
    }

    public String[] getValueNames() {
        return null;
    }

    public void putValue(String string, Object object) {
        this.setAttribute(string, object, 2);
    }

    public void removeValue(String string) {
        this.removeAttribute(string, 2);
    }

    private final String encodeScopedAttributeName(String string) {
        return PORTLET_SCOPE_PREFIX + this.portletWindowId + "?" + string;
    }

    private synchronized PortletContext getInternalPortletContext() {
        if (this.portletContext == null) {
            this.portletContext = PortletObjectAccess.getPortletContext(this.getServletContext(), this.portletWindow.getPortletDefinition().getPortletApplicationDefinition());
        }
        return this.portletContext;
    }
}

