/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.core.impl.PortletRequestImpl;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.service.information.InformationProviderAccess;
import com.ibm.ws.portletcontainer.util.StringUtils;
import com.ibm.wsspi.portletcontainer.services.information.InformationProvider;
import com.ibm.wsspi.portletcontainer.services.information.PortletURLProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletURLImpl
implements PortletURL {
    private InformationProvider provider;
    private PortletURLProvider urlprovider;
    private PortletMode mode;
    private Map parameters;
    private PortletWindow portletWindow;
    private boolean secure;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private WindowState state;
    private boolean isAction;
    private static final String CLASS_NAME = PortletURLImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public PortletURLImpl(PortletWindow portletWindow, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        this.portletWindow = portletWindow;
        this.servletRequest = httpServletRequest;
        this.servletResponse = httpServletResponse;
        this.secure = httpServletRequest.isSecure();
        this.isAction = bl;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        logger.entering(CLASS_NAME, "setWindowState", windowState);
        if (!PortletRequestImpl.isWindowStateAllowed(windowState, this.portletWindow, this._getInformationProvider())) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setWindowState", "set.unsupported.window.state.1", windowState);
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.state = windowState;
        logger.exiting(CLASS_NAME, "setWindowState");
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        logger.entering(CLASS_NAME, "setPortletMode", portletMode);
        if (!PortletRequestImpl.isPortletModeAllowed(portletMode, this.portletWindow, this._getInformationProvider())) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setPortletMode", "set.unsupported.portlet.mode.1", portletMode);
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.mode = portletMode;
        logger.exiting(CLASS_NAME, "setPortletMode");
    }

    public void setParameter(String string, String string2) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setParameter", new Object[]{string, string2});
        }
        if (string == null || string2 == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setParameter", "set.render.parameter.entry.key.0");
            throw new IllegalArgumentException("name and value must not be null");
        }
        this._getParameters().put(string, new String[]{string2});
        logger.exiting(CLASS_NAME, "setParameter");
    }

    public void setParameter(String string, String[] stringArray) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setParameter", new Object[]{string, stringArray});
        }
        if (string == null || stringArray == null || stringArray.length == 0) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setParameter", "set.render.param.array.entry.key.0");
            throw new IllegalArgumentException("name and values must not be null or values be an empty array");
        }
        this._getParameters().put(string, StringUtils.copy(stringArray));
        logger.exiting(CLASS_NAME, "setParameter");
    }

    public void setParameters(Map map) {
        logger.entering(CLASS_NAME, "setParameters", map);
        if (map == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setParameters", "portlet.api.param.0");
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getKey() instanceof String)) {
                logger.logp(Level.SEVERE, CLASS_NAME, "setParameters", "set.render.param.array.entry.key.0");
                throw new IllegalArgumentException("Key must not be null and of type java.lang.String.");
            }
            if (entry.getValue() instanceof String[]) continue;
            logger.logp(Level.SEVERE, CLASS_NAME, "setParameters", "set.render.param.array.entry.key.0");
            throw new IllegalArgumentException("Value must not be null and of type java.lang.String[].");
        }
        this.parameters = StringUtils.copyParameters(map);
        logger.exiting(CLASS_NAME, "setParameters");
    }

    public void setSecure(boolean bl) throws PortletSecurityException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setSecure", bl);
        }
        if (!this._getPortletURLProvider().isSecuritySupported()) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setSecure", "secure.environment.0");
            throw new PortletSecurityException("Security not supported by current environment.");
        }
        this.secure = bl;
        logger.exiting(CLASS_NAME, "setSecure");
    }

    public String toString() {
        logger.entering(CLASS_NAME, "toString");
        PortletURLProvider portletURLProvider = this._getPortletURLProvider();
        if (this.mode != null) {
            portletURLProvider.setPortletMode(this.mode);
        }
        if (this.state != null) {
            portletURLProvider.setWindowState(this.state);
        }
        if (this.isAction) {
            portletURLProvider.setAction();
        }
        if (this.secure) {
            portletURLProvider.setSecure();
        }
        if (this.parameters != null) {
            portletURLProvider.setParameters(this.parameters);
        }
        String string = ((Object)portletURLProvider).toString();
        logger.exiting(CLASS_NAME, "toString", string);
        return string;
    }

    private InformationProvider _getInformationProvider() {
        if (this.provider == null) {
            this.provider = InformationProviderAccess.getProvider();
        }
        return this.provider;
    }

    private PortletURLProvider _getPortletURLProvider() {
        if (this.urlprovider == null) {
            this.urlprovider = this._getInformationProvider().getPortletURLProvider(this.portletWindow.getPortletWindowIdentifier());
        }
        return this.urlprovider;
    }

    private Map _getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        return this.parameters;
    }

    public String getParameter(String string) {
        String[] stringArray = this.getParameters(string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getParameters(String string) {
        if (this.parameters == null) {
            return null;
        }
        return (String[])this.parameters.get(string);
    }

    public PortletMode getPortletMode() {
        return this.mode;
    }

    public WindowState getWindowState() {
        return this.state;
    }
}

