/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.core.impl.PortletResponseImpl;
import com.ibm.ws.portletcontainer.factory.PortletObjectAccess;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.service.title.DynamicTitleAccess;
import com.ibm.ws.portletcontainer.util.NamespaceMapperAccess;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RenderResponseImpl
extends PortletResponseImpl
implements RenderResponse {
    private static final String illegalStateExceptionText = "No content type set.";
    private static final String CLASS_NAME = RenderResponseImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private String contentType;

    public RenderResponseImpl(PortletWindow portletWindow, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        super(portletWindow, httpServletRequest, httpServletResponse);
    }

    public String getContentType() {
        logger.entering(CLASS_NAME, "getContentType");
        String string = this.contentType;
        logger.exiting(CLASS_NAME, "getContentType", string);
        return string;
    }

    public PortletURL createRenderURL() {
        logger.entering(CLASS_NAME, "createRenderURL");
        PortletURL portletURL = this.createURL(false);
        logger.exiting(CLASS_NAME, "createRenderURL", portletURL);
        return portletURL;
    }

    public PortletURL createActionURL() {
        logger.entering(CLASS_NAME, "createActionURL");
        PortletURL portletURL = this.createURL(true);
        logger.exiting(CLASS_NAME, "createActionURL", portletURL);
        return portletURL;
    }

    public String getNamespace() {
        logger.entering(CLASS_NAME, "getNamespace");
        String string = NamespaceMapperAccess.getNamespaceMapper().encode(this.getPortletWindow().getId(IdentifierNamespace.MARKUP), "");
        logger.exiting(CLASS_NAME, "getNamespace", string);
        return string;
    }

    public void setTitle(String string) {
        logger.entering(CLASS_NAME, "setTitle", string);
        DynamicTitleAccess.setDynamicTitle(this.getPortletWindow(), this.getHttpServletRequest(), string);
        logger.exiting(CLASS_NAME, "setTitle");
    }

    public void setContentType(String string) {
        logger.entering(CLASS_NAME, "setContentType", string);
        String string2 = this.stripCharacterEncoding(string);
        if (!this.isValidContentType(string2)) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setContentType", "invalid.content.type.0");
            throw new IllegalArgumentException(string2);
        }
        this.getInformationProvider().getContentTypeProvider(this.getPortletWindow().getPortletWindowIdentifier()).setResponseContentType(string2);
        this.contentType = string2;
        logger.exiting(CLASS_NAME, "setContentType");
    }

    public String getCharacterEncoding() {
        return this._getHttpServletResponse().getCharacterEncoding();
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this.contentType == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getCharacterEncoding", "invalid.content.type.0");
            throw new IllegalStateException(illegalStateExceptionText);
        }
        return super.getWriter();
    }

    public Locale getLocale() {
        logger.entering(CLASS_NAME, "getLocale");
        Locale locale = this.getInformationProvider().getLocale();
        logger.exiting(CLASS_NAME, "getLocale", locale);
        return locale;
    }

    public void setBufferSize(int n) {
        logger.logp(Level.SEVERE, CLASS_NAME, "setBufferSize", "common.unsupported.operation.1", "buffering");
        throw new IllegalStateException("portlet container does not support buffering");
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
        this._getHttpServletResponse().flushBuffer();
    }

    public void resetBuffer() {
        this._getHttpServletResponse().resetBuffer();
    }

    public boolean isCommitted() {
        return this._getHttpServletResponse().isCommitted();
    }

    public void reset() {
        this._getHttpServletResponse().reset();
    }

    public OutputStream getPortletOutputStream() throws IOException, IllegalStateException {
        if (this.contentType == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getPortletOutputStream", "invalid.content.type.0");
            throw new IllegalStateException(illegalStateExceptionText);
        }
        return this.getOutputStream();
    }

    private PortletURL createURL(boolean bl) {
        return PortletObjectAccess.getPortletURL(this.getPortletWindow(), this.getHttpServletRequest(), this._getHttpServletResponse(), bl);
    }

    private boolean isValidContentType(String string) {
        Iterator iterator = this.getInformationProvider().getContentTypeProvider(this.getPortletWindow().getPortletWindowIdentifier()).getResponseContentTypes().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String stripCharacterEncoding(String string) {
        int n = string.indexOf(59);
        String string2 = n == -1 ? string : string.substring(0, n);
        return string2.trim();
    }
}

