/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.websphere.servlet.event.ServletInvocationEvent;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.ws.portletcontainer.core.CoreUtils;
import com.ibm.ws.portletcontainer.core.InternalPortletRequest;
import java.util.logging.Logger;
import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;

public class ServletInvocationListenerImpl
implements ServletInvocationListener {
    private static final String CLASS_NAME = ServletInvocationListenerImpl.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public void onServletStartService(ServletInvocationEvent servletInvocationEvent) {
        LOGGER.entering(CLASS_NAME, "onServletStartService", servletInvocationEvent);
        InternalPortletRequest internalPortletRequest = this.getInternalPortletRequest((ServletRequest)servletInvocationEvent.getRequest());
        if (internalPortletRequest != null && internalPortletRequest.isIncluded()) {
            internalPortletRequest.pushParameterState();
        }
        LOGGER.exiting(CLASS_NAME, "onServletStartService");
    }

    public void onServletFinishService(ServletInvocationEvent servletInvocationEvent) {
        LOGGER.entering(CLASS_NAME, "onServletFinishService", servletInvocationEvent);
        InternalPortletRequest internalPortletRequest = this.getInternalPortletRequest((ServletRequest)servletInvocationEvent.getRequest());
        if (internalPortletRequest != null && internalPortletRequest.isIncluded()) {
            internalPortletRequest.popParameterState();
        }
        LOGGER.exiting(CLASS_NAME, "onServletFinishService");
    }

    private InternalPortletRequest getInternalPortletRequest(ServletRequest servletRequest) {
        PortletRequest portletRequest = (PortletRequest)servletRequest.getAttribute("javax.portlet.request");
        if (portletRequest == null) {
            return null;
        }
        return CoreUtils.getInternalRequest(portletRequest);
    }
}

