/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.deploytask;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMHelper {
    private static final String CLASS_NAME = DOMHelper.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private static final String LINESEP = System.getProperty("line.separator");

    static void printElement(Element element) {
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer stringBuffer = new StringBuffer(8192);
            DOMHelper.printElement(element, 0, stringBuffer);
            logger.logp(Level.FINEST, CLASS_NAME, "printElement", stringBuffer.toString());
        }
    }

    private static void printElement(Element element, int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        NodeList nodeList = element.getChildNodes();
        stringBuffer.append(LINESEP);
        for (n3 = 0; n3 < n * 2; ++n3) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("<");
        stringBuffer.append(element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (n2 = namedNodeMap.getLength() - 1; n2 >= 0; --n2) {
                stringBuffer.append(" " + namedNodeMap.item(n2).getNodeName());
                stringBuffer.append("=" + namedNodeMap.item(n2).getNodeValue());
            }
        }
        if (element.hasChildNodes()) {
            stringBuffer.append(">");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                if (nodeList.item(n2).getNodeType() == 1) {
                    DOMHelper.printElement((Element)nodeList.item(n2), n + 1, stringBuffer);
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (nodeList.item(n2).getNodeType() != 3) continue;
                stringBuffer.append(nodeList.item(n2).getNodeValue());
                bl2 = true;
            }
            stringBuffer.append("");
        }
        if (bl) {
            stringBuffer.append(LINESEP);
            for (n3 = 0; n3 < n * 2; ++n3) {
                stringBuffer.append(" ");
            }
        }
        if (bl2 | bl) {
            stringBuffer.append("</");
            stringBuffer.append(element.getNodeName());
            stringBuffer.append(">");
        } else {
            stringBuffer.append("/>");
        }
    }
}

