/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.deploytask;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.portletcontainer.deploytask.XMLParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PortletExtXMLParser {
    private static final String CLASS_NAME = PortletExtXMLParser.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    private static boolean isPortletServingEnabled(Document document) {
        logger.entering(CLASS_NAME, "isPortletServingEnabled", document);
        boolean bl = true;
        NodeList nodeList = document.getElementsByTagName("portletappext:PortletApplicationExtension");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap;
            Node node;
            Node node2 = nodeList.item(i);
            if (!node2.hasAttributes() || (node = (namedNodeMap = node2.getAttributes()).getNamedItem("portletServingEnabled")) == null) continue;
            bl = Boolean.parseBoolean(node.getNodeValue());
            break;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "getPortletNames", Boolean.toString(bl));
        }
        return bl;
    }

    public static boolean isPortletServingEnabled(WARFile wARFile) {
        boolean bl;
        block16: {
            bl = true;
            try {
                if (wARFile.containsFile("WEB-INF/ibm-portlet-ext.xmi")) {
                    Document document = XMLParser.parse(wARFile.getFile("WEB-INF/ibm-portlet-ext.xmi"));
                    bl = PortletExtXMLParser.isPortletServingEnabled(document);
                    logger.logp(Level.FINER, CLASS_NAME, "isPortletServingEnabled", "Portlet deployment descriptor extension file found (ibm-portlet-ext.xmi) for this application.");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isPortletServingEnabled", "No portlet deployment descriptor extension file found for this application. Default configurations are used.", fileNotFoundException);
                } else {
                    logger.logp(Level.FINER, CLASS_NAME, "isPortletServingEnabled", "No portlet deployment descriptor extension file (ibm-portlet-ext.xmi) found for this application. Default configurations are used.");
                }
            }
            catch (ResourceLoadException resourceLoadException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletServingEnabled", "Failed to load portlet deployment descriptor extension file for this application. Default configurations are used.", resourceLoadException);
                }
            }
            catch (RuntimeException runtimeException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletServingEnabled", "Failed to load portlet deployment descriptor extension file for this application. Default configurations are used.", runtimeException);
                }
            }
            catch (AdminException adminException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletServingEnabled", "Failed to load portlet deployment descriptor extension file for this application. Default configurations are used.", adminException);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletServingEnabled", "Failed to load portlet deployment descriptor extension file for this application. Default configurations are used.", parserConfigurationException);
                }
            }
            catch (SAXException sAXException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletServingEnabled", "Failed to load portlet deployment descriptor extension file for this application. Default configurations are used.", sAXException);
                }
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.FINE)) break block16;
                logger.logp(Level.FINE, CLASS_NAME, "isPortletServingEnabled", "Failed to load portlet deployment descriptor extension file for this application. Default configurations are used.", iOException);
            }
        }
        return bl;
    }

    private static boolean isPortletDeploymentEnabled(File file) throws ParserConfigurationException, SAXException, IOException {
        logger.entering(CLASS_NAME, "isPortletDeploymentEnabled", file);
        WebXMLDetectionHandler webXMLDetectionHandler = new WebXMLDetectionHandler();
        XMLParser.parse(file, webXMLDetectionHandler);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "isPortletDeploymentEnabled", Boolean.toString(webXMLDetectionHandler.isPortletDeploymentEnabled()));
        }
        return webXMLDetectionHandler.isPortletDeploymentEnabled();
    }

    public static boolean isPortletDeploymentEnabled(WARFile wARFile) {
        boolean bl;
        block14: {
            bl = true;
            try {
                if (wARFile.containsFile("WEB-INF/web.xml")) {
                    bl = PortletExtXMLParser.isPortletDeploymentEnabled(wARFile.getFile("WEB-INF/web.xml"));
                    logger.logp(Level.FINER, CLASS_NAME, "isPortletDeploymentEnabled", "Web deployment descriptor file found for this application.");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isPortletDeploymentEnabled", "No web deployment descriptor file found for this application. Default configurations are used.", fileNotFoundException);
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletDeploymentEnabled", "No web deployment descriptor file (web.xml) found for this application. Default configurations are used.");
                }
            }
            catch (ResourceLoadException resourceLoadException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletDeploymentEnabled", "Failed to load web deployment descriptor file for this application. Default configurations are used.", resourceLoadException);
                }
            }
            catch (RuntimeException runtimeException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletDeploymentEnabled", "Failed to load web deployment descriptor file for this application. Default configurations are used.", runtimeException);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletDeploymentEnabled", "Failed to load web deployment descriptor file for this application. Default configurations are used.", parserConfigurationException);
                }
            }
            catch (SAXException sAXException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "isPortletDeploymentEnabled", "Failed to load web deployment descriptor file for this application. Default configurations are used.", sAXException);
                }
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.FINE)) break block14;
                logger.logp(Level.FINE, CLASS_NAME, "isPortletDeploymentEnabled", "Failed to load web deployment descriptor file for this application. Default configurations are used.", iOException);
            }
        }
        return bl;
    }

    private static class WebXMLDetectionHandler
    extends DefaultHandler {
        private static final String P_NAME = "param-name";
        private static final String P_VALUE = "param-value";
        private static final String P_CTX = "context-param";
        private static final String PD_NAME = "com.ibm.websphere.portletcontainer.PortletDeploymentEnabled";
        private int state = 0;
        private boolean isEnabled = true;

        private WebXMLDetectionHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = "".equals(string2) ? string3 : string2;
            switch (this.state) {
                case 0: {
                    if (!P_CTX.equals(string4)) break;
                    ++this.state;
                    break;
                }
                case 1: {
                    if (!P_NAME.equals(string4)) break;
                    ++this.state;
                    break;
                }
                case 3: {
                    if (!P_VALUE.equals(string4)) break;
                    ++this.state;
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = "".equals(string2) ? string3 : string2;
            switch (this.state) {
                case 1: {
                    if (!P_CTX.equals(string4)) break;
                    --this.state;
                    break;
                }
                case 2: {
                    if (!P_NAME.equals(string4)) break;
                    --this.state;
                    break;
                }
                case 3: {
                    if (!P_CTX.equals(string4)) break;
                    this.state = 5;
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (!PD_NAME.equals(new String(cArray, n, n2))) break;
                    ++this.state;
                    break;
                }
                case 4: {
                    ++this.state;
                    if (!"false".equalsIgnoreCase(new String(cArray, n, n2))) break;
                    this.isEnabled = false;
                }
            }
        }

        public boolean isPortletDeploymentEnabled() {
            return this.isEnabled;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

