/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.deploytask;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.portletcontainer.deploytask.DOMHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PortletXMLParser {
    private static final String CLASS_NAME = PortletXMLParser.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static boolean isJSR168Compliant(File file) {
        logger.entering(CLASS_NAME, "isJSR168Compliant", file);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        JSR168DetectionHandler jSR168DetectionHandler = new JSR168DetectionHandler();
        try {
            InputStream inputStream = file.getInputStream();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)jSR168DetectionHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "isJSR168Compliant", jSR168DetectionHandler.isJSR168());
        }
        return jSR168DetectionHandler.isJSR168();
    }

    public static Document parse(File file) throws AdminException, ParserConfigurationException, SAXException, IOException {
        logger.entering(CLASS_NAME, "parse", file);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, new Object[]{PortletXMLParser.createInputSource("/com/ibm/ws/portletcontainer/deployment/portlet-app_1_0.xsd", "res://portlet-app_1_0.xsd"), PortletXMLParser.createInputSource("/com/ibm/ws/portletcontainer/deployment/xml.xsd", "res://xml.xsd")});
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler());
        documentBuilder.setEntityResolver(new EntityResolver());
        Document document = documentBuilder.parse(PortletXMLParser.createInputSource(file.getInputStream(), "res://portlet.xml"));
        if (logger.isLoggable(Level.FINEST)) {
            DOMHelper.printElement(document.getDocumentElement());
        }
        logger.exiting(CLASS_NAME, "parse", document);
        return document;
    }

    public static Set getPortletNames(Document document) {
        logger.entering(CLASS_NAME, "getPortletNames", document);
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = document.getElementsByTagName("portlet-name");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeType() != 3) continue;
                hashSet.add(nodeList2.item(j).getNodeValue());
            }
        }
        logger.exiting(CLASS_NAME, "getPortletNames", hashSet);
        return hashSet;
    }

    private static InputSource createInputSource(String string, String string2) {
        return PortletXMLParser.createInputSource(PortletXMLParser.class.getResourceAsStream(string), string2);
    }

    private static InputSource createInputSource(InputStream inputStream, String string) {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return inputSource;
    }

    private static class JSR168DetectionHandler
    extends DefaultHandler {
        private boolean isJSR168 = false;
        private boolean isFirst = true;

        private JSR168DetectionHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.isFirst) {
                this.isFirst = false;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "startElement", "uri: " + string + ", localName: " + string2 + ", qName: " + string3);
                }
                this.isJSR168 = "http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd".equals(string);
            }
        }

        public boolean isJSR168() {
            return this.isJSR168;
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            logger.logp(Level.WARNING, CLASS_NAME, "warning", "install.task.parse.sax.warning.1", sAXParseException);
            throw new SAXParseException(sAXParseException.getMessage(), null);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            logger.logp(Level.WARNING, CLASS_NAME, "error", "install.task.parse.sax.error.1", sAXParseException);
            throw new SAXParseException(sAXParseException.getMessage(), null);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            logger.logp(Level.WARNING, CLASS_NAME, "fatalError", "install.task.parse.sax.fatal.error.1", sAXParseException);
            throw new SAXParseException(sAXParseException.getMessage(), null);
        }
    }

    private static class EntityResolver
    implements org.xml.sax.EntityResolver {
        private static final String[][] PUBLIC_ID_MAPPING = new String[][]{{"-//W3C//DTD XMLSCHEMA 200102//EN", "/com/ibm/ws/portletcontainer/deployment/XMLSchema.dtd", "res://XMLSchema.dtd"}, {"datatypes", "/com/ibm/ws/portletcontainer/deployment/datatypes.dtd", "res://datatypes.dtd"}};
        private static final String[][] SYSTEM_ID_MAPPING = new String[][]{{"http://www.w3.org/2001/xml.xsd", "/com/ibm/ws/portletcontainer/deployment/xml.xsd", "res://xml.xsd"}, {"XMLSchema.dtd", "/com/ibm/ws/portletcontainer/deployment/XMLSchema.dtd", "res://XMLSchema.dtd"}, {"datatypes.dtd", "/com/ibm/ws/portletcontainer/deployment/datatypes.dtd", "res://datatypes.dtd"}, {"xml.xsd", "/com/ibm/ws/portletcontainer/deployment/xml.xsd", "res://xml.xsd"}, {"portlet-app_1_0.xsd", "/com/ibm/ws/portletcontainer/deployment/portlet-app_1_0.xsd", "res://portlet-app_1_0.xsd"}};
        private final boolean isLogging = PortletXMLParser.access$200().isLoggable(Level.FINER);

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (this.isLogging) {
                logger.entering(CLASS_NAME, "resolveEntity", new Object[]{string, string2});
            }
            InputSource inputSource = null;
            if (string != null) {
                for (int i = 0; i < PUBLIC_ID_MAPPING.length; ++i) {
                    if (!string.equals(PUBLIC_ID_MAPPING[i][0])) continue;
                    inputSource = PortletXMLParser.createInputSource(EntityResolver.PUBLIC_ID_MAPPING[i][1], EntityResolver.PUBLIC_ID_MAPPING[i][2]);
                    break;
                }
                if (inputSource == null) {
                    throw new SAXException("External entity " + string + " is not permitted.");
                }
            } else if (string2 != null) {
                for (int i = 0; i < SYSTEM_ID_MAPPING.length; ++i) {
                    if (!string2.endsWith(SYSTEM_ID_MAPPING[i][0])) continue;
                    inputSource = PortletXMLParser.createInputSource(EntityResolver.SYSTEM_ID_MAPPING[i][1], EntityResolver.SYSTEM_ID_MAPPING[i][2]);
                    break;
                }
            }
            if (this.isLogging) {
                if (inputSource != null) {
                    logger.exiting(CLASS_NAME, "resolveEntity", "stream: " + inputSource.getByteStream() + ", systemId: " + inputSource.getSystemId());
                } else {
                    logger.exiting(CLASS_NAME, "resolveEntity", null);
                }
            }
            return inputSource;
        }
    }
}

