/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.ext;

import com.ibm.ws.portletcontainer.cache.CacheHelper;
import com.ibm.ws.portletcontainer.ext.ExtContextAdapter;
import com.ibm.ws.portletcontainer.om.ext.proxy.ProxyWebApplicationDefinitionImpl;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinition;
import com.ibm.ws.portletcontainer.registry.webapplicationdefinitionregistry.WebApplicationDefinitionRegistry;
import com.ibm.wsspi.portletcontainer.PortletContainerException;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaboratorChain;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContext;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExtCollaborator
implements PortletContainerInvokerCollaborator {
    private static final String CLASS_NAME = ExtCollaborator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    public void doAction(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext, PortletContainerInvokerCollaboratorChain portletContainerInvokerCollaboratorChain) throws PortletException, IOException, PortletContainerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doAction", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, portletContainerInvokerCollaboratorChain});
        }
        ExtCollaborator.processProxyDefinitions(portletWindowIdentifier.getContextRoot(), httpServletRequest.getSession().getServletContext());
        portletContainerInvokerCollaboratorChain.doCollaborator(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext);
        logger.exiting(CLASS_NAME, "doAction");
    }

    public void doRender(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext, PortletContainerInvokerCollaboratorChain portletContainerInvokerCollaboratorChain) throws PortletException, IOException, PortletContainerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doRender", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, portletContainerInvokerCollaboratorChain});
        }
        ExtCollaborator.processProxyDefinitions(portletWindowIdentifier.getContextRoot(), httpServletRequest.getSession().getServletContext());
        portletContainerContext = new ExtContextAdapter(portletContainerContext, httpServletRequest);
        portletContainerInvokerCollaboratorChain.doCollaborator(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext);
        CacheHelper.processCacheInformation(httpServletRequest);
        logger.exiting(CLASS_NAME, "doRender");
    }

    private static void processProxyDefinitions(String string, ServletContext servletContext) {
        WebApplicationDefinition webApplicationDefinition;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "processProxyDefinitions", new Object[]{string, servletContext});
        }
        if ((webApplicationDefinition = WebApplicationDefinitionRegistry.getInstance().getWebApplicationDefinition(string)) == null) {
            logger.finer("WebApplicationDefinition not found");
            String string2 = servletContext.getClass().getName();
            logger.finer("Servlet context class name: " + (string2 != null ? string2 : "null"));
            if (string2 != null && string2.equals("com.ibm.ws.rrd.context.LocalServletContextImpl")) {
                logger.finer("--> add proxy web app definition");
                WebApplicationDefinitionRegistry.getInstance().addWebApplicationDefinition(new ProxyWebApplicationDefinitionImpl(string));
            } else {
                logger.finer("--> do not add proxy web app definition");
            }
        }
        logger.exiting(CLASS_NAME, "processProxyDefinitions");
    }
}

