/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry;
import com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry;
import com.ibm.wsspi.portletcontainer.collaborator.Collaborator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;

public class ExtensionHandler
implements IRegistryChangeListener {
    private static final String CLASS_NAME = ExtensionHandler.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private Integer scope;

    public ExtensionHandler(Integer n) {
        this.scope = n;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        boolean bl = LOGGER.isLoggable(Level.FINER);
        boolean bl2 = LOGGER.isLoggable(Level.FINEST);
        if (bl) {
            LOGGER.entering(CLASS_NAME, "registryChanged", new Object[]{iRegistryChangeEvent});
        }
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        for (int i = 0; i < iExtensionDeltaArray.length; ++i) {
            IExtensionDelta iExtensionDelta = iExtensionDeltaArray[i];
            IExtension iExtension = iExtensionDelta.getExtension();
            if (iExtension == null) continue;
            IExtensionPoint iExtensionPoint = iExtensionDelta.getExtensionPoint();
            String string = iExtensionPoint.getSimpleIdentifier();
            if (bl2) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "registryChanged", "Extension Point found: " + string + "; extension: " + iExtension + "; kind: " + iExtensionDelta.getKind());
            }
            if ("portlet-document-filter-config".equals(string)) {
                ExtensionHandler.processDocumentFilter(iExtension, iExtensionDelta.getKind(), this.scope);
                continue;
            }
            if (!"collaborator-config".equals(string)) continue;
            ExtensionHandler.processCollaborator(iExtension, iExtensionDelta.getKind(), this.scope);
        }
        LOGGER.exiting(CLASS_NAME, "registryChanged");
    }

    public static void initExtensions(IExtensionRegistry iExtensionRegistry, Integer n) {
        IExtension iExtension;
        int n2;
        IExtension[] iExtensionArray;
        IExtensionPoint iExtensionPoint;
        boolean bl = LOGGER.isLoggable(Level.FINER);
        boolean bl2 = LOGGER.isLoggable(Level.FINEST);
        if (bl) {
            LOGGER.entering(CLASS_NAME, "initExtensions", new Object[]{iExtensionRegistry, n});
        }
        if ((iExtensionPoint = iExtensionRegistry.getExtensionPoint("com.ibm.ws.portletcontainer.collaborator-config")) != null) {
            iExtensionArray = iExtensionPoint.getExtensions();
            for (n2 = 0; n2 < iExtensionArray.length; ++n2) {
                iExtension = iExtensionArray[n2];
                if (bl2) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "initExtensions", "Collaborator Extension Found: " + iExtension + "; scope: " + n);
                }
                ExtensionHandler.processCollaborator(iExtension, 1, n);
            }
        } else {
            LOGGER.logp(Level.FINE, CLASS_NAME, "initExtensions", "No collaborator extension point defined!");
        }
        iExtensionPoint = iExtensionRegistry.getExtensionPoint("com.ibm.ws.portletcontainer.portlet-document-filter-config");
        if (iExtensionPoint != null) {
            iExtensionArray = iExtensionPoint.getExtensions();
            for (n2 = 0; n2 < iExtensionArray.length; ++n2) {
                iExtension = iExtensionArray[n2];
                if (bl2) {
                    LOGGER.logp(Level.FINEST, CLASS_NAME, "initExtensions", "Filter Extension Found: " + iExtension + "; scope: " + n);
                }
                ExtensionHandler.processDocumentFilter(iExtension, 1, n);
            }
        } else {
            LOGGER.logp(Level.FINE, CLASS_NAME, "initExtensions", "No document filter extension point defined!");
        }
        LOGGER.exiting(CLASS_NAME, "initExtensions");
    }

    private static void processCollaborator(IExtension iExtension, int n, Integer n2) {
        boolean bl = LOGGER.isLoggable(Level.FINER);
        boolean bl2 = LOGGER.isLoggable(Level.FINEST);
        if (bl) {
            LOGGER.entering(CLASS_NAME, "processCollaborator", new Object[]{iExtension, new Integer(n), n2});
        }
        CollaboratorRegistry collaboratorRegistry = CollaboratorRegistry.getInstance();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            if (bl2) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "processCollaborator", "parsing... name: " + iConfigurationElementArray[i].getName() + "; value: " + iConfigurationElementArray[i].getValue());
            }
            if (!iConfigurationElementArray[i].getName().equals("collaborator")) continue;
            try {
                String string = iConfigurationElementArray[i].getAttribute("order");
                switch (n) {
                    case 1: {
                        if (bl2) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processCollaborator", "found element 'collaborator'. Creating collaborator extension...");
                        }
                        Collaborator collaborator = (Collaborator)iConfigurationElementArray[i].createExecutableExtension("class-name");
                        if (bl2) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processCollaborator", "Collaborator created: " + collaborator);
                        }
                        if (collaborator != null) {
                            collaboratorRegistry.addCollaborator(collaborator, string, iExtension.getNamespace(), collaborator.getClass().getClassLoader(), n2);
                            break;
                        }
                        LOGGER.logp(Level.FINE, CLASS_NAME, "processCollaborator", "Collaborator could not be created!");
                        break;
                    }
                    case 2: {
                        String string2 = iConfigurationElementArray[i].getAttribute("class-name");
                        collaboratorRegistry.removeCollaborator(string2, string, iExtension.getNamespace());
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.portletcontainer.ext.ExtensionHandler.processCollaborator", (String)"150");
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "processCollaborator", "osgi.collaborators.init.error.0", throwable);
            }
        }
        LOGGER.exiting(CLASS_NAME, "processCollaborator");
    }

    private static void processDocumentFilter(IExtension iExtension, int n, Integer n2) {
        LOGGER.entering(CLASS_NAME, "processDocumentFilter");
        boolean bl = LOGGER.isLoggable(Level.FINEST);
        PortletFilterRegistry portletFilterRegistry = PortletFilterRegistry.getInstance();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            if (bl) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "processDocumentFilter", "parsing... name: " + iConfigurationElementArray[i].getName() + "; value: " + iConfigurationElementArray[i].getValue());
            }
            if (!iConfigurationElementArray[i].getName().equals("portlet-document-filter")) continue;
            try {
                String string = iConfigurationElementArray[i].getAttribute("order");
                switch (n) {
                    case 1: {
                        if (bl) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processDocumentFilter", "found element 'portlet-document-filter'. Creating filter extension...");
                        }
                        Filter filter = (Filter)iConfigurationElementArray[i].createExecutableExtension("class-name");
                        if (bl) {
                            LOGGER.logp(Level.FINEST, CLASS_NAME, "processDocumentFilter", "Filter created: " + filter);
                        }
                        if (filter != null) {
                            portletFilterRegistry.addPortletFilter(filter, string, iExtension.getNamespace(), filter.getClass().getClassLoader(), n2);
                            break;
                        }
                        LOGGER.logp(Level.INFO, CLASS_NAME, "processDocumentFilter", "Filter could not be created!");
                        break;
                    }
                    case 2: {
                        String string2 = iConfigurationElementArray[i].getAttribute("class-name");
                        portletFilterRegistry.removePortletFilter(string2, string, iExtension.getNamespace());
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.portletcontainer.ext.ExtensionHandler.processDocumentFilter", (String)"198");
                LOGGER.logp(Level.SEVERE, CLASS_NAME, "processDocumentFilter", "osgi.collaborators.init.error.0", throwable);
            }
        }
        LOGGER.exiting(CLASS_NAME, "processDocumentFilter");
    }
}

