/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.ext;

import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.core.CoreUtils;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.pmi.PortletPerf;
import com.ibm.ws.portletcontainer.pmi.server.proxy.ProxyPortletPerfImpl;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.collaborator.PortletCollaboratorChain;
import com.ibm.wsspi.portletcontainer.collaborator.PortletInvokerCollaborator;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class PortletInvokerPerformanceCollaborator
implements PortletInvokerCollaborator {
    private static final String CLASS_NAME = PortletInvokerPerformanceCollaborator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private static final String PC_COMPONENT_NAME = "Portlet";
    private static final String[] PC_CTXNAMES = new String[]{"Method", "WindowID", "URI"};
    private static int PORTLET_COMPONENT_ID = PmiReqMetrics.register((String)"Portlet", null, (String[])PC_CTXNAMES);

    public void doAction(ActionRequest actionRequest, ActionResponse actionResponse, PortletCollaboratorChain portletCollaboratorChain) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "doAction", new Object[]{actionRequest, actionResponse, portletCollaboratorChain});
        }
        this.doInvoke(0, actionRequest, actionResponse, portletCollaboratorChain, null, true);
        if (logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "doAction");
        }
    }

    public void doRender(RenderRequest renderRequest, RenderResponse renderResponse, PortletCollaboratorChain portletCollaboratorChain) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "doRender", new Object[]{renderRequest, renderResponse, portletCollaboratorChain});
        }
        this.doInvoke(0, renderRequest, renderResponse, portletCollaboratorChain, null, false);
        if (logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "doRender");
        }
    }

    private void doInvoke(int n, PortletRequest portletRequest, PortletResponse portletResponse, PortletCollaboratorChain portletCollaboratorChain, PortletWindow portletWindow, boolean bl) throws PortletException, IOException {
        switch (n) {
            case 0: {
                ++n;
                if (StatsFactory.isPMIEnabled()) {
                    this.invokePMI(n, portletRequest, portletResponse, portletCollaboratorChain, this.getPortletWindow(portletRequest, portletWindow), bl);
                    break;
                }
            }
            case 1: {
                ++n;
                if (PmiReqMetrics.isEnabled() && PmiReqMetrics.isComponentEnabled((int)PORTLET_COMPONENT_ID)) {
                    this.invokeRM(n, portletRequest, portletResponse, portletCollaboratorChain, this.getPortletWindow(portletRequest, portletWindow), bl);
                    break;
                }
            }
            default: {
                this.invoke(portletRequest, portletResponse, portletCollaboratorChain);
            }
        }
    }

    private void invokePMI(int n, PortletRequest portletRequest, PortletResponse portletResponse, PortletCollaboratorChain portletCollaboratorChain, PortletWindow portletWindow, boolean bl) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "invokePMI", new Object[]{portletRequest, portletResponse, portletCollaboratorChain, portletWindow, bl});
        }
        long l = System.currentTimeMillis();
        PortletPerf portletPerf = null;
        PortletDefinition portletDefinition = portletWindow.getPortletDefinition();
        portletPerf = portletDefinition instanceof com.ibm.ws.portletcontainer.om.ext.portlet.PortletDefinition ? ((com.ibm.ws.portletcontainer.om.ext.portlet.PortletDefinition)portletDefinition).getPortletPerf() : new ProxyPortletPerfImpl();
        if (bl) {
            portletPerf.onPortletActionStartService(l);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePMI", "PMI is enabled and onPortletActionStartService has been called for portlet " + portletWindow.getPortletDefinition().getName());
            }
        } else {
            portletPerf.onPortletRenderStartService(l);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePMI", "PMI is enabled and onPortletRenderStartService has been called for portlet " + portletWindow.getPortletDefinition().getName());
            }
        }
        try {
            this.doInvoke(n, portletRequest, portletResponse, portletCollaboratorChain, portletWindow, bl);
        }
        catch (PortletException portletException) {
            FFDCFilter.processException((Throwable)portletException, (String)"com.ibm.ws.portletcontainer.invoker.collaborator.impl.PortletInvokerPerformanceCollaborator.invokePMI", (String)"141", (Object)this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePMI", "PMI onPortletError has been called for portlet : " + portletWindow.getPortletDefinition().getName());
            }
            portletPerf.onPortletError();
            throw portletException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.invoker.collaborator.impl.PortletInvokerPerformanceCollaborator.invokePMI", (String)"151", (Object)this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePMI", "PMI onPortletError has been called for portlet : " + portletWindow.getPortletDefinition().getName());
            }
            portletPerf.onPortletError();
            throw iOException;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (bl) {
            portletPerf.onPortletActionFinishService(l2, l3);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePMI", "PMI onPortletActionFinishService has been called for portlet " + portletWindow.getPortletDefinition().getName() + " with duration set to " + l3);
            }
        } else {
            portletPerf.onPortletRenderFinishService(l2, l3);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePMI", "PMI onPortletRenderFinishService has been called for portlet " + portletWindow.getPortletDefinition().getName() + " with duration set to " + l3);
            }
        }
        logger.exiting(CLASS_NAME, "invokePMI");
    }

    private void invokeRM(int n, PortletRequest portletRequest, PortletResponse portletResponse, PortletCollaboratorChain portletCollaboratorChain, PortletWindow portletWindow, boolean bl) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "invokeRM", new Object[]{portletRequest, portletResponse, portletCollaboratorChain, portletWindow, bl});
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "invokeRM", "Request Metrics is enabled. Providing data for portlet window: " + portletWindow.getPortletWindowIdentifier().getId(IdentifierNamespace.LOGGING).toString());
        }
        String string = bl ? "action" : "render";
        Object object = PmiReqMetrics.reqStart((int)PORTLET_COMPONENT_ID, (int)1, (String[])this.createRequestMetricsParams(portletRequest, portletWindow, string));
        try {
            this.doInvoke(n, portletRequest, portletResponse, portletCollaboratorChain, portletWindow, bl);
        }
        catch (PortletException portletException) {
            FFDCFilter.processException((Throwable)portletException, (String)"com.ibm.ws.portletcontainer.invoker.collaborator.impl.PortletInvokerPerformanceCollaborator.invokeRM", (String)"205", (Object)this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokeRM", "Request Metrics returns with failed request for portlet window: " + portletWindow.getPortletWindowIdentifier().getId(IdentifierNamespace.LOGGING).toString());
            }
            PmiReqMetrics.reqStop((Object)object, (int)PORTLET_COMPONENT_ID, (int)1, (int)1);
            throw portletException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.invoker.collaborator.impl.PortletInvokerPerformanceCollaborator.invokeRM", (String)"219", (Object)this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokeRM", "Request Metrics returns with failed request for portlet window: " + portletWindow.getPortletWindowIdentifier().getId(IdentifierNamespace.LOGGING).toString());
            }
            PmiReqMetrics.reqStop((Object)object, (int)PORTLET_COMPONENT_ID, (int)1, (int)1);
            throw iOException;
        }
        PmiReqMetrics.reqStop((Object)object, (int)PORTLET_COMPONENT_ID, (int)1, (int)0);
        logger.exiting(CLASS_NAME, "invokeRM");
    }

    private void invoke(PortletRequest portletRequest, PortletResponse portletResponse, PortletCollaboratorChain portletCollaboratorChain) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "invoke", new Object[]{portletRequest, portletResponse, portletCollaboratorChain});
        }
        portletCollaboratorChain.doCollaborator(portletRequest, portletResponse);
        logger.exiting(CLASS_NAME, "invoke");
    }

    private PortletWindow getPortletWindow(PortletRequest portletRequest, PortletWindow portletWindow) {
        return portletWindow != null ? portletWindow : CoreUtils.getInternalRequest(portletRequest).getPortletWindow();
    }

    private String[] createRequestMetricsParams(PortletRequest portletRequest, PortletWindow portletWindow, String string) {
        String[] stringArray = new String[]{string, portletWindow.getId(IdentifierNamespace.LOGGING).toString(), portletRequest.getContextPath()};
        return stringArray;
    }
}

