/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.ext.security;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.information.PortletURLProvider;
import com.ibm.wsspi.runtime.component.TransportMap;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class SecurityPortletURLProviderWrapper
implements PortletURLProvider {
    private static final String CLASS_NAME = SecurityPortletURLProviderWrapper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private static final String hostSchemeHTTP = "http";
    private static final String hostSchemeHTTPS = "https";
    private PortletURLProvider urlProvider;
    private PortletWindowIdentifier id;
    private HttpServletRequest request;
    private PortletMode mode;
    private WindowState state;
    private Map parameters = new HashMap();
    private boolean secure = false;
    private boolean action = false;
    static /* synthetic */ Class class$com$ibm$wsspi$runtime$component$TransportMap;

    public static PortletURLProvider getPortletURLProvider(PortletWindowIdentifier portletWindowIdentifier, PortletURLProvider portletURLProvider, HttpServletRequest httpServletRequest) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPortletURLProvider", new Object[]{portletWindowIdentifier, portletURLProvider, httpServletRequest});
        }
        SecurityPortletURLProviderWrapper securityPortletURLProviderWrapper = new SecurityPortletURLProviderWrapper(portletWindowIdentifier, portletURLProvider, httpServletRequest);
        logger.exiting(CLASS_NAME, "getPortletURLProvider", securityPortletURLProviderWrapper);
        return securityPortletURLProviderWrapper;
    }

    SecurityPortletURLProviderWrapper(PortletWindowIdentifier portletWindowIdentifier, PortletURLProvider portletURLProvider, HttpServletRequest httpServletRequest) {
        this.id = portletWindowIdentifier;
        this.urlProvider = portletURLProvider;
        this.request = httpServletRequest;
    }

    public boolean isSecuritySupported() {
        logger.entering(CLASS_NAME, "isSecuritySupported");
        logger.exiting(CLASS_NAME, "isSecuritySupported", Boolean.TRUE);
        return true;
    }

    public void setWindowState(WindowState windowState) {
        this.urlProvider.setWindowState(windowState);
    }

    public void setPortletMode(PortletMode portletMode) {
        this.urlProvider.setPortletMode(portletMode);
    }

    public void setParameters(Map map) {
        this.urlProvider.setParameters(map);
    }

    public void setSecure() {
        logger.entering(CLASS_NAME, "setSecure");
        this.secure = true;
        logger.exiting(CLASS_NAME, "setSecure");
    }

    public void setAction() {
        this.urlProvider.setAction();
    }

    public String toString() {
        String string;
        logger.entering(CLASS_NAME, "toString");
        String string2 = string = (String)this.request.getAttribute("com.ibm.wsspi.portlet.url.prefix");
        if (this.secure) {
            int n;
            boolean bl = logger.isLoggable(Level.FINEST);
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "toString", "URL prefix found: " + string);
            }
            int n2 = n = string == null ? -1 : string.indexOf("://");
            if (n < 0 && !this.request.isSecure()) {
                Object object;
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "toString", "Creating secure prefix.");
                }
                int n3 = this.request.getServerPort();
                if (!this.request.isSecure() && (object = this.getTransportMap()) != null) {
                    n3 = object.getHttpsPort(n3);
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "toString", "Retrieved secure port: " + n3);
                    }
                }
                object = new StringBuffer(100);
                ((StringBuffer)object).append(hostSchemeHTTPS);
                ((StringBuffer)object).append("://");
                ((StringBuffer)object).append(this.request.getServerName());
                if (n3 != 443) {
                    ((StringBuffer)object).append(':');
                    ((StringBuffer)object).append(n3);
                }
                if (string != null) {
                    if (!string.startsWith("/")) {
                        ((StringBuffer)object).append('/');
                    }
                    ((StringBuffer)object).append(string);
                }
                string2 = ((StringBuffer)object).toString();
            } else if (n >= 0 && !string.startsWith(hostSchemeHTTPS)) {
                TransportMap transportMap;
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "toString", "Modifying prefix to be secure: " + string);
                }
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(hostSchemeHTTPS);
                stringBuffer.append("://");
                String string3 = string.substring(n + 3, string.length());
                int n4 = string3.indexOf("/");
                int n5 = string3.indexOf(":");
                if (n5 >= 0 && (n5 < n4 || n4 < 0)) {
                    string3 = string3.substring(0, n5);
                } else if (n4 >= 0) {
                    string3 = string3.substring(0, n4);
                }
                stringBuffer.append(string3);
                int n6 = this.request.getServerPort();
                if (!this.request.isSecure() && (transportMap = this.getTransportMap()) != null) {
                    n6 = transportMap.getHttpsPort(n6);
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "toString", "Retrieved secure port: " + n6);
                    }
                }
                if (n6 != 443) {
                    stringBuffer.append(':');
                    stringBuffer.append(n6);
                }
                if (n4 >= 0 && n4 < string.length()) {
                    stringBuffer.append(string.substring(n4, string.length()));
                }
                string2 = stringBuffer.toString();
            }
        }
        if (string2 != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "toString", "Setting new prefix: " + string2);
            }
            this.request.setAttribute("com.ibm.wsspi.portlet.url.prefix", (Object)string2);
        }
        String string4 = ((Object)this.urlProvider).toString();
        if (string == null) {
            this.request.removeAttribute("com.ibm.wsspi.portlet.url.prefix");
        } else {
            this.request.setAttribute("com.ibm.wsspi.portlet.url.prefix", (Object)string);
        }
        logger.exiting(CLASS_NAME, "toString", string4);
        return string4;
    }

    private TransportMap getTransportMap() {
        TransportMap transportMap;
        block2: {
            logger.entering(CLASS_NAME, "getTransportMap");
            transportMap = null;
            try {
                transportMap = (TransportMap)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        TransportMap transportMap = (TransportMap)WsServiceRegistry.getService((Object)this, (Class)(class$com$ibm$wsspi$runtime$component$TransportMap == null ? (class$com$ibm$wsspi$runtime$component$TransportMap = SecurityPortletURLProviderWrapper.class$("com.ibm.wsspi.runtime.component.TransportMap")) : class$com$ibm$wsspi$runtime$component$TransportMap));
                        return transportMap;
                    }
                });
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.portletcontainer.ext.security.SecurityPortletURLProviderWrapper.getTransportMap", (String)"217", (Object)this);
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.logp(Level.FINE, CLASS_NAME, "getTransportMap", "Transport map service not available", exception);
            }
        }
        logger.exiting(CLASS_NAME, "getTransportMap", transportMap);
        return transportMap;
    }
}

