/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.invoker.impl;

import com.ibm.ws.portletcontainer.Constants;
import com.ibm.ws.portletcontainer.invoker.impl.PortletInvokerImpl;
import com.ibm.wsspi.portletcontainer.collaborator.PortletCollaboratorChain;
import com.ibm.wsspi.portletcontainer.collaborator.PortletInvokerCollaborator;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class PortletInvokerCollaboratorChainImpl
implements PortletCollaboratorChain {
    private static final String CLASS_NAME = PortletInvokerCollaboratorChainImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private PortletInvokerImpl invoker;
    private Iterator iter;

    PortletInvokerCollaboratorChainImpl(PortletInvokerImpl portletInvokerImpl, Iterator iterator) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "PortletInvokerCollaboratorChainImpl", new Object[]{portletInvokerImpl, iterator});
        }
        this.invoker = portletInvokerImpl;
        this.iter = iterator;
        logger.exiting(CLASS_NAME, "PortletInvokerCollaboratorChainImpl");
    }

    public void doCollaborator(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doCollaborator", new Object[]{portletRequest, portletResponse});
        }
        if (this.iter.hasNext()) {
            PortletInvokerCollaborator portletInvokerCollaborator = (PortletInvokerCollaborator)this.iter.next();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Calling doDispatch of collaborator: " + portletInvokerCollaborator);
            }
            if (portletRequest instanceof ActionRequest) {
                portletInvokerCollaborator.doAction((ActionRequest)portletRequest, (ActionResponse)portletResponse, this);
            } else {
                portletInvokerCollaborator.doRender((RenderRequest)portletRequest, (RenderResponse)portletResponse, this);
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Last collaborator called. Proceeding with normal execution.");
            }
            if (portletRequest instanceof ActionRequest) {
                this.invoker.invoke(portletRequest, portletResponse, Constants.METHOD_ACTION);
            } else {
                this.invoker.invoke(portletRequest, portletResponse, Constants.METHOD_RENDER);
            }
        }
        logger.exiting(CLASS_NAME, "doCollaborator");
    }
}

