/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.invoker.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.Constants;
import com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry;
import com.ibm.ws.portletcontainer.core.CoreUtils;
import com.ibm.ws.portletcontainer.core.InternalPortletRequest;
import com.ibm.ws.portletcontainer.core.InternalPortletResponse;
import com.ibm.ws.portletcontainer.invoker.PortletInvoker;
import com.ibm.ws.portletcontainer.invoker.impl.PortletInvokerCollaboratorChainImpl;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.servlet.ServletDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.service.attribute.AttributeManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;

public class PortletInvokerImpl
implements PortletInvoker {
    private static final String CLASS_NAME = PortletInvokerImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private PortletDefinition portletDefinition;

    public PortletInvokerImpl(PortletDefinition portletDefinition) {
        this.portletDefinition = portletDefinition;
    }

    public void action(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        logger.entering(CLASS_NAME, "action");
        List list = CollaboratorRegistry.getInstance().getPortletInvokerCollaborators();
        if (list.size() == 0) {
            this.invoke(actionRequest, actionResponse, Constants.METHOD_ACTION);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "action", "Calling collaborators. Count: " + list.size());
            }
            Iterator iterator = list.iterator();
            PortletInvokerCollaboratorChainImpl portletInvokerCollaboratorChainImpl = new PortletInvokerCollaboratorChainImpl(this, iterator);
            portletInvokerCollaboratorChainImpl.doCollaborator(actionRequest, actionResponse);
        }
        logger.exiting(CLASS_NAME, "action");
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        logger.entering(CLASS_NAME, "render");
        List list = CollaboratorRegistry.getInstance().getPortletInvokerCollaborators();
        if (list.size() == 0) {
            this.invoke(renderRequest, renderResponse, Constants.METHOD_RENDER);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "render", "Calling collaborators. Count: " + list.size());
            }
            Iterator iterator = list.iterator();
            PortletInvokerCollaboratorChainImpl portletInvokerCollaboratorChainImpl = new PortletInvokerCollaboratorChainImpl(this, iterator);
            portletInvokerCollaboratorChainImpl.doCollaborator(renderRequest, renderResponse);
        }
        logger.exiting(CLASS_NAME, "render");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void invoke(PortletRequest portletRequest, PortletResponse portletResponse, Integer n) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "invoke", new Object[]{portletRequest, portletResponse, n});
        }
        InternalPortletRequest internalPortletRequest = CoreUtils.getInternalRequest(portletRequest);
        InternalPortletResponse internalPortletResponse = CoreUtils.getInternalResponse(portletResponse);
        this.addPortalAttributes(portletRequest, internalPortletRequest.getPortletWindow());
        ServletRequest servletRequest = ((HttpServletRequestWrapper)internalPortletRequest).getRequest();
        ServletResponse servletResponse = ((HttpServletResponseWrapper)internalPortletResponse).getResponse();
        ServletDefinition servletDefinition = this.portletDefinition.getServletDefinition();
        RequestDispatcher requestDispatcher = servletDefinition.getRequestDispatcher();
        if (requestDispatcher != null) {
            Object object = servletRequest.getAttribute("com.ibm.ws.portletcontainer.core.invalidate_cache");
            Object object2 = servletRequest.getAttribute("com.ibm.ws.portletcontainer.core.method");
            Object object3 = servletRequest.getAttribute("javax.portlet.request");
            Object object4 = servletRequest.getAttribute("javax.portlet.response");
            servletRequest.setAttribute("com.ibm.ws.portletcontainer.core.invalidate_cache", (Object)this.getInvalidateCache(n));
            servletRequest.setAttribute("com.ibm.ws.portletcontainer.core.method", (Object)n);
            servletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
            servletRequest.setAttribute("javax.portlet.response", (Object)portletResponse);
            try {
                try {
                    requestDispatcher.include(servletRequest, servletResponse);
                }
                catch (javax.servlet.UnavailableException unavailableException) {
                    FFDCFilter.processException((Throwable)unavailableException, (String)"com.ibm.ws.portletcontainer.invoker.impl.PortletInvokerImpl.invoke", (String)"100", (Object)this);
                    logger.logp(Level.SEVERE, CLASS_NAME, "invoke", "portlet.invoke.error.0", unavailableException);
                    if (unavailableException.isPermanent()) {
                        logger.logp(Level.INFO, CLASS_NAME, "invoke", "portlet.permanent.unavailable.1", unavailableException.getMessage());
                        throw new UnavailableException(unavailableException.getMessage());
                    }
                    logger.logp(Level.INFO, CLASS_NAME, "invoke", "portlet.temporary.unavailable.2", new Object[]{unavailableException.getMessage(), new Integer(unavailableException.getUnavailableSeconds())});
                    throw new UnavailableException(unavailableException.getMessage(), unavailableException.getUnavailableSeconds());
                }
                catch (ServletException servletException) {
                    FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.portletcontainer.invoker.impl.PortletInvokerImpl.invoke", (String)"117", (Object)this);
                    if (servletException.getRootCause() == null) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "invoke", "portlet.invoke.error.0", servletException);
                        throw new PortletException(servletException);
                    }
                    if (servletException.getRootCause() instanceof PortletException) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "invoke", "portlet.invoke.error.0", servletException.getRootCause());
                        throw (PortletException)servletException.getRootCause();
                    }
                    logger.logp(Level.SEVERE, CLASS_NAME, "invoke", "portlet.invoke.error.0", servletException.getRootCause());
                    throw new PortletException(servletException.getRootCause());
                }
                Object var16_14 = null;
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                servletRequest.setAttribute("com.ibm.ws.portletcontainer.core.invalidate_cache", object);
                servletRequest.setAttribute("com.ibm.ws.portletcontainer.core.method", object2);
                servletRequest.setAttribute("javax.portlet.request", object3);
                servletRequest.setAttribute("javax.portlet.response", object4);
                throw throwable;
            }
            servletRequest.setAttribute("com.ibm.ws.portletcontainer.core.invalidate_cache", object);
            servletRequest.setAttribute("com.ibm.ws.portletcontainer.core.method", object2);
            servletRequest.setAttribute("javax.portlet.request", object3);
            servletRequest.setAttribute("javax.portlet.response", object4);
        } else {
            logger.logp(Level.SEVERE, CLASS_NAME, "invoke", "dispatcher.not.found.0");
        }
        logger.exiting(CLASS_NAME, "invoke");
    }

    private void addPortalAttributes(PortletRequest portletRequest, PortletWindow portletWindow) {
        Map map = AttributeManager.getAdditionalRequestAttributes(portletWindow);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                portletRequest.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private Boolean getInvalidateCache(Integer n) {
        return n == Constants.METHOD_ACTION ? Boolean.TRUE : Boolean.FALSE;
    }
}

