/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.management.portlet;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.portletcontainer.management.portlet.PortletApplication;
import com.ibm.ws.portletcontainer.management.portlet.PortletCollaborator;
import com.ibm.ws.portletcontainer.om.ControllerObjectAccess;
import com.ibm.ws.portletcontainer.om.common.Description;
import com.ibm.ws.portletcontainer.om.common.DisplayName;
import com.ibm.ws.portletcontainer.om.portlet.CustomPortletMode;
import com.ibm.ws.portletcontainer.om.portlet.CustomWindowState;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinitionList;
import com.ibm.ws.portletcontainer.om.portlet.SecurityConstraint;
import com.ibm.ws.portletcontainer.om.portlet.UserAttribute;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinition;
import com.ibm.ws.portletcontainer.util.StringUtils;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class PortletApplicationCollaborator
extends DefaultRuntimeCollaborator
implements PortletApplication,
NotificationListener {
    private static final String PORTLET_XML_DESCRIPTOR = "com/ibm/ws/portletcontainer/management/descriptor/xml/Portlet.xml";
    private static final String PORTLETAPP_XML_DESCRIPTOR = "com/ibm/ws/portletcontainer/management/descriptor/xml/PortletApplication.xml";
    private static final String ID = "id";
    private static final String DISPLAYNAME = "displayname";
    private static final String PORTLETS = "portlets";
    private static final String USER_DATA_CONSTRAINT = "user-data-constraint";
    private static final String DESCRIPTION = "description";
    private static final String TRANSPORT_GUARANTEE = "transport-guarantee";
    private WebApplicationDefinition wad;
    private long sequence;
    private String name;
    private Set pdToObjectName;
    private ObjectName on;
    private static final String CLASS_NAME = PortletApplicationCollaborator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    public PortletApplicationCollaborator(WebApplicationDefinition webApplicationDefinition) {
        this(PortletApplicationCollaborator.constructPortletApplicationMBeanName(webApplicationDefinition), webApplicationDefinition);
    }

    public PortletApplicationCollaborator(String string, WebApplicationDefinition webApplicationDefinition) {
        super(string);
        this.name = string;
        this.wad = webApplicationDefinition;
        this.sequence = 0L;
        this.pdToObjectName = new HashSet();
    }

    private static String constructPortletApplicationMBeanName(WebApplicationDefinition webApplicationDefinition) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(webApplicationDefinition.getEarName());
        stringBuffer.append("#");
        stringBuffer.append(webApplicationDefinition.getName());
        stringBuffer.append("_portlet");
        return stringBuffer.toString();
    }

    private String constructPortletMBeanName(String string) {
        return this.name + "." + string;
    }

    public String getMBeanName() {
        return this.name;
    }

    public void activateMBeans() {
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            boolean bl = logger.isLoggable(Level.FINE);
            Iterator iterator = this.wad.getPortletApplicationDefinition().getPortletDefinitionList().iterator();
            while (iterator.hasNext()) {
                PortletDefinition portletDefinition = (PortletDefinition)iterator.next();
                PortletCollaborator portletCollaborator = new PortletCollaborator(this.name, this.constructPortletMBeanName(portletDefinition.getName()), portletDefinition);
                mBeanFactory.activateMBean("Portlet", (RuntimeCollaborator)portletCollaborator, null, PORTLET_XML_DESCRIPTOR);
                this.pdToObjectName.add(portletCollaborator.getObjectName());
                if (!bl) continue;
                logger.logp(Level.FINE, CLASS_NAME, "activateMBeans", "Activated MBean for portlet " + this.constructPortletMBeanName(portletDefinition.getName()));
            }
            mBeanFactory.activateMBean("PortletApplication", (RuntimeCollaborator)this, null, PORTLETAPP_XML_DESCRIPTOR);
            if (bl) {
                logger.logp(Level.FINE, CLASS_NAME, "activateMBeans", "Activated MBean for portletapplication " + this.name);
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, (String)"com.ibm.ws.management.portlet.PortletApplicationCollaborator.activateMBeans", (String)"96", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "activateMBeans", "activate.mbean.error.0", adminException);
        }
    }

    private void deactivateMBeans() {
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            boolean bl = logger.isLoggable(Level.FINE);
            Iterator iterator = this.pdToObjectName.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                mBeanFactory.deactivateMBean(objectName);
                if (!bl) continue;
                logger.logp(Level.FINE, CLASS_NAME, "deactivateMBeans", "Deactivated MBean for portlet " + objectName.getCanonicalName());
            }
            mBeanFactory.deactivateMBean(this.getObjectName());
            this.pdToObjectName.clear();
            if (bl) {
                logger.logp(Level.FINE, CLASS_NAME, "deactivateMBeans", "Deactivated MBean for portletapplication " + this.name);
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, (String)"com.ibm.ws.management.portlet.PortletApplicationCollaborator.deactivateMBeans", (String)"125", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "deactivateMBeans", "deactivate.mbean.error.0", adminException);
        }
    }

    public void sendStartingNotification() {
        try {
            this.sendNotification(new Notification("portletapplication.starting", this.getObjectName(), this.sequence++));
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.ws.management.portlet.PortletApplicationCollaborator.sendStartingNotification", (String)"138", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "sendStartingNotification", "send.start.notification.error.0", mBeanException);
        }
    }

    public void registerAsMBeanListener() {
        try {
            if (this.on == null) {
                this.on = new ObjectName("WebSphere:type=WebModule,name=" + this.wad.getName() + ",*");
            }
            AdminService adminService = AdminServiceFactory.getAdminService();
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.running");
            notificationFilterSupport.enableType("j2ee.state.stopping");
            notificationFilterSupport.enableType("j2ee.state.stopped");
            adminService.addNotificationListenerExtended(this.on, (NotificationListener)this, (NotificationFilter)notificationFilterSupport, (Object)this.wad.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "registerAsMBeanListener", "Listener " + this.wad.getName() + " was registered successfully.");
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.portlet.PortletApplicationCollaborator.registerAsMBeanListener", (String)"174", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "registerAsMBeanListener", "register.mbean.listener", malformedObjectNameException);
        }
    }

    private void unregisterMBeanListener() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        try {
            adminService.removeNotificationListenerExtended(this.on, (NotificationListener)this);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "unregisterAsMBeanListener", "Listener " + this.wad.getName() + "was unregistered successfully.");
            }
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            FFDCFilter.processException((Throwable)listenerNotFoundException, (String)"com.ibm.ws.management.portlet.PortletApplicationCollaborator.unregisterMBeanListener", (String)"194", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "unregisterAsMBeanListener", "unregister.mbean.listener.0", listenerNotFoundException);
        }
    }

    public String getVersion() {
        return this.wad.getPortletApplicationDefinition().getVersion();
    }

    public String getId() {
        String string = this.wad.getPortletApplicationDefinition().getAppId();
        return string;
    }

    public String getWebApplicationContextRoot() {
        return this.wad.getPortletApplicationDefinition().getWebApplicationDefinition().getContextRoot();
    }

    public List getPortletMBeanNames() {
        PortletDefinitionList portletDefinitionList = this.wad.getPortletApplicationDefinition().getPortletDefinitionList();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = portletDefinitionList.iterator();
        while (iterator.hasNext()) {
            PortletDefinition portletDefinition = (PortletDefinition)iterator.next();
            arrayList.add(this.constructPortletMBeanName(portletDefinition.getName()));
        }
        return arrayList;
    }

    public String getWebApplicationName() {
        return this.wad.getName();
    }

    public String getEarApplicationName() {
        return this.wad.getEarName();
    }

    public List getCustomPortletModes() {
        List list = this.wad.getPortletApplicationDefinition().getCustomPortletModes();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomPortletMode customPortletMode = (CustomPortletMode)iterator.next();
            arrayList.add(customPortletMode.getModeName());
        }
        return arrayList;
    }

    public List getCustomWindowStates() {
        List list = this.wad.getPortletApplicationDefinition().getCustomWindowStates();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomWindowState customWindowState = (CustomWindowState)iterator.next();
            arrayList.add(customWindowState.getStateName());
        }
        return arrayList;
    }

    public List getUserAttributes() {
        List list = this.wad.getPortletApplicationDefinition().getUserAttributes();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            UserAttribute userAttribute = (UserAttribute)iterator.next();
            arrayList.add(userAttribute.getName());
        }
        return arrayList;
    }

    public List getSecurityConstraints() {
        List list = this.wad.getPortletApplicationDefinition().getSecurityConstraints();
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            HashMap<String, Object> hashMap;
            SecurityConstraint securityConstraint = (SecurityConstraint)iterator.next();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>(6);
            if (securityConstraint.getId() != null) {
                hashMap2.put(ID, securityConstraint.getId());
            }
            HashMap<Locale, String> hashMap3 = new HashMap<Locale, String>();
            Object object2 = securityConstraint.getDisplayNames().iterator();
            while (object2.hasNext()) {
                hashMap = (DisplayName)object2.next();
                hashMap3.put(hashMap.getLocale(), hashMap.getDisplayName());
            }
            hashMap2.put(DISPLAYNAME, hashMap3);
            object2 = new ArrayList();
            hashMap = securityConstraint.getPortletCollection().getPortletDefinitionList().iterator();
            while (hashMap.hasNext()) {
                object = (PortletDefinition)hashMap.next();
                object2.add(this.constructPortletMBeanName(object.getName()));
            }
            hashMap2.put(PORTLETS, object2);
            hashMap = new HashMap<String, Object>();
            object = new HashMap();
            Iterator iterator2 = securityConstraint.getUserDataConstraint().getDescriptions().iterator();
            while (iterator2.hasNext()) {
                Description description = (Description)iterator2.next();
                object.put(description.getLocale(), description.getDescription());
            }
            hashMap.put(DESCRIPTION, object);
            hashMap.put(TRANSPORT_GUARANTEE, securityConstraint.getUserDataConstraint().getTransportGuarantee().toString());
            hashMap2.put(USER_DATA_CONSTRAINT, hashMap);
            arrayList.add(hashMap2);
        }
        return arrayList;
    }

    public void handleNotification(Notification notification, Object object) {
        boolean bl = logger.isLoggable(Level.FINER);
        try {
            String string = notification.getType();
            if (string.equals("j2ee.state.running")) {
                if (bl) {
                    logger.logp(Level.FINER, CLASS_NAME, "handleNotification", "Notification received: " + string);
                }
                this.sendNotification(new Notification("portletapplication.started", this.getObjectName(), this.sequence++));
            }
            if (string.equals("j2ee.state.stopping")) {
                if (bl) {
                    logger.logp(Level.FINER, CLASS_NAME, "handleNotification", "Notification received: " + string);
                }
                this.sendNotification(new Notification("portletapplication.stopping", this.getObjectName(), this.sequence++));
                this.sendNotification(new Notification("portletapplication.stopped", this.getObjectName(), this.sequence++));
                this.deactivateMBeans();
                if (StatsFactory.isPMIEnabled()) {
                    Iterator iterator = this.wad.getPortletApplicationDefinition().getPortletDefinitionList().iterator();
                    while (iterator.hasNext()) {
                        PortletDefinition portletDefinition = (PortletDefinition)iterator.next();
                        PortletDefinitionCtrl portletDefinitionCtrl = (PortletDefinitionCtrl)ControllerObjectAccess.get(portletDefinition);
                    }
                }
                this.unregisterMBeanListener();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.portlet.PortletApplicationCollaborator.handleNotification", (String)"292", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "handleNotifiaction", "handle.notification.0", exception);
        }
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(50);
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append(this.getClass().toString());
        stringBuffer.append(":");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("{");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("version='");
        stringBuffer.append(this.getVersion());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("ID='");
        stringBuffer.append(this.getId());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("web application context root='");
        stringBuffer.append(this.getWebApplicationContextRoot());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("portlet MBean names='");
        stringBuffer.append(this.getPortletMBeanNames());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("web application name='");
        stringBuffer.append(this.getWebApplicationName());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("custom portlet modes='");
        stringBuffer.append(this.getCustomPortletModes());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("custom window states='");
        stringBuffer.append(this.getCustomWindowStates());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("user attributes='");
        stringBuffer.append(this.getUserAttributes());
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

