/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.om.common.impl;

import com.ibm.ws.portletcontainer.om.common.Language;
import com.ibm.ws.portletcontainer.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class LanguageImpl
implements Language {
    private Locale locale;
    private String title;
    private String shortTitle;
    private ResourceBundle bundle;
    private ArrayList keywords;

    public LanguageImpl(Locale locale, ResourceBundle resourceBundle, String string, String string2, String string3) {
        this.bundle = new ResourceBundleImpl(resourceBundle, new DefaultsResourceBundle(string, string2, string3));
        this.locale = locale;
        this.title = this.bundle.getString("javax.portlet.title");
        this.shortTitle = this.bundle.getString("javax.portlet.short-title");
        this.keywords = this.toList(this.bundle.getString("javax.portlet.keywords"));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public Iterator getKeywords() {
        return this.keywords.iterator();
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setShortTitle(String string) {
        this.shortTitle = string;
    }

    public void setKeywords(Collection collection) {
        this.keywords.clear();
        this.keywords.addAll(collection);
    }

    public boolean equals(Object object) {
        return object == null ? false : ((LanguageImpl)object).locale.equals(this.locale);
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(50);
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append(this.getClass().toString());
        stringBuffer.append(":");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("{");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("locale='");
        stringBuffer.append(this.locale);
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("title='");
        stringBuffer.append(this.title);
        stringBuffer.append("'");
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("shortTitle='");
        stringBuffer.append(this.shortTitle);
        stringBuffer.append("'");
        Iterator iterator = this.keywords.iterator();
        if (iterator.hasNext()) {
            StringUtils.newLine(stringBuffer, n);
            stringBuffer.append("Keywords:");
        }
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append(',');
        }
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private ArrayList toList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    private static class ResourceBundleImpl
    extends ResourceBundle {
        private HashMap data = new HashMap();

        public ResourceBundleImpl(ResourceBundle resourceBundle, ResourceBundle resourceBundle2) {
            this.importData(resourceBundle2);
            this.importData(resourceBundle);
        }

        private void importData(ResourceBundle resourceBundle) {
            if (resourceBundle != null) {
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    Object object = resourceBundle.getObject(string);
                    this.data.put(string, object);
                }
            }
        }

        protected Object handleGetObject(String string) {
            return this.data.get(string);
        }

        public Enumeration getKeys() {
            return Collections.enumeration(this.data.keySet());
        }
    }

    private static class DefaultsResourceBundle
    extends ListResourceBundle {
        private Object[][] resources;

        public DefaultsResourceBundle(String string, String string2, String string3) {
            this.resources = new Object[][]{{"javax.portlet.title", string}, {"javax.portlet.short-title", string2}, {"javax.portlet.keywords", string3}};
        }

        protected Object[][] getContents() {
            return this.resources;
        }
    }
}

