/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.om.common.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.om.common.Language;
import com.ibm.ws.portletcontainer.om.common.LanguageSet;
import com.ibm.ws.portletcontainer.om.common.LanguageSetCtrl;
import com.ibm.ws.portletcontainer.om.common.impl.LanguageImpl;
import com.ibm.ws.portletcontainer.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LanguageSetImpl
implements LanguageSet,
LanguageSetCtrl {
    private HashSet languages;
    private static final String CLASS_NAME = LanguageSetImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private ArrayList locales;
    private Locale defLoc;

    public Iterator iterator() {
        return this.languages.iterator();
    }

    public Iterator getLocales() {
        return this.locales.iterator();
    }

    public Language get(Locale locale) {
        if (!this.locales.contains(locale)) {
            locale = this.matchLocale(locale);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Language language = (Language)iterator.next();
            if (!language.getLocale().equals(locale) && this.languages.size() != 1) continue;
            return language;
        }
        return null;
    }

    public Locale getDefaultLocale() {
        if (this.defLoc == null) {
            this.defLoc = this.locales.size() > 0 ? (Locale)this.locales.get(0) : new Locale("en", "");
        }
        return this.defLoc;
    }

    public void init(List list, String string, String string2, String string3, String string4, ClassLoader classLoader) {
        Iterator iterator;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "init", new Object[]{list, string, string3, string4, classLoader});
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if ("".equals(string4)) {
            string4 = null;
        }
        this.languages = new HashSet();
        this.locales = new ArrayList(list);
        if (list.isEmpty()) {
            iterator = string4 != null ? this.loadResourceBundle(this.getDefaultLocale(), string4, classLoader) : null;
            this.languages.add(this.createLanguage(this.getDefaultLocale(), (ResourceBundle)((Object)iterator), string, string2, string3));
        }
        iterator = this.locales.iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            ResourceBundle resourceBundle = string4 != null ? this.loadResourceBundle(locale, string4, classLoader) : null;
            this.languages.add(this.createLanguage(locale, resourceBundle, string, string2, string3));
        }
        logger.exiting(CLASS_NAME, "init");
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(50);
        StringUtils.newLine(stringBuffer, n);
        stringBuffer.append(this.getClass().toString());
        stringBuffer.append(": ");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((LanguageImpl)iterator.next()).toString(n + 2));
        }
        return stringBuffer.toString();
    }

    private ResourceBundle loadResourceBundle(Locale locale, String string, ClassLoader classLoader) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.portletcontainer.om.common.impl.LanguageSetImpl.loadResourceBundle", (String)"107", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "loadResourceBundle", "portlet.servlet.init.ex.0", missingResourceException);
        }
        return resourceBundle;
    }

    private Locale matchLocale(Locale locale) {
        String string;
        String string2 = locale.getVariant();
        if (string2 != null && string2.length() > 0) {
            locale = new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!this.locales.contains(locale) && (string = locale.getCountry()) != null && string.length() > 0) {
            locale = new Locale(locale.getLanguage(), "");
        }
        if (!this.locales.contains(locale)) {
            locale = this.getDefaultLocale();
        }
        return locale;
    }

    private Language createLanguage(Locale locale, ResourceBundle resourceBundle, String string, String string2, String string3) {
        LanguageImpl languageImpl = new LanguageImpl(locale, resourceBundle, string, string2, string3);
        return languageImpl;
    }

    private Locale createLocale(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String[] stringArray = new String[5];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2] + stringArray[3] + stringArray[4]);
    }
}

