/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.om.ext.proxy;

import com.ibm.ws.portletcontainer.om.OMAccess;
import com.ibm.ws.portletcontainer.om.common.WSPreferenceSet;
import com.ibm.ws.portletcontainer.om.ext.proxy.ProxyPortletDefinitionImpl;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.om.window.impl.PortletWindowImpl;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyPortletWindowImpl
implements PortletWindow {
    private static final String CLASS_NAME = ProxyPortletWindowImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private final PortletWindowIdentifier id;
    private final PortletDefinition definition;
    private WSPreferenceSet preferences;

    public ProxyPortletWindowImpl(PortletWindowIdentifier portletWindowIdentifier) {
        this.id = portletWindowIdentifier;
        this.definition = new ProxyPortletDefinitionImpl(portletWindowIdentifier);
    }

    public ObjectID getId(IdentifierNamespace identifierNamespace) {
        return this.id.getId(identifierNamespace);
    }

    public PortletWindowIdentifier getPortletWindowIdentifier() {
        return this.id;
    }

    public PortletDefinition getPortletDefinition() {
        return this.definition;
    }

    public com.ibm.ws.portletcontainer.om.common.PreferenceSet getPreferenceSet() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPreferenceSet", new Object[]{this.preferences, this.id});
        }
        if (this.preferences == null) {
            PreferenceSet preferenceSet = PortletWindowImpl.loadProviderPreferences(this.id);
            this.preferences = OMAccess.createWSPreferenceSet(preferenceSet);
        }
        logger.exiting(CLASS_NAME, "getPreferenceSet", this.preferences);
        return this.preferences;
    }
}

