/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.om.translator.wccm;

import com.ibm.etools.portletapplication.CustomPortletMode;
import com.ibm.etools.portletapplication.Portlet;
import com.ibm.etools.portletapplication.PortletApplication;
import com.ibm.etools.portletapplication.TransportGuaranteeType;
import com.ibm.ws.portletcontainer.om.ControllerObjectAccess;
import com.ibm.ws.portletcontainer.om.Model;
import com.ibm.ws.portletcontainer.om.OMAccess;
import com.ibm.ws.portletcontainer.om.portlet.CustomPortletModeCtrl;
import com.ibm.ws.portletcontainer.om.portlet.CustomWindowState;
import com.ibm.ws.portletcontainer.om.portlet.CustomWindowStateCtrl;
import com.ibm.ws.portletcontainer.om.portlet.PortletApplicationDefinition;
import com.ibm.ws.portletcontainer.om.portlet.PortletApplicationDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.portlet.PortletCollection;
import com.ibm.ws.portletcontainer.om.portlet.PortletCollectionCtrl;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinitionList;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinitionListCtrl;
import com.ibm.ws.portletcontainer.om.portlet.SecurityConstraint;
import com.ibm.ws.portletcontainer.om.portlet.SecurityConstraintCtrl;
import com.ibm.ws.portletcontainer.om.portlet.TransportGuarantee;
import com.ibm.ws.portletcontainer.om.portlet.UserAttribute;
import com.ibm.ws.portletcontainer.om.portlet.UserAttributeCtrl;
import com.ibm.ws.portletcontainer.om.portlet.UserDataConstraint;
import com.ibm.ws.portletcontainer.om.portlet.UserDataConstraintCtrl;
import com.ibm.ws.portletcontainer.om.servlet.ServletDefinition;
import com.ibm.ws.portletcontainer.om.servlet.ServletDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.servlet.ServletMapping;
import com.ibm.ws.portletcontainer.om.servlet.ServletMappingCtrl;
import com.ibm.ws.portletcontainer.om.translator.wccm.WCCMPortletDefinitionTranslator;
import com.ibm.ws.portletcontainer.om.translator.wccm.WCCMTranslatorHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCCMPortletApplicationDefinitionTranslator {
    private static final String CLASS_NAME = WCCMPortletApplicationDefinitionTranslator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    public static PortletApplicationDefinition translate(PortletApplication portletApplication, ClassLoader classLoader) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "translate", new Object[]{portletApplication, classLoader});
        }
        PortletApplicationDefinition portletApplicationDefinition = OMAccess.createPortletApplicationDefinition();
        PortletApplicationDefinitionCtrl portletApplicationDefinitionCtrl = (PortletApplicationDefinitionCtrl)ControllerObjectAccess.get(portletApplicationDefinition);
        PortletDefinitionListCtrl portletDefinitionListCtrl = (PortletDefinitionListCtrl)ControllerObjectAccess.get(portletApplicationDefinition.getPortletDefinitionList());
        portletApplicationDefinitionCtrl.setAppId(portletApplication.getId());
        portletApplicationDefinitionCtrl.setVersion(portletApplication.getVersion());
        portletApplicationDefinitionCtrl.setCustomPortletModes(WCCMPortletApplicationDefinitionTranslator.createCustomPortletModesList((List)portletApplication.getCustomPortletModes()));
        portletApplicationDefinitionCtrl.setCustomWindowStates(WCCMPortletApplicationDefinitionTranslator.createCustomWindowStateList((List)portletApplication.getCustomWindowStates()));
        portletApplicationDefinitionCtrl.setUserAttributes(WCCMPortletApplicationDefinitionTranslator.createUserAttributesList((List)portletApplication.getUserAttributes()));
        Iterator iterator = portletApplication.getPortlets().iterator();
        while (iterator.hasNext()) {
            Portlet portlet = (Portlet)iterator.next();
            ServletDefinition servletDefinition = OMAccess.createServletDefinition();
            ServletDefinitionCtrl servletDefinitionCtrl = (ServletDefinitionCtrl)ControllerObjectAccess.get(servletDefinition);
            PortletDefinition portletDefinition = WCCMPortletDefinitionTranslator.translate(portlet, classLoader);
            PortletDefinitionCtrl portletDefinitionCtrl = (PortletDefinitionCtrl)ControllerObjectAccess.get(portletDefinition);
            servletDefinitionCtrl.setServletMapping(WCCMPortletApplicationDefinitionTranslator.createServletMapping(portletDefinition));
            portletDefinitionCtrl.setPortletApplicationDefinition(portletApplicationDefinition);
            portletDefinitionCtrl.setServletDefinition(servletDefinition);
            portletDefinitionListCtrl.add(portletDefinition);
        }
        portletApplicationDefinitionCtrl.setSecurityConstraints(WCCMPortletApplicationDefinitionTranslator.createSecurityConstraintsList((List)portletApplication.getSecurityConstraints(), portletApplicationDefinition.getPortletDefinitionList()));
        logger.exiting(CLASS_NAME, "translate", portletApplicationDefinition);
        return portletApplicationDefinition;
    }

    private static ServletMapping createServletMapping(PortletDefinition portletDefinition) {
        logger.entering(CLASS_NAME, "createServletMapping", portletDefinition);
        ServletMapping servletMapping = OMAccess.createServletMapping();
        ServletMappingCtrl servletMappingCtrl = (ServletMappingCtrl)ControllerObjectAccess.get(servletMapping);
        String string = "/portlet/" + portletDefinition.getName();
        servletMappingCtrl.setUrlPattern(string);
        logger.exiting(CLASS_NAME, "createServletMapping", servletMapping);
        return servletMapping;
    }

    private static List createCustomPortletModesList(List list) {
        logger.entering(CLASS_NAME, "createCustomPortletModesList", list);
        ArrayList<com.ibm.ws.portletcontainer.om.portlet.CustomPortletMode> arrayList = new ArrayList<com.ibm.ws.portletcontainer.om.portlet.CustomPortletMode>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomPortletMode customPortletMode = (CustomPortletMode)iterator.next();
            com.ibm.ws.portletcontainer.om.portlet.CustomPortletMode customPortletMode2 = OMAccess.createCustomPortletMode();
            CustomPortletModeCtrl customPortletModeCtrl = (CustomPortletModeCtrl)ControllerObjectAccess.get(customPortletMode2);
            customPortletModeCtrl.setDescriptions(WCCMTranslatorHelper.createDescriptionSet((List)customPortletMode.getDescriptions()));
            customPortletModeCtrl.setModeName(customPortletMode.getPortletMode());
            arrayList.add(customPortletMode2);
        }
        logger.exiting(CLASS_NAME, "createCustomPortletModesList", arrayList);
        return arrayList;
    }

    private static List createCustomWindowStateList(List list) {
        logger.entering(CLASS_NAME, "createCustomWindowStateList", list);
        ArrayList<CustomWindowState> arrayList = new ArrayList<CustomWindowState>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            com.ibm.etools.portletapplication.CustomWindowState customWindowState = (com.ibm.etools.portletapplication.CustomWindowState)iterator.next();
            CustomWindowState customWindowState2 = OMAccess.createCustomWindowState();
            CustomWindowStateCtrl customWindowStateCtrl = (CustomWindowStateCtrl)ControllerObjectAccess.get(customWindowState2);
            customWindowStateCtrl.setDescriptions(WCCMTranslatorHelper.createDescriptionSet((List)customWindowState.getDescriptions()));
            customWindowStateCtrl.setStateName(customWindowState.getWindowState());
            arrayList.add(customWindowState2);
        }
        logger.exiting(CLASS_NAME, "createCustomWindowStateList", arrayList);
        return arrayList;
    }

    private static List createUserAttributesList(List list) {
        logger.entering(CLASS_NAME, "createUserAttributesList", list);
        ArrayList<UserAttributeCtrl> arrayList = new ArrayList<UserAttributeCtrl>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            com.ibm.etools.portletapplication.UserAttribute userAttribute = (com.ibm.etools.portletapplication.UserAttribute)iterator.next();
            UserAttribute userAttribute2 = OMAccess.createUserAttribute();
            UserAttributeCtrl userAttributeCtrl = (UserAttributeCtrl)ControllerObjectAccess.get(userAttribute2);
            userAttributeCtrl.setDescriptions(WCCMTranslatorHelper.createDescriptionSet((List)userAttribute.getDescriptions()));
            userAttributeCtrl.setName(userAttribute.getName());
            arrayList.add(userAttributeCtrl);
        }
        logger.exiting(CLASS_NAME, "createUserAttributesList", arrayList);
        return arrayList;
    }

    private static List createSecurityConstraintsList(List list, PortletDefinitionList portletDefinitionList) {
        logger.entering(CLASS_NAME, "createSecurityConstraintsList", list);
        ArrayList<SecurityConstraint> arrayList = new ArrayList<SecurityConstraint>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            com.ibm.etools.portletapplication.SecurityConstraint securityConstraint = (com.ibm.etools.portletapplication.SecurityConstraint)iterator.next();
            SecurityConstraint securityConstraint2 = OMAccess.createSecurityConstraint();
            SecurityConstraintCtrl securityConstraintCtrl = (SecurityConstraintCtrl)ControllerObjectAccess.get(securityConstraint2);
            securityConstraintCtrl.setDisplayNames(WCCMTranslatorHelper.createDisplayNameSet((List)securityConstraint.getDisplayNames()));
            PortletCollection portletCollection = OMAccess.createPortletCollection();
            PortletCollectionCtrl portletCollectionCtrl = (PortletCollectionCtrl)ControllerObjectAccess.get(portletCollection);
            securityConstraintCtrl.setPortletCollection(portletCollection);
            PortletDefinitionList portletDefinitionList2 = OMAccess.createPortletDefinitionList();
            PortletDefinitionListCtrl portletDefinitionListCtrl = (PortletDefinitionListCtrl)ControllerObjectAccess.get(portletDefinitionList2);
            portletCollectionCtrl.setPortletDefinitionList(portletDefinitionList2);
            Object object2 = securityConstraint.getPortletCollection().getPortletNames().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                portletDefinitionListCtrl.add(portletDefinitionList.getByName((String)object));
            }
            object2 = OMAccess.createUserDataConstraint();
            object = (UserDataConstraintCtrl)ControllerObjectAccess.get((Model)object2);
            securityConstraintCtrl.setUserDataConstraint((UserDataConstraint)object2);
            object.setDescriptions(WCCMTranslatorHelper.createDescriptionSet((List)securityConstraint.getUserDataConstraint().getDescriptions()));
            object.setTransportGuarantee(WCCMPortletApplicationDefinitionTranslator.getTransportGuarantee(securityConstraint.getUserDataConstraint().getTransportGuarantee()));
            arrayList.add(securityConstraint2);
        }
        logger.exiting(CLASS_NAME, "createSecurityConstraintsList", arrayList);
        return arrayList;
    }

    private static TransportGuarantee getTransportGuarantee(TransportGuaranteeType transportGuaranteeType) {
        switch (transportGuaranteeType.getValue()) {
            case 2: {
                return TransportGuarantee.CONFIDENTIAL;
            }
            case 1: {
                return TransportGuarantee.INTEGRAL;
            }
            case 0: {
                return TransportGuarantee.NONE;
            }
        }
        throw new IllegalStateException("unknown type: " + transportGuaranteeType.getValue());
    }
}

