/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.om.translator.wccm;

import com.ibm.etools.portletapplication.InitParam;
import com.ibm.etools.portletapplication.Portlet;
import com.ibm.etools.portletapplication.PortletPreference;
import com.ibm.etools.portletapplication.Supports;
import com.ibm.ws.portletcontainer.om.ControllerObjectAccess;
import com.ibm.ws.portletcontainer.om.Model;
import com.ibm.ws.portletcontainer.om.OMAccess;
import com.ibm.ws.portletcontainer.om.common.LanguageSet;
import com.ibm.ws.portletcontainer.om.common.LanguageSetCtrl;
import com.ibm.ws.portletcontainer.om.common.ParameterSet;
import com.ibm.ws.portletcontainer.om.common.ParameterSetCtrl;
import com.ibm.ws.portletcontainer.om.common.Preference;
import com.ibm.ws.portletcontainer.om.common.PreferenceCtrl;
import com.ibm.ws.portletcontainer.om.common.PreferenceSet;
import com.ibm.ws.portletcontainer.om.common.PreferenceSetCtrl;
import com.ibm.ws.portletcontainer.om.common.SecurityRoleRefCtrl;
import com.ibm.ws.portletcontainer.om.common.SecurityRoleRefSet;
import com.ibm.ws.portletcontainer.om.common.SecurityRoleRefSetCtrl;
import com.ibm.ws.portletcontainer.om.portlet.ContentType;
import com.ibm.ws.portletcontainer.om.portlet.ContentTypeCtrl;
import com.ibm.ws.portletcontainer.om.portlet.ContentTypeSet;
import com.ibm.ws.portletcontainer.om.portlet.ContentTypeSetCtrl;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.translator.wccm.WCCMTranslatorHelper;
import com.ibm.ws.portletcontainer.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;

public class WCCMPortletDefinitionTranslator {
    private static final String CLASS_NAME = WCCMPortletDefinitionTranslator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    public static PortletDefinition translate(Portlet portlet, ClassLoader classLoader) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "translate", new Object[]{portlet, classLoader});
        }
        PortletDefinition portletDefinition = OMAccess.createPortletDefinition();
        PortletDefinitionCtrl portletDefinitionCtrl = (PortletDefinitionCtrl)ControllerObjectAccess.get(portletDefinition);
        portletDefinitionCtrl.setId(portlet.getId());
        portletDefinitionCtrl.setClassName(portlet.getClassName());
        portletDefinitionCtrl.setName(portlet.getPortletName());
        portletDefinitionCtrl.setDisplayNames(WCCMTranslatorHelper.createDisplayNameSet((List)portlet.getDisplayNames()));
        portletDefinitionCtrl.setDescriptions(WCCMTranslatorHelper.createDescriptionSet((List)portlet.getDescriptions()));
        portletDefinitionCtrl.setLanguageSet(WCCMPortletDefinitionTranslator.createLanguageSet(portlet, classLoader));
        portletDefinitionCtrl.setInitParameterSet(WCCMPortletDefinitionTranslator.createParameterSet((List)portlet.getInitParams()));
        portletDefinitionCtrl.setPreferenceSet(WCCMPortletDefinitionTranslator.createPreferenceSet(portlet.getPortletPreferences(), classLoader));
        portletDefinitionCtrl.setContentTypeSet(WCCMPortletDefinitionTranslator.createContentTypeSet((List)portlet.getSupports()));
        if (portlet.isSetExpirationCache()) {
            portletDefinitionCtrl.setExpirationCache(new Integer(portlet.getExpirationCache()));
        }
        portletDefinitionCtrl.setSecurityRoleRefs(WCCMPortletDefinitionTranslator.createSecurityRoleRefSet((List)portlet.getSecurityRoleRefs()));
        logger.exiting(CLASS_NAME, "translate", portletDefinition);
        return portletDefinition;
    }

    private static LanguageSet createLanguageSet(Portlet portlet, ClassLoader classLoader) {
        Object object;
        Object object2;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createLanguageSet", new Object[]{portlet, classLoader});
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        Iterator iterator = portlet.getSupportedLocale().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = LocaleUtils.parse((String)object2);
            arrayList.add((Locale)object);
        }
        iterator = portlet.getPortletInfo();
        object2 = OMAccess.createLanguageSet();
        object = (LanguageSetCtrl)ControllerObjectAccess.get((Model)object2);
        if (iterator != null) {
            object.init(arrayList, iterator.getTitle(), iterator.getShortTitle(), iterator.getKeywords(), portlet.getResourceBundle(), classLoader);
        } else {
            object.init(arrayList, null, null, null, portlet.getResourceBundle(), classLoader);
        }
        logger.exiting(CLASS_NAME, "createLanguageSet", object2);
        return object2;
    }

    private static ParameterSet createParameterSet(List list) {
        logger.entering(CLASS_NAME, "createParameterSet", list);
        ParameterSet parameterSet = OMAccess.createParameterSet();
        ParameterSetCtrl parameterSetCtrl = (ParameterSetCtrl)ControllerObjectAccess.get(parameterSet);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            InitParam initParam = (InitParam)iterator.next();
            parameterSetCtrl.add(initParam.getName(), initParam.getValue());
        }
        logger.exiting(CLASS_NAME, "createParameterSet", parameterSet);
        return parameterSet;
    }

    private static PreferenceSet createPreferenceSet(PortletPreference portletPreference, ClassLoader classLoader) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createPreferenceSet", new Object[]{portletPreference, classLoader});
        }
        PreferenceSet preferenceSet = OMAccess.createPreferenceSet();
        PreferenceSetCtrl preferenceSetCtrl = (PreferenceSetCtrl)ControllerObjectAccess.get(preferenceSet);
        if (portletPreference != null) {
            if (portletPreference.getPreferences() != null) {
                Iterator iterator = portletPreference.getPreferences().iterator();
                while (iterator.hasNext()) {
                    com.ibm.etools.portletapplication.Preference preference = (com.ibm.etools.portletapplication.Preference)iterator.next();
                    PreferenceCtrl preferenceCtrl = (PreferenceCtrl)ControllerObjectAccess.get(WCCMPortletDefinitionTranslator.addPreference(preferenceSetCtrl, preference.getName(), preference.getValues()));
                    if (preference.getReadOnly() == null) continue;
                    preferenceCtrl.setReadOnly(preference.getReadOnly());
                }
            }
            if (portletPreference.getPreferenceValidator() != null) {
                preferenceSetCtrl.loadPreferenceValidator(portletPreference.getPreferenceValidator(), classLoader);
            }
        }
        logger.exiting(CLASS_NAME, "createPreferenceSet", preferenceSet);
        return preferenceSet;
    }

    private static Preference addPreference(PreferenceSetCtrl preferenceSetCtrl, String string, EList eList) {
        if (eList != null && !eList.isEmpty()) {
            return preferenceSetCtrl.add(string, new ArrayList(eList));
        }
        return preferenceSetCtrl.add(string);
    }

    private static ContentTypeSet createContentTypeSet(List list) {
        logger.entering(CLASS_NAME, "createContentTypeSet", list);
        ContentTypeSet contentTypeSet = OMAccess.createContentTypeSet();
        ContentTypeSetCtrl contentTypeSetCtrl = (ContentTypeSetCtrl)ControllerObjectAccess.get(contentTypeSet);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Supports supports = (Supports)iterator.next();
            ContentType contentType = OMAccess.createContentType();
            ContentTypeCtrl contentTypeCtrl = (ContentTypeCtrl)ControllerObjectAccess.get(contentType);
            contentTypeSetCtrl.add(contentType);
            contentTypeCtrl.setContentType(supports.getMimeType());
            if (supports.getPortletMode() != null) {
                Iterator iterator2 = supports.getPortletMode().iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    contentTypeCtrl.addPortletMode(new PortletMode(string));
                }
            }
            if (contentType.isPortletModeSupported(PortletMode.VIEW)) continue;
            contentTypeCtrl.addPortletMode(PortletMode.VIEW);
        }
        logger.exiting(CLASS_NAME, "createContentTypeSet", contentTypeSet);
        return contentTypeSet;
    }

    private static SecurityRoleRefSet createSecurityRoleRefSet(List list) {
        logger.entering(CLASS_NAME, "createSecurityRoleRefSet", list);
        SecurityRoleRefSet securityRoleRefSet = OMAccess.createSecurityRoleRefSet();
        SecurityRoleRefSetCtrl securityRoleRefSetCtrl = (SecurityRoleRefSetCtrl)ControllerObjectAccess.get(securityRoleRefSet);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SecurityRoleRef securityRoleRef = (SecurityRoleRef)iterator.next();
            com.ibm.ws.portletcontainer.om.common.SecurityRoleRef securityRoleRef2 = OMAccess.createSecurityRoleRef();
            SecurityRoleRefCtrl securityRoleRefCtrl = (SecurityRoleRefCtrl)ControllerObjectAccess.get(securityRoleRef2);
            WCCMTranslatorHelper.createDescriptionSet((List)securityRoleRef.getDescriptions());
            securityRoleRefCtrl.setRoleLink(securityRoleRef.getLink());
            securityRoleRefCtrl.setRoleName(securityRoleRef.getName());
            securityRoleRefSetCtrl.add(securityRoleRef2);
        }
        logger.exiting(CLASS_NAME, "createSecurityRoleRefSet", securityRoleRefSet);
        return securityRoleRefSet;
    }
}

