/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.om.window.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.om.OMAccess;
import com.ibm.ws.portletcontainer.om.common.WSPreferenceSet;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.om.window.PortletWindowCtrl;
import com.ibm.ws.portletcontainer.registry.webapplicationdefinitionregistry.WebApplicationDefinitionRegistry;
import com.ibm.ws.portletcontainer.service.persistence.PersistenceProviderAccess;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.InvalidPortletWindowIdentifierException;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.persistence.PersistenceProvider;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSet;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSetAdapter;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSetCtrl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletWindowImpl
implements PortletWindow,
PortletWindowCtrl {
    private static final String CLASS_NAME = PortletWindowImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private PortletWindowIdentifier id;
    private PortletDefinition definition;
    private WSPreferenceSet preferences;

    public PortletWindowImpl(PortletWindowIdentifier portletWindowIdentifier) throws InvalidPortletWindowIdentifierException {
        this.id = portletWindowIdentifier;
        WebApplicationDefinition webApplicationDefinition = WebApplicationDefinitionRegistry.getInstance().getWebApplicationDefinition(portletWindowIdentifier.getContextRoot());
        if (webApplicationDefinition == null) {
            throw new InvalidPortletWindowIdentifierException("Context path cannot be found: " + portletWindowIdentifier.getContextRoot());
        }
        this.definition = webApplicationDefinition.getPortletApplicationDefinition().getPortletDefinitionList().getByName(portletWindowIdentifier.getPortletName());
        if (this.definition == null) {
            throw new InvalidPortletWindowIdentifierException("Portlet cannot be found: " + portletWindowIdentifier.getPortletName());
        }
    }

    public ObjectID getId(IdentifierNamespace identifierNamespace) {
        return this.id.getId(identifierNamespace);
    }

    public PortletWindowIdentifier getPortletWindowIdentifier() {
        return this.id;
    }

    public com.ibm.ws.portletcontainer.om.common.PreferenceSet getPreferenceSet() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPreferenceSet", new Object[]{this.preferences, this.id});
        }
        if (this.preferences == null) {
            PreferenceSet preferenceSet = PortletWindowImpl.loadProviderPreferences(this.id);
            this.preferences = OMAccess.createWSPreferenceSet(preferenceSet);
        }
        logger.exiting(CLASS_NAME, "getPreferenceSet", this.preferences);
        return this.preferences;
    }

    public PortletDefinition getPortletDefinition() {
        return this.definition;
    }

    public void store() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "store", new Object[]{this.preferences, this.id});
        }
        PersistenceProvider persistenceProvider = PersistenceProviderAccess.getProvider();
        PreferenceSetCtrl preferenceSetCtrl = this.preferences.getWSPreferenceSetCtrl();
        boolean bl = logger.isLoggable(Level.FINE);
        if (bl) {
            logger.logp(Level.FINE, CLASS_NAME, "store", " Storing preferences via the persistence provider ({0})...", persistenceProvider);
        }
        persistenceProvider.store(this.id, preferenceSetCtrl);
        if (bl) {
            logger.logp(Level.FINE, CLASS_NAME, "store", " done.");
        }
        logger.exiting(CLASS_NAME, "store");
    }

    public static PreferenceSet loadProviderPreferences(PortletWindowIdentifier portletWindowIdentifier) {
        PreferenceSet preferenceSet = null;
        PersistenceProvider persistenceProvider = PersistenceProviderAccess.getProvider();
        boolean bl = logger.isLoggable(Level.FINE);
        try {
            if (bl) {
                logger.logp(Level.FINE, CLASS_NAME, "getPreferenceSet", " Loading preferences via the persistence provider ({0})...", persistenceProvider);
            }
            preferenceSet = persistenceProvider.load(portletWindowIdentifier);
            if (bl) {
                logger.logp(Level.FINE, CLASS_NAME, "getPreferenceSet", " done.");
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.om.window.impl.PortletWindowImpl.getPreferenceSet", (String)"79", (Object)portletWindowIdentifier);
            logger.logp(Level.SEVERE, CLASS_NAME, "getPreferenceSet", "preferences.load.failed.0", iOException);
        }
        if (preferenceSet == null) {
            logger.logp(Level.WARNING, CLASS_NAME, "getPreferenceSet", "preferences.load.null.1", portletWindowIdentifier);
            preferenceSet = new PreferenceSetAdapter();
        }
        return preferenceSet;
    }
}

