/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.pcinvoker;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.servlet.context.IBMServletContext;
import com.ibm.ws.portletcontainer.pcinvoker.PortletInvokerFactory;
import com.ibm.ws.portletcontainer.service.internal.InternalInformationService;
import com.ibm.wsspi.portletcontainer.PortletContainerException;
import com.ibm.wsspi.portletcontainer.invoker.PortletContainer;
import com.ibm.wsspi.portletcontainer.invoker.PortletInvoker;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContext;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContextAdapter;
import java.security.Permission;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class PortletContainerImpl
implements PortletContainer {
    private static final String CLASS_NAME = PortletContainerImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static final Permission accessPortletContainerPermission = new WebSphereRuntimePermission("accessPortletContainer");
    private ServletContext initContext;

    public PortletContainerImpl(ServletContext servletContext) {
        this.initContext = servletContext;
    }

    public PortletInvoker getPortletInvoker(PortletContainerContext portletContainerContext) throws PortletContainerException {
        logger.entering(CLASS_NAME, "getPortletInvoker", portletContainerContext);
        if (portletContainerContext == null) {
            throw new IllegalArgumentException("PortletContainerContext must not be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(accessPortletContainerPermission);
        }
        PortletContainerContextAdapter portletContainerContextAdapter = new PortletContainerContextAdapter(Arrays.asList(portletContainerContext));
        if (this.initContext != null) {
            portletContainerContextAdapter.addContainerService(new InternalInformationServiceImpl(this.initContext));
        }
        PortletInvoker portletInvoker = PortletInvokerFactory.getPortletInvoker(portletContainerContextAdapter);
        logger.exiting(CLASS_NAME, "getPortletInvoker", portletInvoker);
        return portletInvoker;
    }

    private static class InternalInformationServiceImpl
    implements InternalInformationService {
        private ServletContext runtimeContext;

        InternalInformationServiceImpl(ServletContext servletContext) {
            String string = ((IBMServletContext)servletContext).getContextPath();
            this.runtimeContext = servletContext.getContext(string);
        }

        public ServletContext getCallingContext() {
            return this.runtimeContext;
        }
    }
}

