/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.pmi.server.modules;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.pmi.server.modules.InternalPortletApplicationPerf;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletAppModule
implements StatisticActionListener,
InternalPortletApplicationPerf {
    private static final String CLASS_NAME = PortletAppModule.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private static final String TEMPLATE_APP = "/com/ibm/ws/portletcontainer/pmi/xml/portletAppModule.xml";
    private static final String TEMPLATE_PORTLET = "/com/ibm/ws/portletcontainer/pmi/xml/portletModule.xml";
    private static NLS nls = new NLS("com.ibm.ws.portletcontainer.runtime.resources.PMIdesc");
    private static StatsGroup portletApplicationStatsGroup;
    private StatsGroup portletStatsGroup;
    private StatsInstance applicationInstance;
    private static String appName;
    private boolean error = false;
    private SPICountStatistic numLoadedPortlets;

    private void createPortletApplicationStatsGroup() throws StatsFactoryException {
        LOGGER.entering(CLASS_NAME, "createPortletApplicationStatsGroup");
        portletApplicationStatsGroup = StatsFactory.createStatsGroup((String)"portletAppModule", (String)TEMPLATE_APP, (StatsInstance)this.getWebAppStatsInstance(), null);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, CLASS_NAME, "createPortletApplicationStatsGroup", "a new StatsGroup was created for portlet application " + portletApplicationStatsGroup.getName());
        }
        LOGGER.exiting(CLASS_NAME, "createPortletApplicationStatsGroup", portletApplicationStatsGroup);
    }

    public PortletAppModule(String string) {
        appName = string;
        LOGGER.entering(CLASS_NAME, "PortletAppModule", string);
        try {
            this.createPortletApplicationStatsGroup();
            this.createPortletApplicationStatsInstance();
            this.createPortletStatsGroup();
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.pmi.server.modules.PortletAppModule.PortletAppModule", (String)"100");
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "PortletAppModule", "pmi.portletapplication.statsgroup.creation.error.1", appName);
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "PortletAppModule", "", statsFactoryException);
            this.error = true;
        }
        LOGGER.exiting(CLASS_NAME, "PortletAppModule");
    }

    private void createPortletApplicationStatsInstance() throws StatsFactoryException {
        LOGGER.entering(CLASS_NAME, "createPortletApplicationStatsInstance");
        this.applicationInstance = StatsFactory.createStatsInstance((String)this.getDetailStatsGroupName(), (StatsGroup)portletApplicationStatsGroup, null, (StatisticActionListener)this);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, CLASS_NAME, "createPortletApplicationStatsInstance", "a new StatsInstance was created for portlet application " + this.applicationInstance.getName());
        }
        LOGGER.exiting(CLASS_NAME, "createPortletApplicationStatsInstance");
    }

    private void createPortletStatsGroup() throws StatsFactoryException {
        LOGGER.entering(CLASS_NAME, "createPortletStatsGroup");
        this.portletStatsGroup = StatsFactory.createStatsGroup((String)"portletModule", (String)TEMPLATE_PORTLET, (StatsInstance)this.getWebAppStatsInstance(), null);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, CLASS_NAME, "createPortletStatsGroup", "a new StatsGroup was created for portlet " + this.portletStatsGroup.getName());
        }
        LOGGER.exiting(CLASS_NAME, "createPortletStatsGroup");
    }

    private StatsInstance getWebAppStatsInstance() throws StatsFactoryException {
        LOGGER.entering(CLASS_NAME, "getWebAppStatsInstance", appName);
        StatsInstance statsInstance = StatsFactory.getStatsInstance((String[])new String[]{"webAppModule", appName});
        if (statsInstance == null) {
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "PortletAppModule", "pmi.portletapplication.statsgroup.creation.error.1", appName);
            throw new StatsFactoryException("WebAppStatsInstance could not be found");
        }
        LOGGER.exiting(CLASS_NAME, "getWebAppStatsInstance", statsInstance);
        return statsInstance;
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        LOGGER.entering(CLASS_NAME, "statisticCreated");
        if (sPIStatistic.getId() == 100) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "statisticCreated", "a portlet application statistic was created for id " + sPIStatistic.getId());
            }
            this.numLoadedPortlets = (SPICountStatistic)sPIStatistic;
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.logp(Level.FINE, CLASS_NAME, "statisticCreated", "invalid statistic id for portlet application: " + sPIStatistic.getId());
        }
        LOGGER.exiting(CLASS_NAME, "statisticCreated");
    }

    public void updateStatisticOnRequest(int n) {
    }

    public void onPortletLoaded() {
        LOGGER.entering(CLASS_NAME, "onPortletLoaded");
        if (this.numLoadedPortlets != null) {
            this.numLoadedPortlets.increment();
        }
        LOGGER.exiting(CLASS_NAME, "onPortletLoaded");
    }

    public void onPortletUnloaded() {
        LOGGER.entering(CLASS_NAME, "onPortletUnloaded");
        if (this.numLoadedPortlets != null) {
            this.numLoadedPortlets.decrement();
        }
        LOGGER.exiting(CLASS_NAME, "onPortletUnloaded");
    }

    public void dispose() {
        LOGGER.entering(CLASS_NAME, "dispose");
        try {
            if (this.applicationInstance != null) {
                StatsFactory.removeStatsInstance((StatsInstance)this.applicationInstance);
            }
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.pmi.server.modules.PortletAppModule.dispose", (String)"174", (Object)this);
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "dispose", "pmi.portletapplication.statsinstance.remove.error.1", appName);
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "dispose", "", statsFactoryException);
        }
        LOGGER.exiting(CLASS_NAME, "dispose");
    }

    public StatsGroup getStatsGroup() {
        return this.portletStatsGroup;
    }

    public boolean isError() {
        return this.error;
    }

    private String getDetailStatsGroupName() {
        return nls.getString("pmi.portletapplication.statsgroup.name", "Details");
    }

    static {
        appName = null;
    }
}

