/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.pmi.server.modules;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.pmi.server.modules.InternalPortletApplicationPerf;
import com.ibm.ws.portletcontainer.pmi.server.modules.InternalPortletPerf;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletModule
implements StatisticActionListener,
InternalPortletPerf {
    private static final String CLASS_NAME = PortletModule.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private StatsInstance portletInstance;
    private SPITimeStatistic renderResponseTime;
    private SPITimeStatistic actionResponseTime;
    private SPICountStatistic totalRequests;
    private SPICountStatistic numErrors;
    private SPIRangeStatistic concurrentRequests;

    public PortletModule(String string, InternalPortletApplicationPerf internalPortletApplicationPerf) {
        LOGGER.entering(CLASS_NAME, "PortletModule");
        try {
            if (!internalPortletApplicationPerf.isError()) {
                this.portletInstance = StatsFactory.createStatsInstance((String)string, (StatsGroup)internalPortletApplicationPerf.getStatsGroup(), null, (StatisticActionListener)this);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, CLASS_NAME, "portletModule", "a new StatsInstance was created for portlet " + this.portletInstance.getName());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "portletModule", "ignoring PMI for portlet " + this.portletInstance.getName() + " due to error in PMI setup.");
            }
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.pmi.server.modules.PortletModule.PortletModule", (String)"58", (Object)this);
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "PortletModule", "pmi.portlet.statsgroup.creation.error.1", string);
            LOGGER.logp(Level.SEVERE, CLASS_NAME, "PortletModule", "", statsFactoryException);
        }
        LOGGER.exiting(CLASS_NAME, "PortletModule");
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        LOGGER.entering(CLASS_NAME, "statisticCreated", sPIStatistic);
        if (sPIStatistic.getId() == 115) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "statisticCreated", "a portlet statistic was created for id " + sPIStatistic.getId());
            }
            this.totalRequests = (SPICountStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 116) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "statisticCreated", "a portlet statistic was created for id " + sPIStatistic.getId());
            }
            this.concurrentRequests = (SPIRangeStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 119) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "statisticCreated", "a portlet statistic was created for id " + sPIStatistic.getId());
            }
            this.numErrors = (SPICountStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 117) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "statisticCreated", "a portlet statistic was created for id " + sPIStatistic.getId());
            }
            this.renderResponseTime = (SPITimeStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 118) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, CLASS_NAME, "statisticCreated", "a portlet statistic was created for id " + sPIStatistic.getId());
            }
            this.actionResponseTime = (SPITimeStatistic)sPIStatistic;
        } else if (LOGGER.isLoggable(Level.ALL)) {
            LOGGER.logp(Level.ALL, CLASS_NAME, "statisticCreated", "invalid statistic id for portlet : " + sPIStatistic.getId());
        }
        LOGGER.exiting(CLASS_NAME, "statisticCreated");
    }

    public void updateStatisticOnRequest(int n) {
    }

    private void decRenderRequests(long l, long l2) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(CLASS_NAME, "decRenderRequests", new Object[]{new Long(l), new Long(l2)});
        }
        if (this.renderResponseTime != null && l2 >= 0L) {
            this.renderResponseTime.add(l, l2);
        }
        if (this.concurrentRequests != null) {
            this.concurrentRequests.decrement(l, 1L);
        }
        LOGGER.exiting(CLASS_NAME, "decRenderRequests");
    }

    private void decActionRequests(long l, long l2) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(CLASS_NAME, "decActionRequests", new Object[]{new Long(l), new Long(l2)});
        }
        if (this.actionResponseTime != null && l2 >= 0L) {
            this.actionResponseTime.add(l, l2);
        }
        if (this.concurrentRequests != null) {
            this.concurrentRequests.decrement(l, 1L);
        }
        LOGGER.exiting(CLASS_NAME, "decActionRequests");
    }

    private void incRenderRequests(long l) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(CLASS_NAME, "incRenderRequests", new Long(l));
        }
        if (this.totalRequests != null) {
            this.totalRequests.increment(l, 1L);
        }
        if (this.concurrentRequests != null) {
            this.concurrentRequests.increment(l, 1L);
        }
        LOGGER.exiting(CLASS_NAME, "incRenderRequests");
    }

    private void incActionRequests(long l) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(CLASS_NAME, "incActionRequests", new Long(l));
        }
        if (this.totalRequests != null) {
            this.totalRequests.increment(l, 1L);
        }
        if (this.concurrentRequests != null) {
            this.concurrentRequests.increment(l, 1L);
        }
        LOGGER.entering(CLASS_NAME, "incActionRequests");
    }

    private void incNumErrors() {
        LOGGER.entering(CLASS_NAME, "incNumErrors");
        if (this.numErrors != null) {
            this.numErrors.increment();
        }
        LOGGER.entering(CLASS_NAME, "incNumErrors");
    }

    public void onPortletRenderStartService(long l) {
        this.incRenderRequests(l);
    }

    public void onPortletRenderFinishService(long l, long l2) {
        this.decRenderRequests(l, l2);
    }

    public void onPortletActionStartService(long l) {
        this.incActionRequests(l);
    }

    public void onPortletActionFinishService(long l, long l2) {
        this.decActionRequests(l, l2);
    }

    public void onPortletError() {
        this.incNumErrors();
    }
}

