/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving;

import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinition;
import com.ibm.ws.portletcontainer.portletserving.PortletServingServlet;
import com.ibm.ws.portletcontainer.portletserving.PortletServingServletWrapper;
import com.ibm.ws.portletcontainer.portletserving.core.ObjectIDFactory;
import com.ibm.ws.portletcontainer.portletserving.core.PortletURL;
import com.ibm.ws.portletcontainer.portletserving.core.PortletWindowIdentifierImpl;
import com.ibm.ws.portletcontainer.registry.webapplicationdefinitionregistry.WebApplicationDefinitionRegistry;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletConfigParmMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletServingExtensionProcessor
extends WebExtensionProcessor {
    private static final String CLASS_NAME = PortletServingExtensionProcessor.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static final String PORTLET_DOCUMENT_CONTAINER_FILTER = "PortletDocumentContainerFilter";
    private final Object lock;
    private Map sconfigMap;
    static /* synthetic */ Class class$com$ibm$ws$portletcontainer$portletserving$filter$PortletDocumentFilterContainer;

    public PortletServingExtensionProcessor(IServletContext iServletContext) throws Exception {
        super(iServletContext);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "PortletServingExtensionProcessor", iServletContext);
        }
        this.lock = new Object();
        this.sconfigMap = Collections.synchronizedMap(new HashMap());
        this.addPatternList();
        logger.exiting(CLASS_NAME, "PortletServingExtensionProcessor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "handleRequest", new Object[]{servletRequest, servletResponse});
        }
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            boolean bl = logger.isLoggable(Level.FINEST);
            String string = this.getPortletUri(httpServletRequest);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "PortletURI: " + string);
            }
            RequestProcessor requestProcessor = null;
            Object object = this.lock;
            synchronized (object) {
                requestProcessor = this.extensionContext.getMappingTarget(string);
                if (requestProcessor == this) {
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "handleRequest", "Recognized myself as target. Replacing...");
                    }
                    IServletConfig iServletConfig = this.getServletConfig(string);
                    requestProcessor = this.createServletWrapper(iServletConfig);
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "handleRequest", "Created new target: " + requestProcessor);
                    }
                    this.replaceMapping(httpServletRequest, httpServletResponse, requestProcessor);
                }
            }
            requestProcessor.handleRequest(servletRequest, servletResponse);
        }
        logger.exiting(CLASS_NAME, "handleRequest");
    }

    public List getPatternList() {
        logger.entering(CLASS_NAME, "getPatternList");
        logger.exiting(CLASS_NAME, "getPatternList", Collections.EMPTY_LIST);
        return Collections.EMPTY_LIST;
    }

    private void addPatternList() throws Exception {
        logger.entering(CLASS_NAME, "addPatternList");
        WebApplicationDefinition webApplicationDefinition = WebApplicationDefinitionRegistry.getInstance().getWebApplicationDefinition(this.extensionContext.getContextPath());
        boolean bl = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getPatternList", "WebApplicationDefinition: " + webApplicationDefinition);
        }
        if (webApplicationDefinition != null && webApplicationDefinition.getPortletApplicationDefinition().isPortletServingEnabled()) {
            Iterator iterator = webApplicationDefinition.getPortletApplicationDefinition().getPortletDefinitionList().iterator();
            while (iterator.hasNext()) {
                PortletDefinition portletDefinition = (PortletDefinition)iterator.next();
                String string = this.getPortletUri(portletDefinition);
                this.createServletConfig(string);
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addPatternList", "Registering uri: " + string);
                }
                this.extensionContext.addMappingTarget(string, (RequestProcessor)this);
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "addPatternList", "Creating FilterConfig.");
                }
                IFilterConfig iFilterConfig = this.extensionContext.createFilterConfig(PORTLET_DOCUMENT_CONTAINER_FILTER);
                iFilterConfig.setDispatchMode(new int[]{0});
                iFilterConfig.setDisplayName(PORTLET_DOCUMENT_CONTAINER_FILTER);
                iFilterConfig.setDescription(PORTLET_DOCUMENT_CONTAINER_FILTER);
                iFilterConfig.setName(PORTLET_DOCUMENT_CONTAINER_FILTER);
                iFilterConfig.setFilterClassName((class$com$ibm$ws$portletcontainer$portletserving$filter$PortletDocumentFilterContainer == null ? PortletServingExtensionProcessor.class$("com.ibm.ws.portletcontainer.portletserving.filter.PortletDocumentFilterContainer") : class$com$ibm$ws$portletcontainer$portletserving$filter$PortletDocumentFilterContainer).getName());
                this.extensionContext.addMappingFilter(string, iFilterConfig);
            }
        }
        logger.exiting(CLASS_NAME, "addPatternList");
    }

    public IServletWrapper createServletWrapper(IServletConfig iServletConfig) throws Exception {
        PortletServingServletWrapper portletServingServletWrapper = new PortletServingServletWrapper(this.extensionContext);
        portletServingServletWrapper.initialize(iServletConfig);
        return portletServingServletWrapper;
    }

    public IServletConfig getServletConfig(String string) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getServletConfig", string);
        }
        IServletConfig iServletConfig = (IServletConfig)this.sconfigMap.remove(string);
        logger.exiting(CLASS_NAME, "getServletConfig", iServletConfig);
        return iServletConfig;
    }

    public IServletConfig createServletConfig(String string) throws ServletException {
        String string2;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "createServletConfig", string);
        }
        if ((string2 = "PortletServingServlet_" + string).endsWith("*")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        ServletConfigParmMap servletConfigParmMap = new ServletConfigParmMap();
        servletConfigParmMap.put(ServletConfigParmMap.SERVLETNAME, (Object)string2);
        servletConfigParmMap.put(ServletConfigParmMap.DISPLAYNAME, (Object)string2);
        servletConfigParmMap.put(ServletConfigParmMap.SERVLETCONTEXT, (Object)this.extensionContext);
        servletConfigParmMap.put(ServletConfigParmMap.ISJSP, (Object)Boolean.FALSE);
        servletConfigParmMap.put(ServletConfigParmMap.CLASSNAME, (Object)PortletServingServlet.class.getName());
        servletConfigParmMap.put(ServletConfigParmMap.CACHINGENABLED, (Object)Boolean.FALSE);
        servletConfigParmMap.put(ServletConfigParmMap.STATISTICSENABLED, (Object)Boolean.FALSE);
        IServletConfig iServletConfig = this.createConfig(string2, servletConfigParmMap);
        this.sconfigMap.put(string, iServletConfig);
        logger.exiting(CLASS_NAME, "createServletConfig", iServletConfig);
        return iServletConfig;
    }

    private void replaceMapping(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestProcessor requestProcessor) throws Exception {
        String string;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "replaceMapping", new Object[]{httpServletRequest, httpServletResponse, requestProcessor});
        }
        boolean bl = PortletURL.isPortletIncluded(httpServletRequest);
        String string2 = PortletURL.getPortletContext(httpServletRequest, bl);
        String string3 = PortletURL.getPortletName(httpServletRequest, bl);
        String string4 = PortletURL.getPortletWindowId(httpServletRequest, bl);
        boolean bl2 = logger.isLoggable(Level.FINEST);
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "replaceMapping", "PortletContext: " + string2 + " - PortletName: " + string3 + " - PortletWindowId: " + string4);
        }
        PortletWindowIdentifierImpl portletWindowIdentifierImpl = new PortletWindowIdentifierImpl(string2, string3, ObjectIDFactory.createObjectID(string4));
        PortletDefinition portletDefinition = portletWindowIdentifierImpl.getInternalPortletDefinition();
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "replaceMapping", "PortletDefinition: " + portletDefinition);
        }
        if (portletDefinition != null) {
            string = this.getPortletUri(portletDefinition);
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "replaceMapping", "PortletURI: " + string);
            }
        } else {
            logger.exiting(CLASS_NAME, "replaceMapping");
            throw new ServletException("Unknown portlet.");
        }
        this.extensionContext.replaceMappingTarget(string, requestProcessor);
        logger.exiting(CLASS_NAME, "replaceMapping");
    }

    private String getPortletUri(PortletDefinition portletDefinition) {
        return "/" + portletDefinition.getName() + "/*";
    }

    private String getPortletUri(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "handleRequest", "Included URI: " + string);
        }
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        string = string.endsWith("/") ? string + "*" : string + "/*";
        return string;
    }
}

