/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.om.common.Language;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.portletserving.core.PortalEnvironment;
import com.ibm.ws.portletcontainer.portletserving.core.PortletWindowIdentifier;
import com.ibm.ws.portletcontainer.portletserving.services.information.InformationProviderImpl;
import com.ibm.ws.portletcontainer.portletserving.services.information.InternalPortletActionProvider;
import com.ibm.ws.portletcontainer.portletserving.services.information.PortletURLProviderImpl;
import com.ibm.ws.portletcontainer.portletserving.services.persistence.InternalPersistenceProvider;
import com.ibm.ws.portletcontainer.portletserving.services.persistence.PersistenceProviderCookieImpl;
import com.ibm.ws.portletcontainer.portletserving.services.title.DynamicTitleServiceImpl;
import com.ibm.ws.portletcontainer.portletserving.wrappers.PortletServingServletResponseWrapper;
import com.ibm.wsspi.portletcontainer.InvalidPortletWindowIdentifierException;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.PortletContainerException;
import com.ibm.wsspi.portletcontainer.invoker.PortletContainer;
import com.ibm.wsspi.portletcontainer.invoker.PortletInvoker;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContextAdapter;
import com.ibm.wsspi.portletcontainer.services.information.InformationProvider;
import com.ibm.wsspi.portletcontainer.services.persistence.PersistenceProvider;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.portlet.UnavailableException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletServingServlet
extends GenericServlet {
    private static final String CLASS_NAME = PortletServingServlet.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static final long serialVersionUID = 347121960450583175L;
    private PortletContainer container;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.entering(CLASS_NAME, "init", servletConfig);
        super.init(servletConfig);
        this.container = (PortletContainer)servletConfig.getServletContext().getAttribute("com.ibm.wsspi.portletcontainer");
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "init", "Found this instance of a portlet container: " + this.container);
        }
        logger.exiting(CLASS_NAME, "init");
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "service", new Object[]{servletRequest, servletResponse});
        }
        boolean bl2 = logger.isLoggable(Level.FINEST);
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        PortletServingServletResponseWrapper portletServingServletResponseWrapper = new PortletServingServletResponseWrapper((HttpServletResponse)servletResponse);
        httpServletRequest.setAttribute("com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.active", (Object)Boolean.TRUE);
        PortalEnvironment portalEnvironment = null;
        PortletWindowIdentifier portletWindowIdentifier = null;
        try {
            portalEnvironment = this.createPortalEnvironment(httpServletRequest, portletServingServletResponseWrapper);
            portalEnvironment.prepare();
            portletWindowIdentifier = portalEnvironment.getRequestedPortalURL().identifyPortletWindow(this.getCloneID(httpServletRequest));
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "service", "Recognized Portlet: " + portletWindowIdentifier.getPortletName());
            }
            if (portalEnvironment.getRequestedPortalURL().getPortletUrlHelper().isAction()) {
                if (bl2) {
                    logger.logp(Level.FINEST, CLASS_NAME, "service", "Recognized Action. Creating PortletContainerContext...");
                }
                boolean bl3 = "redirect".equalsIgnoreCase((String)httpServletRequest.getAttribute("com.ibm.websphere.portlet.action"));
                this.invokePortletAction(portletWindowIdentifier, httpServletRequest, portletServingServletResponseWrapper, bl3);
                if (bl3) {
                    portalEnvironment.release();
                    logger.exiting(CLASS_NAME, "service");
                    return;
                }
            }
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "service", "Preparing rendering...");
            }
            this.invokePortletRender(portletWindowIdentifier, httpServletRequest, portletServingServletResponseWrapper, this.getDefaultTitle(portletWindowIdentifier, httpServletRequest.getLocale()));
            portletServingServletResponseWrapper.propagateCookies();
        }
        catch (InvalidURLException invalidURLException) {
            FFDCFilter.processException((Throwable)((Object)invalidURLException), (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.service", (String)"80", (Object)((Object)this));
            throw invalidURLException;
        }
        catch (InvalidPortletWindowIdentifierException invalidPortletWindowIdentifierException) {
            FFDCFilter.processException((Throwable)invalidPortletWindowIdentifierException, (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.service", (String)"80", (Object)((Object)this));
            throw new ServletException("Invalid Portlet URL.", (Throwable)invalidPortletWindowIdentifierException);
        }
        finally {
            if (portalEnvironment != null) {
                portalEnvironment.release();
            }
        }
        logger.exiting(CLASS_NAME, "service");
    }

    protected PortalEnvironment createPortalEnvironment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws InvalidURLException {
        return new PortalEnvironment(httpServletRequest, httpServletResponse);
    }

    public void destroy() {
    }

    private void invokePortletAction(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws ServletException, IOException {
        boolean bl2 = logger.isLoggable(Level.FINER);
        if (bl2) {
            logger.entering(CLASS_NAME, "invokePortletAction", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, bl});
        }
        boolean bl3 = logger.isLoggable(Level.FINEST);
        PortletContainerContextAdapter portletContainerContextAdapter = this.createContext(httpServletRequest, httpServletResponse);
        PortletInvoker portletInvoker = null;
        try {
            portletInvoker = this.getPortletInvoker(portletContainerContextAdapter);
            portletInvoker.invokeProcessAction(portletWindowIdentifier, httpServletRequest, httpServletResponse);
            InternalPersistenceProvider internalPersistenceProvider = (InternalPersistenceProvider)portletContainerContextAdapter.getContainerService(PersistenceProvider.class);
            internalPersistenceProvider.addCookiesToResponse();
            if (bl3) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePortletAction", "Action called. Redirect? " + bl);
            }
            if (bl) {
                if (httpServletResponse instanceof PortletServingServletResponseWrapper) {
                    ((PortletServingServletResponseWrapper)httpServletResponse).propagateCookies();
                }
                InformationProvider informationProvider = (InformationProvider)portletContainerContextAdapter.getContainerService(InformationProvider.class);
                this.sendRedirect(httpServletRequest, httpServletResponse, (InternalPortletActionProvider)informationProvider.getPortletActionProvider(portletWindowIdentifier));
            }
        }
        catch (PortletException portletException) {
            FFDCFilter.processException((Throwable)portletException, (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.invokePortletAction", (String)"218", (Object)((Object)this));
            throw new ServletException((Throwable)portletException);
        }
        catch (PortletContainerException portletContainerException) {
            FFDCFilter.processException((Throwable)portletContainerException, (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.invokePortletAction", (String)"222", (Object)((Object)this));
            throw new ServletException((Throwable)portletContainerException);
        }
        logger.exiting(CLASS_NAME, "invokePortletAction");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokePortletRender(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        String string2;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "invokePortletRender", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, string});
        }
        boolean bl2 = logger.isLoggable(Level.FINEST);
        PortletContainerContextAdapter portletContainerContextAdapter = this.createContext(httpServletRequest, httpServletResponse);
        DynamicTitleServiceImpl dynamicTitleServiceImpl = new DynamicTitleServiceImpl(portletWindowIdentifier, string);
        portletContainerContextAdapter.addContainerService(dynamicTitleServiceImpl);
        PortletInvoker portletInvoker = null;
        try {
            try {
                portletInvoker = this.getPortletInvoker(portletContainerContextAdapter);
                portletInvoker.invokeRender(portletWindowIdentifier, httpServletRequest, httpServletResponse);
                if (bl2) {
                    logger.logp(Level.FINEST, CLASS_NAME, "invokePortletRender", "Render called.");
                }
            }
            catch (PortletContainerException portletContainerException) {
                FFDCFilter.processException((Throwable)portletContainerException, (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.invokePortletRender", (String)"284", (Object)((Object)this));
                throw new ServletException((Throwable)portletContainerException);
            }
            catch (UnavailableException unavailableException) {
                FFDCFilter.processException((Throwable)unavailableException, (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.invokePortletRender", (String)"288", (Object)((Object)this));
                logger.logp(Level.SEVERE, CLASS_NAME, "invokePortletRender", "portletserving.portlet.render.unavailable.0", unavailableException);
                if (unavailableException.isPermanent()) {
                    throw new javax.servlet.UnavailableException(unavailableException.getMessage());
                }
                throw new javax.servlet.UnavailableException(unavailableException.getMessage(), unavailableException.getUnavailableSeconds());
            }
            catch (PortletException portletException) {
                FFDCFilter.processException((Throwable)portletException, (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.invokePortletRender", (String)"296", (Object)((Object)this));
                throw new ServletException((Throwable)portletException);
            }
            Object var12_10 = null;
            string2 = dynamicTitleServiceImpl.getDynamicTitle(portletWindowIdentifier, httpServletRequest);
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            String string3 = dynamicTitleServiceImpl.getDynamicTitle(portletWindowIdentifier, httpServletRequest);
            httpServletRequest.setAttribute("javax.portlet.title", (Object)string3);
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "invokePortletRender", "Title set as request attribute.", string3);
            }
            throw throwable;
        }
        httpServletRequest.setAttribute("javax.portlet.title", (Object)string2);
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "invokePortletRender", "Title set as request attribute.", string2);
        }
        logger.exiting(CLASS_NAME, "invokePortletRender");
    }

    private String getDefaultTitle(PortletWindowIdentifier portletWindowIdentifier, Locale locale) {
        Object object;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getDefaultTitle", new Object[]{portletWindowIdentifier, locale});
        }
        Language language = null;
        PortletDefinition portletDefinition = portletWindowIdentifier.getInternalPortletDefinition();
        if (portletDefinition != null && (language = (object = portletDefinition.getLanguageSet()).get(locale)) == null) {
            locale = object.getDefaultLocale();
            language = object.get(locale);
        }
        object = language != null ? language.getTitle() : "";
        logger.exiting(CLASS_NAME, "getDefaultTitle", object);
        return object;
    }

    private void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, InternalPortletActionProvider internalPortletActionProvider) throws IOException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "sendRedirect", new Object[]{httpServletRequest, httpServletResponse, internalPortletActionProvider});
        }
        boolean bl2 = logger.isLoggable(Level.FINEST);
        String string = internalPortletActionProvider.getRedirectURL();
        if (string == null) {
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "sendRedirect", "Constructing redirect URL");
            }
            PortletURLProviderImpl portletURLProviderImpl = new PortletURLProviderImpl(httpServletRequest, httpServletResponse, internalPortletActionProvider.getPortletWindow(), true);
            if (internalPortletActionProvider.getPortletMode() != null) {
                portletURLProviderImpl.setPortletMode(internalPortletActionProvider.getPortletMode());
            }
            if (internalPortletActionProvider.getWindowState() != null) {
                portletURLProviderImpl.setWindowState(internalPortletActionProvider.getWindowState());
            }
            if (internalPortletActionProvider.getParameters() != null) {
                portletURLProviderImpl.setParameters(internalPortletActionProvider.getParameters());
            }
            string = ((Object)portletURLProviderImpl).toString();
        }
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "sendRedirect", "Redirecting to " + string);
        }
        httpServletResponse.sendRedirect(string);
        logger.exiting(CLASS_NAME, "sendRedirect");
    }

    private PortletInvoker getPortletInvoker(final PortletContainerContextAdapter portletContainerContextAdapter) throws PortletContainerException {
        PortletInvoker portletInvoker;
        block2: {
            portletInvoker = null;
            try {
                portletInvoker = (PortletInvoker)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws PortletContainerException {
                        return PortletServingServlet.this.container.getPortletInvoker(portletContainerContextAdapter);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.portletcontainer.portletserving.PortletServingServlet.getPortletInvoker", (String)"379", (Object)((Object)this));
                Exception exception = privilegedActionException.getException();
                if (!(exception instanceof PortletContainerException)) break block2;
                throw (PortletContainerException)exception;
            }
        }
        return portletInvoker;
    }

    protected PortletContainerContextAdapter createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        PortletContainerContextAdapter portletContainerContextAdapter = new PortletContainerContextAdapter();
        InformationProviderImpl informationProviderImpl = new InformationProviderImpl(httpServletRequest, httpServletResponse, this.getServletConfig());
        portletContainerContextAdapter.addContainerService(informationProviderImpl);
        PersistenceProviderCookieImpl persistenceProviderCookieImpl = new PersistenceProviderCookieImpl(httpServletRequest, httpServletResponse);
        portletContainerContextAdapter.addContainerService(persistenceProviderCookieImpl);
        return portletContainerContextAdapter;
    }

    protected ObjectID getCloneID(HttpServletRequest httpServletRequest) {
        return null;
    }
}

