/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.core;

import com.ibm.ws.portletcontainer.portletserving.core.PortletControlParameter;
import com.ibm.ws.portletcontainer.portletserving.core.PortletURL;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalEnvironment {
    private static final String CLASS_NAME = PortalEnvironment.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static final String REQUEST_PORTALENV = "com.ibm.ws.portletcontainer.portletserving.core.PortalEnvironment";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Object obj;
    protected PortletURL requestedPortalURL;
    private PortletControlParameter portalControl;

    public PortalEnvironment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws InvalidURLException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "PortalEnvironment", new Object[]{httpServletRequest, httpServletResponse});
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.requestedPortalURL = new PortletURL(this);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "PortalEnvironment", "PortletURL instantiated: " + this.requestedPortalURL.hashCode());
        }
        this.portalControl = new PortletControlParameter(this.requestedPortalURL, false);
        logger.exiting(CLASS_NAME, "PortalEnvironment");
    }

    public void prepare() {
        logger.entering(CLASS_NAME, "prepare", this.request);
        this.obj = this.request.getAttribute(REQUEST_PORTALENV);
        this.request.setAttribute(REQUEST_PORTALENV, (Object)this);
        logger.exiting(CLASS_NAME, "prepare");
    }

    public void release() {
        logger.entering(CLASS_NAME, "release", this.request);
        this.request.setAttribute(REQUEST_PORTALENV, this.obj);
        logger.exiting(CLASS_NAME, "release");
    }

    public static PortalEnvironment getPortalEnvironment(HttpServletRequest httpServletRequest) {
        logger.entering(CLASS_NAME, "getPortalEnvironment", httpServletRequest);
        PortalEnvironment portalEnvironment = (PortalEnvironment)httpServletRequest.getAttribute(REQUEST_PORTALENV);
        if (portalEnvironment == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "getPortalEnvironment", "Prepare method has not been called.");
        }
        logger.exiting(CLASS_NAME, "getPortalEnvironment", portalEnvironment);
        return portalEnvironment;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public PortletURL getRequestedPortalURL() {
        return this.requestedPortalURL;
    }

    public PortletControlParameter getPortalControlParameter() {
        return this.portalControl;
    }
}

