/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.core;

import com.ibm.ws.portletcontainer.portletserving.core.PortletURL;
import com.ibm.ws.portletcontainer.portletserving.util.StringUtils;
import com.ibm.ws.portletcontainer.portletserving.util.URLUTF8Encoder;
import com.ibm.wsspi.portletcontainer.util.PortletURLHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

public class PortletControlParameter {
    private static final String CLASS_NAME = PortletControlParameter.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static final String VERSION = "ver";
    private static final String ACTION = "action";
    private static final String MODE = "mode";
    private static final String RENDER_PARAM = "rparam";
    private static final String STATE = "state";
    private boolean action;
    private String portletMode;
    private String windowState;
    private Map renderParameters;
    private Map requestParameter;
    private PortletURL url;

    public PortletControlParameter(PortletURL portletURL) {
        this(portletURL, true);
    }

    public PortletControlParameter(PortletURL portletURL, boolean bl) {
        boolean bl2 = logger.isLoggable(Level.FINER);
        if (bl2) {
            logger.entering(CLASS_NAME, "PortletControlParameter", new Object[]{portletURL, bl});
        }
        this.url = portletURL;
        this.portletMode = portletURL.getPortletUrlHelper().getPortletMode();
        this.windowState = portletURL.getPortletUrlHelper().getWindowState();
        this.renderParameters = bl ? (Map)((HashMap)portletURL.getPortletUrlHelper().getRenderParameters()).clone() : portletURL.getPortletUrlHelper().getRenderParameters();
        this.requestParameter = new HashMap();
        logger.exiting(CLASS_NAME, "PortletControlParameter");
    }

    public Map getRequestParameter() {
        return this.requestParameter;
    }

    public void setRequestParams(Map map) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "setRequestParams", new Object[]{map});
        }
        if (map != null) {
            boolean bl2 = logger.isLoggable(Level.FINEST);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String[] stringArray = (String[])map.get(string);
                string = URLUTF8Encoder.encode(string);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = URLUTF8Encoder.encode(stringArray[i]);
                }
                if (bl2) {
                    logger.logp(Level.FINEST, CLASS_NAME, "setRequestParams", "Adding request parameter with name '" + string + "' and values '" + stringArray + "'.");
                }
                this.requestParameter.put(string, stringArray);
            }
        }
        logger.exiting(CLASS_NAME, "setRequestParams");
    }

    public static boolean isStateControlParamName(String string) {
        return MODE.equals(string) || STATE.equals(string) || RENDER_PARAM.equals(string);
    }

    static String getVersionKey() {
        return VERSION;
    }

    public static boolean isVersionParam(String string) {
        logger.entering(CLASS_NAME, "isVersionParam", string);
        if (string.startsWith(VERSION)) {
            logger.exiting(CLASS_NAME, "isVersionParam", Boolean.TRUE);
            return true;
        }
        logger.exiting(CLASS_NAME, "isVersionParam", Boolean.FALSE);
        return false;
    }

    static String getActionKey() {
        return ACTION;
    }

    public static boolean isActionParam(String string) {
        logger.entering(CLASS_NAME, "isActionParam", string);
        if (ACTION.equals(string)) {
            logger.exiting(CLASS_NAME, "isActionParam", Boolean.TRUE);
            return true;
        }
        logger.exiting(CLASS_NAME, "isActionParam", Boolean.FALSE);
        return false;
    }

    public boolean isAction() {
        return this.action;
    }

    public void setAction() {
        this.action = true;
    }

    public static String getPortletModeKey() {
        return MODE;
    }

    public static boolean isPortletModeParam(String string) {
        return string.startsWith(MODE);
    }

    public PortletMode getPortletMode() {
        logger.entering(CLASS_NAME, "getPortletMode");
        PortletMode portletMode = this.portletMode != null ? PortletURLHelper.getPortletMode(this.portletMode) : PortletMode.VIEW;
        logger.exiting(CLASS_NAME, "getPortletMode", portletMode);
        return portletMode;
    }

    public void setPortletMode(PortletMode portletMode) {
        logger.entering(CLASS_NAME, "setPortletMode", portletMode);
        this.portletMode = portletMode.toString();
        logger.exiting(CLASS_NAME, "setPortletMode");
    }

    public static String getWindowStateKey() {
        return STATE;
    }

    public static boolean isWindowStateParam(String string) {
        return string.startsWith(STATE);
    }

    public WindowState getWindowState() {
        logger.entering(CLASS_NAME, "getWindowState");
        WindowState windowState = this.windowState != null ? PortletURLHelper.getWindowState(this.windowState) : WindowState.NORMAL;
        logger.exiting(CLASS_NAME, "getWindowState", windowState);
        return windowState;
    }

    public void setWindowState(WindowState windowState) {
        logger.entering(CLASS_NAME, "setWindowState", windowState);
        this.windowState = windowState.toString();
        logger.exiting(CLASS_NAME, "setWindowState");
    }

    static String getRenderParamKey() {
        return RENDER_PARAM;
    }

    public static boolean isRenderParam(String string) {
        return string.startsWith(RENDER_PARAM);
    }

    public void setRenderParams(Map map) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "setRenderParams", new Object[]{map});
        }
        if (map != null) {
            boolean bl2 = logger.isLoggable(Level.FINEST);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String[] stringArray = (String[])map.get(string);
                if (bl2) {
                    logger.logp(Level.FINEST, CLASS_NAME, "setRenderParams", "Adding render parameter with name '" + string + "' and values '" + stringArray + "'.");
                }
                this.renderParameters.put(string, PortletControlParameter.encodeRenderParamValues(stringArray));
            }
        }
        logger.exiting(CLASS_NAME, "setRenderParams");
    }

    public Map getRenderParameters() {
        return this.renderParameters;
    }

    public Map getClonedRenderParameters() {
        return (Map)((HashMap)this.renderParameters).clone();
    }

    public void clearRenderParameters() {
        logger.entering(CLASS_NAME, "clearRenderParameters");
        this.renderParameters.clear();
        logger.exiting(CLASS_NAME, "clearRenderParameters");
    }

    public static String encodeValueFull(String string) {
        logger.entering(CLASS_NAME, "encodeValueFull", string);
        string = PortletControlParameter.encodeValue(string);
        string = URLUTF8Encoder.encode(string);
        logger.exiting(CLASS_NAME, "encodeValueFull", string);
        return string;
    }

    public static String encodeValue(String string) {
        logger.entering(CLASS_NAME, "encodeValue", string);
        string = StringUtils.replace(string, "_", "0x1");
        string = StringUtils.replace(string, "=", "0x2");
        string = StringUtils.replace(string, "/", "0x3");
        string = StringUtils.replace(string, "?", "0x4");
        string = StringUtils.replace(string, "+", "0x5");
        logger.exiting(CLASS_NAME, "encodeValue", string);
        return string;
    }

    public static String encodeParameter(String string) {
        return string;
    }

    public static String encodeRenderParamName(String string) {
        logger.entering(CLASS_NAME, "encodeRenderParamName", string);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(RENDER_PARAM);
        stringBuffer.append("=");
        stringBuffer.append(PortletControlParameter.encodeValueFull(string));
        String string2 = stringBuffer.toString();
        logger.exiting(CLASS_NAME, "encodeRenderParamName", string2);
        return string2;
    }

    public static String encodeRenderParamValues(String[] stringArray) {
        logger.entering(CLASS_NAME, "encodeRenderParamValues", stringArray);
        String string = "";
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(PortletControlParameter.encodeValueFull(stringArray[0]));
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append("=");
                stringBuffer.append(PortletControlParameter.encodeValueFull(stringArray[i]));
            }
            string = stringBuffer.toString();
        }
        logger.exiting(CLASS_NAME, "encodeRenderParamValues", string);
        return string;
    }

    public static String decodeParameterName(String string) {
        return PortletControlParameter.decodeValue(string);
    }

    public static String decodeParameterValue(String string, String string2) {
        return PortletControlParameter.decodeValue(string2);
    }

    public static String decodeValue(String string) {
        logger.entering(CLASS_NAME, "decodeValue", string);
        string = StringUtils.replace(string, "0x1", "_");
        string = StringUtils.replace(string, "0x2", "=");
        string = StringUtils.replace(string, "0x3", "/");
        string = StringUtils.replace(string, "0x4", "?");
        string = StringUtils.replace(string, "0x5", "+");
        logger.exiting(CLASS_NAME, "decodeValue", string);
        return string;
    }

    private static String[] decodeRenderParamValues(String string) {
        logger.entering(CLASS_NAME, "decodeRenderParamValues", string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (!stringTokenizer.hasMoreTokens()) {
            logger.exiting(CLASS_NAME, "decodeRenderParamValues", "<NULL>");
            return null;
        }
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (!stringTokenizer.hasMoreTokens()) {
                logger.exiting(CLASS_NAME, "decodeRenderParamValues", "<NULL>");
                return null;
            }
            stringArray[i] = PortletControlParameter.decodeValue(stringTokenizer.nextToken());
        }
        logger.exiting(CLASS_NAME, "decodeRenderParamValues", stringArray);
        return stringArray;
    }
}

