/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.core;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.portletcontainer.om.portlet.CustomPortletMode;
import com.ibm.ws.portletcontainer.om.portlet.CustomWindowState;
import com.ibm.ws.portletcontainer.portletserving.core.ObjectIDFactory;
import com.ibm.ws.portletcontainer.portletserving.core.PortalEnvironment;
import com.ibm.ws.portletcontainer.portletserving.core.PortletControlParameter;
import com.ibm.ws.portletcontainer.portletserving.core.PortletWindowIdentifier;
import com.ibm.ws.portletcontainer.portletserving.core.PortletWindowIdentifierImpl;
import com.ibm.ws.portletcontainer.portletserving.util.URLTokenizer;
import com.ibm.ws.portletcontainer.portletserving.util.URLUTF8Encoder;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.InvalidPortletWindowIdentifierException;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.util.PortletURLHelper;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class PortletURL {
    private static final String CLASS_NAME = PortletURL.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private boolean analyzed = false;
    private boolean secure;
    private String baseURI;
    private String concatPortletWindowId;
    private PortletWindowIdentifier portletWindowIdentifier;
    protected PortletURLHelper portletUrlHelper;
    protected PortalEnvironment environment;

    public PortletURL(PortalEnvironment portalEnvironment) throws InvalidURLException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "PortletURL", new Object[]{portalEnvironment});
        }
        this.environment = portalEnvironment;
        HttpServletRequest httpServletRequest = portalEnvironment.getRequest();
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        this.baseURI = stringBuffer.toString();
        boolean bl2 = logger.isLoggable(Level.FINEST);
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "PortletURL", "BaseURI: " + this.baseURI);
        }
        boolean bl3 = PortletURL.isPortletIncluded(httpServletRequest);
        String string2 = PortletURL.getPortletContext(httpServletRequest, bl3);
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "PortletURL", "Context: " + string2);
        }
        String string3 = PortletURL.getPortletName(httpServletRequest, bl3);
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "PortletURL", "PortletName: " + string3);
        }
        String string4 = PortletURL.getPortletPathInfo(httpServletRequest, bl3);
        this.portletUrlHelper = new PortletURLHelper(string2, string3, string4);
        this.concatPortletWindowId = this.portletUrlHelper.getPortletName() + "_" + this.portletUrlHelper.getPortletWindowId();
        logger.exiting(CLASS_NAME, "PortletURL");
    }

    public PortalEnvironment getPortalEnvironment() {
        return this.environment;
    }

    public String getBaseURLexcludeContext() {
        return this.baseURI;
    }

    public void addControlParameterAsString(PortletControlParameter portletControlParameter, StringBuffer stringBuffer) {
        String string;
        String string2;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addControlParameterAsString", new Object[]{portletControlParameter, stringBuffer});
        }
        Map map = null;
        PortletMode portletMode = PortletMode.VIEW;
        WindowState windowState = WindowState.NORMAL;
        if (portletControlParameter != null) {
            map = portletControlParameter.getRenderParameters();
            portletMode = portletControlParameter.getPortletMode();
            windowState = portletControlParameter.getWindowState();
        } else {
            String string3;
            map = this.getPortletUrlHelper().getRenderParameters();
            String string4 = this.getPortletUrlHelper().getPortletMode();
            if (string4 != null) {
                portletMode = new PortletMode(string4);
            }
            if ((string3 = this.getPortletUrlHelper().getWindowState()) != null) {
                windowState = new WindowState(string3);
            }
        }
        boolean bl = !map.isEmpty() || portletMode != PortletMode.VIEW || windowState != WindowState.NORMAL;
        boolean bl2 = false;
        if (portletControlParameter != null && portletControlParameter.isAction()) {
            bl2 = true;
            bl = true;
        }
        if (bl) {
            stringBuffer.append('/');
            stringBuffer.append(PortletControlParameter.getVersionKey());
            stringBuffer.append('=');
            stringBuffer.append(this.portletUrlHelper.getVersion());
        }
        if (bl2) {
            stringBuffer.append('/');
            stringBuffer.append(PortletControlParameter.getActionKey());
        }
        if (!(string2 = portletMode.toString()).equals(PortletMode.VIEW.toString())) {
            stringBuffer.append('/');
            stringBuffer.append(PortletControlParameter.getPortletModeKey());
            stringBuffer.append('=');
            stringBuffer.append(string2);
        }
        if (!(string = windowState.toString()).equals(WindowState.NORMAL.toString())) {
            stringBuffer.append('/');
            stringBuffer.append(PortletControlParameter.getWindowStateKey());
            stringBuffer.append('=');
            stringBuffer.append(string);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            Map.Entry entry = iterator.next();
            String string5 = (String)entry.getKey();
            stringBuffer.append('/');
            stringBuffer.append(PortletControlParameter.encodeParameter(PortletControlParameter.encodeRenderParamName(string5)));
            Object v = entry.getValue();
            if (v instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)v;
            } else {
                stringArray = (String[])v;
            }
            String[] stringArray3 = stringArray;
            for (int i = 0; i < stringArray3.length; ++i) {
                stringBuffer.append('=');
                stringBuffer.append(stringArray3[i]);
            }
        }
        logger.exiting(CLASS_NAME, "addControlParameterAsString", stringBuffer.toString());
    }

    public void addRequestParameterAsString(PortletControlParameter portletControlParameter, StringBuffer stringBuffer, String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addRequestParameterAsString", new Object[]{portletControlParameter, stringBuffer});
        }
        boolean bl = false;
        if (portletControlParameter != null) {
            Map map = portletControlParameter.getRequestParameter();
            Iterator iterator = map.keySet().iterator();
            boolean bl2 = iterator.hasNext();
            if (bl2) {
                stringBuffer.append("?");
                bl = true;
            }
            while (bl2) {
                String[] stringArray;
                String string2 = (String)iterator.next();
                Object v = map.get(string2);
                if (v instanceof String) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)v;
                } else {
                    stringArray = (String[])v;
                }
                String[] stringArray3 = stringArray;
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append(stringArray3[0]);
                for (int i = 1; i < stringArray3.length; ++i) {
                    stringBuffer.append("&");
                    stringBuffer.append(string2);
                    stringBuffer.append("=");
                    stringBuffer.append(stringArray3[i]);
                }
                bl2 = iterator.hasNext();
                if (!bl2) continue;
                stringBuffer.append("&");
            }
        }
        if (string != null) {
            if (!bl) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append(string);
        }
        logger.exiting(CLASS_NAME, "getRequestParameterAsString", stringBuffer.toString());
    }

    public PortletURLHelper getPortletUrlHelper() {
        return this.portletUrlHelper;
    }

    public String getConcatPortletWindowId() {
        return this.concatPortletWindowId;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(PortletControlParameter portletControlParameter) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "toString", new Object[]{portletControlParameter});
        }
        String string = (String)this.environment.getRequest().getAttribute("com.ibm.wsspi.portlet.url.prefix");
        String string2 = (String)this.environment.getRequest().getAttribute("com.ibm.wsspi.portlet.url.suffix");
        if (string2 == null) {
            string2 = "";
        }
        String string3 = (String)this.environment.getRequest().getAttribute("com.ibm.wsspi.portlet.url.queryparams");
        StringBuffer stringBuffer = new StringBuffer(500);
        if (string != null) {
            if (string.indexOf("://") != -1) {
                stringBuffer.append(string);
                if (!string.endsWith("/")) {
                    stringBuffer.append('/');
                }
            } else {
                stringBuffer.append(this.baseURI);
                if (!this.baseURI.endsWith("/") && !string.startsWith("/")) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(string);
                if (!string.endsWith("/")) {
                    stringBuffer.append('/');
                }
            }
        } else {
            stringBuffer.append(this.baseURI);
            stringBuffer.append('/');
        }
        stringBuffer.append(this.environment.getRequest().getAttribute("com.ibm.ws.portletcontainer.aggregation_taglib") == null ? this.portletUrlHelper.getContext().substring(1) : URLUTF8Encoder.encode(this.portletUrlHelper.getContext().substring(1)));
        stringBuffer.append('/');
        stringBuffer.append(URLUTF8Encoder.encode(this.portletUrlHelper.getPortletName()));
        stringBuffer.append('/');
        stringBuffer.append(URLUTF8Encoder.encode(this.portletUrlHelper.getPortletWindowId()));
        this.addControlParameterAsString(portletControlParameter, stringBuffer);
        stringBuffer.append(string2);
        this.addRequestParameterAsString(portletControlParameter, stringBuffer, string3);
        String string4 = this.environment.getResponse().encodeURL(stringBuffer.toString());
        logger.exiting(CLASS_NAME, "toString", string4);
        return string4;
    }

    public static String stripPortletWindowId(com.ibm.wsspi.portletcontainer.PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "stripPortletWindowId", portletWindowIdentifier);
        String string = portletWindowIdentifier.getId(IdentifierNamespace.URL).toString().substring(portletWindowIdentifier.getPortletName().length() + 1);
        logger.exiting(CLASS_NAME, "stripPortletWindowId", string);
        return string;
    }

    public PortletWindowIdentifier identifyPortletWindow() throws InvalidURLException, InvalidPortletWindowIdentifierException {
        return this.identifyPortletWindow(null);
    }

    public PortletWindowIdentifier identifyPortletWindow(ObjectID objectID) throws InvalidURLException, InvalidPortletWindowIdentifierException {
        if (this.portletWindowIdentifier == null) {
            this.portletWindowIdentifier = this.createPortletWindowIdentifier(objectID);
            if (!this.isURLValidForPortlet()) {
                throw new InvalidURLException(this.getInvalidURLMessage());
            }
        }
        return this.portletWindowIdentifier;
    }

    private PortletWindowIdentifierImpl createPortletWindowIdentifier(ObjectID objectID) throws InvalidPortletWindowIdentifierException {
        logger.entering(CLASS_NAME, "createPortletWindowIdentifier", this.portletUrlHelper.getPortletName());
        boolean bl = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "createPortletWindowIdentifier", "PortletContext: " + this.portletUrlHelper.getContext() + " - PortletName: " + this.portletUrlHelper.getPortletName() + " - PortletWindowId: " + this.getConcatPortletWindowId());
        }
        PortletWindowIdentifierImpl portletWindowIdentifierImpl = new PortletWindowIdentifierImpl(this.portletUrlHelper.getContext(), this.portletUrlHelper.getPortletName(), ObjectIDFactory.createObjectID(this.getConcatPortletWindowId()));
        if (objectID != null) {
            portletWindowIdentifierImpl.setCloneId(objectID);
        }
        logger.exiting(CLASS_NAME, "createPortletWindowIdentifier", portletWindowIdentifierImpl);
        return portletWindowIdentifierImpl;
    }

    protected boolean isURLValidForPortlet() {
        boolean bl;
        String string = this.portletUrlHelper.getPortletMode();
        boolean bl2 = bl = string != null ? PortletURL.isPortletModeAllowed(string, this.portletWindowIdentifier) : true;
        if (bl) {
            string = this.portletUrlHelper.getWindowState();
            bl = string != null ? PortletURL.isWindowStateAllowed(string, this.portletWindowIdentifier) : true;
        }
        return bl;
    }

    static boolean isPortletModeAllowed(String string, PortletWindowIdentifier portletWindowIdentifier) {
        boolean bl = portletWindowIdentifier.getInternalPortletDefinition().getContentTypeSet().supportsPortletMode(new PortletMode(string));
        if (bl && !PortletURL.isStandardPortletMode(string)) {
            bl = false;
            String string2 = string.toString();
            Iterator iterator = portletWindowIdentifier.getInternalPortletDefinition().getPortletApplicationDefinition().getCustomPortletModes().iterator();
            while (!bl && iterator.hasNext()) {
                bl = string2.equalsIgnoreCase(((CustomPortletMode)iterator.next()).getModeName());
            }
        }
        return bl;
    }

    private static boolean isStandardPortletMode(String string) {
        return PortletMode.VIEW.toString().equalsIgnoreCase(string) || PortletMode.EDIT.toString().equalsIgnoreCase(string) || PortletMode.HELP.toString().equalsIgnoreCase(string);
    }

    static boolean isWindowStateAllowed(String string, PortletWindowIdentifier portletWindowIdentifier) {
        boolean bl = PortletURL.isStandardWindowState(string);
        if (!bl) {
            Iterator iterator = portletWindowIdentifier.getInternalPortletDefinition().getPortletApplicationDefinition().getCustomWindowStates().iterator();
            while (!bl && iterator.hasNext()) {
                bl = string.equalsIgnoreCase(((CustomWindowState)iterator.next()).getStateName());
            }
        }
        return bl;
    }

    private static boolean isStandardWindowState(String string) {
        return WindowState.MINIMIZED.toString().equalsIgnoreCase(string) || WindowState.NORMAL.toString().equalsIgnoreCase(string) || WindowState.MAXIMIZED.toString().equalsIgnoreCase(string);
    }

    private String getInvalidURLMessage() {
        return nls.getString("portletserving.invalid.url.error.0", "An InvalidURLException occurred. The provided portlet url is invalid.");
    }

    public static boolean isPortletIncluded(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute("javax.servlet.include.servlet_path") != null;
    }

    public static String getPortletContext(HttpServletRequest httpServletRequest, boolean bl) {
        if (bl) {
            return (String)httpServletRequest.getAttribute("javax.servlet.include.context_path");
        }
        return httpServletRequest.getContextPath();
    }

    public static String getPortletName(HttpServletRequest httpServletRequest, boolean bl) {
        String string = bl ? (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path") : httpServletRequest.getServletPath();
        if ((string = string.substring(1)).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getPortletWindowId(HttpServletRequest httpServletRequest, boolean bl) {
        URLTokenizer uRLTokenizer;
        String string = "";
        String string2 = PortletURL.getPortletPathInfo(httpServletRequest, bl);
        if (string2 != null && (uRLTokenizer = new URLTokenizer(string2, "/")).hasMoreTokens()) {
            string = uRLTokenizer.nextToken();
        }
        if ("".equals(string)) {
            string = "default";
        }
        return string;
    }

    private static String getPortletPathInfo(HttpServletRequest httpServletRequest, boolean bl) {
        if (bl) {
            return (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        }
        return httpServletRequest.getPathInfo();
    }
}

