/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.filter;

import com.ibm.websphere.servlet.response.StoredResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import com.ibm.wsspi.portletcontainer.util.FilterRequestHelper;
import com.ibm.wsspi.portletcontainer.util.PortletURLHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultFilter
implements Filter {
    private static final String CLASS_NAME = DefaultFilter.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private FilterConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.entering(CLASS_NAME, "init", filterConfig);
        this.config = filterConfig;
        logger.exiting(CLASS_NAME, "init");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        PortletURLHelper portletURLHelper;
        boolean bl = logger.isLoggable(Level.FINER);
        boolean bl2 = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.entering(CLASS_NAME, "doFilter", new Object[]{servletRequest, servletResponse, filterChain});
        }
        if (FilterRequestHelper.isDocument(servletRequest)) {
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Document already found. Continue filter chain...");
            }
            filterChain.doFilter(servletRequest, servletResponse);
            logger.exiting(CLASS_NAME, "doFilter");
            return;
        }
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Document not found. Default filter applies...");
        }
        FilterRequestHelper.setDocument(servletRequest);
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletRequest.setCharacterEncoding("UTF-8");
        try {
            portletURLHelper = new PortletURLHelper("", "", httpServletRequest.getPathInfo());
            if (portletURLHelper.isAction()) {
                FilterRequestHelper.setRedirect(servletRequest);
                if (bl2) {
                    logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Action found. Continue filter chain with redirect...");
                }
                filterChain.doFilter(servletRequest, servletResponse);
                logger.exiting(CLASS_NAME, "doFilter");
                return;
            }
        }
        catch (InvalidURLException invalidURLException) {
            FFDCFilter.processException((Throwable)((Object)invalidURLException), (String)"com.ibm.ws.portletcontainer.portletserving.filter.DefaultFilter.doFilter", (String)"82", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "doFilter", "portletserving.defaultfilter.action.0", (Throwable)((Object)invalidURLException));
            httpServletResponse.sendError(invalidURLException.getStatusCode(), invalidURLException.getMessage());
            logger.exiting(CLASS_NAME, "doFilter");
            return;
        }
        portletURLHelper = new StoredResponse();
        portletURLHelper.setContentType("text/html");
        portletURLHelper.setCharacterEncoding("UTF-8");
        try {
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Continue filter chain to render portlet...");
            }
            filterChain.doFilter(servletRequest, (ServletResponse)portletURLHelper);
        }
        catch (InvalidURLException invalidURLException) {
            FFDCFilter.processException((Throwable)((Object)invalidURLException), (String)"com.ibm.ws.portletcontainer.portletserving.filter.DefaultFilter.doFilter", (String)"106", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "doFilter", "portletserving.defaultfilter.render.0", (Throwable)((Object)invalidURLException));
            httpServletResponse.sendError(invalidURLException.getStatusCode(), invalidURLException.getMessage());
            logger.exiting(CLASS_NAME, "doFilter");
            return;
        }
        servletResponse.setContentType("text/html");
        servletResponse.setCharacterEncoding("UTF-8");
        Cookie[] cookieArray = portletURLHelper.getCookies();
        if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Transferring cookies... count: " + cookieArray.length);
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Cookie[" + i + "]: " + cookieArray[i]);
            }
            httpServletResponse.addCookie(cookieArray[i]);
        }
        PrintWriter printWriter = servletResponse.getWriter();
        printWriter.println("<HTML>");
        printWriter.println("<HEAD><TITLE>");
        printWriter.println(FilterRequestHelper.getDynamicTitle(servletRequest));
        printWriter.println("</TITLE></HEAD>");
        printWriter.println("<BODY>");
        printWriter.println(portletURLHelper.getOutputBufferAsString());
        printWriter.println("</BODY></HTML>");
        logger.exiting(CLASS_NAME, "doFilter");
    }

    public void destroy() {
    }
}

