/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.filter;

import com.ibm.ws.portletcontainer.portletserving.filter.PortletDocumentFilterContainer;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PortletDocumentFilterChain
implements FilterChain {
    private static final String CLASS_NAME = PortletDocumentFilterChain.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private PortletDocumentFilterContainer container;
    private Iterator iter;
    private FilterChain orginalChain;

    PortletDocumentFilterChain(PortletDocumentFilterContainer portletDocumentFilterContainer, Iterator iterator, FilterChain filterChain) {
        this.container = portletDocumentFilterContainer;
        this.iter = iterator;
        this.orginalChain = filterChain;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doFilter", new Object[]{servletRequest, servletResponse});
        }
        if (this.iter.hasNext()) {
            Filter filter = (Filter)this.iter.next();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Calling doFilter of servlet filter: " + filter);
            }
            filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doFilter", "Last collaborator called. Proceeding with normal execution.");
            }
            this.container.doFilterEnd(servletRequest, servletResponse, this.orginalChain);
        }
        logger.exiting(CLASS_NAME, "doFilter");
    }
}

