/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.filter;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.ext.ExtensionScope;
import com.ibm.ws.portletcontainer.portletserving.filter.PortletDocumentFilterConfig;
import com.ibm.ws.portletcontainer.util.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PortletFilterRegistry {
    private static final String CLASS_NAME = PortletFilterRegistry.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    public static final String FILTER_PREFIX = "PortletFilter_";
    private static final String DEFAULT_NAMESPACE = "default";
    public static final String FILTERXML = "portlet-document-filter-config.xml";
    public static final String DEFAULT_MAPPING_FILTERXML = "META-INF/portlet-document-filter-config.xml";
    private static final String FILTER_XSD_NAME = "/PortletDocumentFilterConfig.xsd";
    private static final String[] FILTER_XSD_PATHS = new String[]{"/com/ibm/ws/portletcontainer/deployment/XMLSchema.dtd", "/com/ibm/ws/portletcontainer/portletserving/filter/PortletDocumentFilterConfig.xsd"};
    private static final String[] FILTER_XSD_NAMES = new String[]{"XMLSchema.dtd", "PortletDocumentFilterConfig.xsd"};
    private Map filterByOrderMap = new TreeMap();
    private ArrayList filterListCopy;
    private boolean isFilterListCopyCurrent;
    private static PortletFilterRegistry instance = new PortletFilterRegistry();

    public static PortletFilterRegistry getInstance() {
        return instance;
    }

    private PortletFilterRegistry() {
        this.registerAllPortletDocumentFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPortletDocumentFilters() {
        if (!this.isFilterListCopyCurrent) {
            this.isFilterListCopyCurrent = true;
            this.filterListCopy = new ArrayList();
            Iterator iterator = this.filterByOrderMap.keySet().iterator();
            while (iterator.hasNext()) {
                List list;
                Integer n = (Integer)iterator.next();
                List list2 = list = (List)this.filterByOrderMap.get(n);
                synchronized (list2) {
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        Object[] objectArray = (Object[])iterator2.next();
                        this.filterListCopy.add(objectArray[0]);
                    }
                }
            }
        }
        return this.filterListCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortletFilter(Filter filter, String string, String string2, ClassLoader classLoader, Integer n) throws IllegalArgumentException {
        List list;
        try {
            filter.init((FilterConfig)new PortletDocumentFilterConfig(filter.getClass().getName()));
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.addPortletFilter", (String)"115", (Object)this);
            logger.logp(Level.WARNING, CLASS_NAME, "addPortletFilter", "portletserving.filter.init.error.0", servletException);
        }
        Integer n2 = PortletFilterRegistry.getPortletFilterOrder(string);
        List list2 = list = this.getFilterListOfOrder(this.filterByOrderMap, n2);
        synchronized (list2) {
            list.add(new Object[]{filter, string2, classLoader, n});
        }
        this.isFilterListCopyCurrent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePortletFilter(String string, String string2, String string3) throws IllegalArgumentException {
        List list;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "removePortletFilter", new Object[]{string, string2, string3});
        }
        Integer n = PortletFilterRegistry.getPortletFilterOrder(string2);
        List list2 = list = this.getFilterListOfOrder(this.filterByOrderMap, n);
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                String string4 = objectArray[0].getClass().getName();
                String string5 = (String)objectArray[1];
                if (!string4.equals(string) || !string5.equals(string3)) continue;
                iterator.remove();
                this.isFilterListCopyCurrent = false;
                logger.exiting(CLASS_NAME, "removePortletFilter", Boolean.TRUE);
                return true;
            }
            logger.exiting(CLASS_NAME, "removePortletFilter", Boolean.FALSE);
            return false;
        }
    }

    public void registerAllPortletDocumentFilters() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "registerAllPortletDocumentFilters");
        }
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(DEFAULT_MAPPING_FILTERXML);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                Document document = null;
                try {
                    InputStream inputStream = uRL.openStream();
                    document = XmlParser.getInstance().parseXml(inputStream, FILTER_XSD_NAME, FILTER_XSD_PATHS, FILTER_XSD_NAMES);
                    if (document == null) continue;
                    this.analyzeFilterDocument(document);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.registerAllPortletDocumentFilters", (String)"103", (Object)this);
                    logger.logp(Level.WARNING, CLASS_NAME, "registerAllPortletDocumentFilters", "portletserving.filter.io.error.0", iOException);
                }
                catch (SAXException sAXException) {
                    FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.registerAllPortletDocumentFilters", (String)"108", (Object)this);
                    logger.logp(Level.WARNING, CLASS_NAME, "registerAllPortletDocumentFilters", "portletserving.filter.validate.sax.error.0", sAXException);
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.registerAllPortletDocumentFilters", (String)"129", (Object)this);
            logger.logp(Level.WARNING, CLASS_NAME, "registerAllPortletDocumentFilters", "portletserving.filter.io.error.0", iOException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "registerAllPortletDocumentFilters");
        }
    }

    private void analyzeFilterDocument(Document document) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "analyzeFilterDocument", new Object[]{document});
        }
        boolean bl = logger.isLoggable(Level.FINEST);
        NodeList nodeList = document.getElementsByTagName("portlet-document-filter");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = "";
            Node node2 = namedNodeMap.getNamedItem("class-name");
            if (node2 != null) {
                string = node2.getNodeValue();
            }
            Node node3 = namedNodeMap.getNamedItem("order");
            String string2 = null;
            if (node3 != null) {
                string2 = node3.getNodeValue();
            }
            if (string2 == null || string == "") {
                logger.logp(Level.WARNING, CLASS_NAME, "analyzeFilterDocument", "portletserving.filter.validate.error.2", new Object[]{string, string2});
                continue;
            }
            try {
                Filter filter = (Filter)this.getClass().getClassLoader().loadClass(string).newInstance();
                this.addPortletFilter(filter, string2, DEFAULT_NAMESPACE, null, ExtensionScope.GLOBAL);
                if (!bl) continue;
                logger.logp(Level.FINEST, CLASS_NAME, "analyzeFilterDocument", "Registering filter", new Object[]{string2, string});
                continue;
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.analyzeFilterDocument", (String)"248", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", instantiationException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.analyzeFilterDocument", (String)"252", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", illegalAccessException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.analyzeFilterDocument", (String)"256", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", classNotFoundException);
                continue;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.analyzeFilterDocument", (String)"260", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", classCastException);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "analyzeFilterDocument");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFilterListOfOrder(Map map, Integer n) {
        ArrayList arrayList = (ArrayList)map.get(n);
        if (arrayList == null) {
            Map map2 = map;
            synchronized (map2) {
                arrayList = (List)map.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    map.put(n, arrayList);
                }
            }
        }
        return arrayList;
    }

    private static Integer getPortletFilterOrder(String string) throws IllegalArgumentException {
        Integer n = null;
        if (string != null) {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.portletcontainer.portletserving.filter.PortletFilterRegistry.getPortletFilterOrder", (String)"299");
                logger.logp(Level.WARNING, CLASS_NAME, "getPortletFilterOrder", "portletserving.filter.init.error.0", numberFormatException);
            }
        }
        if (n == null) {
            throw new IllegalArgumentException("Portlet Document Filter order could not be identified");
        }
        return n;
    }
}

