/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.services.information;

import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.information.ContentTypeProvider;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContentTypeProviderImpl
implements ContentTypeProvider {
    private static final String CLASS_NAME = ContentTypeProviderImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PortletWindowIdentifier portletWindow;

    public ContentTypeProviderImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletWindowIdentifier portletWindowIdentifier) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "ContentTypeProviderImpl", new Object[]{httpServletRequest, httpServletResponse, portletWindowIdentifier});
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.portletWindow = portletWindowIdentifier;
        logger.exiting(CLASS_NAME, "ContentTypeProviderImpl");
    }

    public String getResponseContentType() {
        logger.entering(CLASS_NAME, "getResponseContentType");
        String string = this.response.getContentType();
        if (string == null) {
            throw new IllegalStateException("Response content type has not been set.");
        }
        string = this.stripCharacterEncoding(string);
        logger.exiting(CLASS_NAME, "getResponseContentType", string);
        return string;
    }

    public List getResponseContentTypes() {
        logger.entering(CLASS_NAME, "getResponseContentTypes");
        String string = this.getResponseContentType();
        List<String> list = Arrays.asList(string);
        logger.exiting(CLASS_NAME, "getResponseContentTypes", list);
        return list;
    }

    public String getRequestContentType() {
        logger.entering(CLASS_NAME, "getRequestContentType");
        String string = this.request.getContentType();
        if (string == null) {
            string = "text/html";
        }
        if (this.request.getCharacterEncoding() != null) {
            string = string + ";" + this.request.getCharacterEncoding();
        }
        logger.exiting(CLASS_NAME, "getRequestContentType", string);
        return string;
    }

    public void setResponseContentType(String string) {
        logger.entering(CLASS_NAME, "setResponseContentType", string);
        this.response.setContentType(string);
        logger.exiting(CLASS_NAME, "setResponseContentType");
    }

    private String stripCharacterEncoding(String string) {
        int n = string.indexOf(59);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        return string2.trim();
    }
}

