/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.services.information;

import com.ibm.ws.portletcontainer.portletserving.core.PortalEnvironment;
import com.ibm.ws.portletcontainer.portletserving.core.PortletURL;
import com.ibm.ws.portletcontainer.portletserving.services.information.ContentTypeProviderImpl;
import com.ibm.ws.portletcontainer.portletserving.services.information.PortalContextProviderImpl;
import com.ibm.ws.portletcontainer.portletserving.services.information.PortletActionProviderImpl;
import com.ibm.ws.portletcontainer.portletserving.services.information.PortletURLProviderImpl;
import com.ibm.ws.portletcontainer.portletserving.services.information.RequestParameterProviderImpl;
import com.ibm.ws.portletcontainer.portletserving.services.information.ResourceURLProviderImpl;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.information.ContentTypeProvider;
import com.ibm.wsspi.portletcontainer.services.information.InformationProvider;
import com.ibm.wsspi.portletcontainer.services.information.PortalContextProvider;
import com.ibm.wsspi.portletcontainer.services.information.PortletActionProvider;
import com.ibm.wsspi.portletcontainer.services.information.PortletURLProvider;
import com.ibm.wsspi.portletcontainer.services.information.RequestParameterProvider;
import com.ibm.wsspi.portletcontainer.services.information.ResourceURLProvider;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InformationProviderImpl
implements InformationProvider {
    private static final String CLASS_NAME = InformationProviderImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private ServletConfig config;
    private PortalEnvironment env;
    private PortletURL currentURL;
    private PortalContextProvider portalContext;
    private Map actionProviderMap;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public InformationProviderImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletConfig servletConfig) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "InformationProviderImpl", new Object[]{httpServletRequest, httpServletResponse, servletConfig});
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.config = servletConfig;
        this.env = PortalEnvironment.getPortalEnvironment(httpServletRequest);
        this.currentURL = this.env.getRequestedPortalURL();
        this.portalContext = new PortalContextProviderImpl();
        this.actionProviderMap = new HashMap();
        logger.exiting(CLASS_NAME, "InformationProviderImpl");
    }

    public PortletMode getPortletMode(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getPortletMode", portletWindowIdentifier);
        PortletMode portletMode = this.env.getPortalControlParameter().getPortletMode();
        logger.exiting(CLASS_NAME, "getPortletMode", portletMode);
        return portletMode;
    }

    public RequestParameterProvider getRequestParameterProvider(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getRequestParameterProvider", portletWindowIdentifier);
        RequestParameterProviderImpl requestParameterProviderImpl = new RequestParameterProviderImpl(this.request, portletWindowIdentifier);
        logger.exiting(CLASS_NAME, "getRequestParameterProvider", requestParameterProviderImpl);
        return requestParameterProviderImpl;
    }

    public ContentTypeProvider getContentTypeProvider(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getContentTypeProvider", portletWindowIdentifier);
        ContentTypeProviderImpl contentTypeProviderImpl = new ContentTypeProviderImpl(this.request, this.response, portletWindowIdentifier);
        logger.exiting(CLASS_NAME, "getContentTypeProvider", contentTypeProviderImpl);
        return contentTypeProviderImpl;
    }

    public PortletURLProvider getPortletURLProvider(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getPortletURLProvider", portletWindowIdentifier);
        PortletURLProviderImpl portletURLProviderImpl = new PortletURLProviderImpl(this.request, this.response, portletWindowIdentifier);
        logger.exiting(CLASS_NAME, "getPortletURLProvider", portletURLProviderImpl);
        return portletURLProviderImpl;
    }

    public ResourceURLProvider getResourceURLProvider(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getResourceURLProvider", portletWindowIdentifier);
        ResourceURLProviderImpl resourceURLProviderImpl = new ResourceURLProviderImpl(this.request, this.response, portletWindowIdentifier);
        logger.exiting(CLASS_NAME, "getResourceURLProvider", resourceURLProviderImpl);
        return resourceURLProviderImpl;
    }

    public PortletActionProvider getPortletActionProvider(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getPortletActionProvider", portletWindowIdentifier);
        PortletActionProvider portletActionProvider = (PortletActionProvider)this.actionProviderMap.get(portletWindowIdentifier);
        if (portletActionProvider == null) {
            portletActionProvider = new PortletActionProviderImpl(this.request, this.config, portletWindowIdentifier);
            this.actionProviderMap.put(portletWindowIdentifier, portletActionProvider);
        }
        logger.exiting(CLASS_NAME, "getPortletActionProvider", portletActionProvider);
        return portletActionProvider;
    }

    public PortalContextProvider getPortalContextProvider() {
        logger.entering(CLASS_NAME, "getPortalContextProvider");
        logger.exiting(CLASS_NAME, "getPortalContextProvider", this.portalContext);
        return this.portalContext;
    }

    public WindowState getWindowState(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getWindowState", portletWindowIdentifier);
        WindowState windowState = this.env.getPortalControlParameter().getWindowState();
        logger.exiting(CLASS_NAME, "getWindowState", windowState);
        return windowState;
    }

    public Collection getAllowedPortletModes(PortletWindowIdentifier portletWindowIdentifier) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getAllowedPortletModes", new Object[]{portletWindowIdentifier});
        }
        logger.exiting(CLASS_NAME, "getAllowedPortletModes");
        return null;
    }

    public Collection getAllowedWindowStates(PortletWindowIdentifier portletWindowIdentifier) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getAllowedWindowStates", new Object[]{portletWindowIdentifier});
        }
        logger.exiting(CLASS_NAME, "getAllowedWindowStates");
        return null;
    }

    public Locale getLocale() {
        logger.entering(CLASS_NAME, "getLocale");
        Locale locale = this.request.getLocale();
        logger.exiting(CLASS_NAME, "getLocale", locale);
        return locale;
    }

    public Enumeration getLocales() {
        logger.entering(CLASS_NAME, "getLocales");
        Enumeration enumeration = this.request.getLocales();
        logger.exiting(CLASS_NAME, "getLocales", enumeration);
        return enumeration;
    }
}

