/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.services.information;

import com.ibm.ws.portletcontainer.portletserving.core.PortalEnvironment;
import com.ibm.ws.portletcontainer.portletserving.core.PortletControlParameter;
import com.ibm.ws.portletcontainer.portletserving.core.PortletURL;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.information.PortletURLProvider;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletURLProviderImpl
implements PortletURLProvider {
    private static final String CLASS_NAME = PortletURLProviderImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PortletWindowIdentifier portletWindow;
    private PortletMode mode;
    private WindowState state;
    private boolean action;
    private boolean redirect;
    private Map parameters;

    public PortletURLProviderImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletWindowIdentifier portletWindowIdentifier) {
        this(httpServletRequest, httpServletResponse, portletWindowIdentifier, false);
    }

    public PortletURLProviderImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletWindowIdentifier portletWindowIdentifier, boolean bl) {
        boolean bl2 = logger.isLoggable(Level.FINER);
        if (bl2) {
            logger.entering(CLASS_NAME, "PortletURLProviderImpl", new Object[]{httpServletRequest, httpServletResponse, portletWindowIdentifier, bl});
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.portletWindow = portletWindowIdentifier;
        this.redirect = bl;
        logger.exiting(CLASS_NAME, "PortletURLProviderImpl");
    }

    public boolean isSecuritySupported() {
        logger.entering(CLASS_NAME, "isSecuritySupported");
        logger.exiting(CLASS_NAME, "isSecuritySupported", Boolean.FALSE);
        return false;
    }

    public void setPortletMode(PortletMode portletMode) {
        logger.entering(CLASS_NAME, "setPortletMode", portletMode);
        this.mode = portletMode;
        logger.exiting(CLASS_NAME, "setPortletMode");
    }

    public void setWindowState(WindowState windowState) {
        logger.entering(CLASS_NAME, "setWindowState", windowState);
        this.state = windowState;
        logger.exiting(CLASS_NAME, "setWindowState");
    }

    public void setAction() {
        logger.entering(CLASS_NAME, "setAction");
        this.action = true;
        logger.exiting(CLASS_NAME, "setAction");
    }

    public void setSecure() {
        logger.entering(CLASS_NAME, "setSecure");
        logger.exiting(CLASS_NAME, "setSecure");
    }

    public void setParameters(Map map) {
        logger.entering(CLASS_NAME, "setParameters", map);
        this.parameters = map;
        logger.exiting(CLASS_NAME, "setParameters");
    }

    public String toString() {
        logger.entering(CLASS_NAME, "toString");
        PortletURL portletURL = PortalEnvironment.getPortalEnvironment(this.request).getRequestedPortalURL();
        PortletControlParameter portletControlParameter = new PortletControlParameter(portletURL);
        portletControlParameter.clearRenderParameters();
        if (this.mode != null) {
            portletControlParameter.setPortletMode(this.mode);
        }
        if (this.state != null) {
            portletControlParameter.setWindowState(this.state);
        }
        if (this.action) {
            portletControlParameter.setAction();
        }
        if (this.parameters != null) {
            if (this.action) {
                portletControlParameter.setRequestParams(this.parameters);
            } else {
                portletControlParameter.setRenderParams(this.parameters);
            }
        }
        String string = portletURL.toString(portletControlParameter);
        string = this.redirect ? this.response.encodeRedirectURL(string) : this.response.encodeURL(string);
        logger.exiting(CLASS_NAME, "toString", string);
        return string;
    }
}

