/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.services.information;

import com.ibm.ws.portletcontainer.portletserving.core.PortalEnvironment;
import com.ibm.ws.portletcontainer.portletserving.core.PortletControlParameter;
import com.ibm.ws.portletcontainer.portletserving.core.PortletURL;
import com.ibm.wsspi.portletcontainer.IdentifierNamespace;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.information.RequestParameterProvider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class RequestParameterProviderImpl
implements RequestParameterProvider {
    private static final String CLASS_NAME = RequestParameterProviderImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static final Enumeration emptyEnumeration = Collections.enumeration(Collections.EMPTY_LIST);
    private PortletControlParameter control;
    private PortletURL portletURL;
    private HttpServletRequest request;
    private PortletWindowIdentifier portletWindow;
    private Map parameters;

    public RequestParameterProviderImpl(HttpServletRequest httpServletRequest, PortletWindowIdentifier portletWindowIdentifier) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "RequestParameterProviderImpl", new Object[]{httpServletRequest, portletWindowIdentifier});
        }
        this.request = httpServletRequest;
        this.portletWindow = portletWindowIdentifier;
        this.portletURL = PortalEnvironment.getPortalEnvironment(httpServletRequest).getRequestedPortalURL();
        this.control = new PortletControlParameter(this.portletURL);
        this.parameters = this._getMap();
        logger.exiting(CLASS_NAME, "RequestParameterProviderImpl");
    }

    public Map getMap() {
        logger.entering(CLASS_NAME, "getMap");
        if (this.parameters != null) {
            logger.exiting(CLASS_NAME, "getMap", this.parameters);
            return this.parameters;
        }
        logger.exiting(CLASS_NAME, "getMap", Collections.EMPTY_MAP);
        return Collections.EMPTY_MAP;
    }

    private Map _getMap() {
        String string;
        Object object;
        logger.entering(CLASS_NAME, "_getMap");
        boolean bl = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "_getMap", "Collecting Render-Parameters...");
        }
        Map map = this.control.getClonedRenderParameters();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "_getMap", "Collecting Request-Parameters...");
        }
        String string2 = this.portletURL.getConcatPortletWindowId();
        String string3 = this.portletWindow.getId(IdentifierNamespace.URL).toString();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "_getMap", "PortletWindowId #1: " + string2 + " - PortletWindowId #2" + string3);
        }
        boolean bl2 = false;
        if (string2.equals(string3)) {
            object = (String)this.request.getAttribute("com.ibm.wsspi.portlet.url.target.wid");
            string = this.portletURL.getPortletUrlHelper().getPortletWindowId();
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "_getMap", "TargetWindowId: " + (String)object + " - PortletWindowId #3: " + string);
            }
            if (object == null) {
                bl2 = true;
            } else if (((String)object).equals(string)) {
                bl2 = true;
            }
        }
        if (bl2) {
            object = this.request.getParameterNames();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                String[] stringArray = this.request.getParameterValues(string);
                String[] stringArray2 = (String[])map.get(string);
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "_getMap", "Name: " + string + " - Values: " + stringArray);
                }
                if (stringArray2 != null) {
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "_getMap", "Found render parameter with the same name. Merging values...");
                    }
                    String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                    System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                    System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
                    stringArray = stringArray3;
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "_getMap", "Merged values: " + stringArray);
                    }
                }
                map.put(string, stringArray);
            }
        }
        object = Collections.unmodifiableMap(map);
        logger.exiting(CLASS_NAME, "_getMap", object);
        return object;
    }
}

