/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.services.persistence;

import com.ibm.ws.portletcontainer.portletserving.core.PortletURL;
import com.ibm.ws.portletcontainer.portletserving.services.persistence.InternalPersistenceProvider;
import com.ibm.ws.portletcontainer.portletserving.util.CookieDecoder;
import com.ibm.ws.portletcontainer.portletserving.util.CookieEncoder;
import com.ibm.ws.portletcontainer.portletserving.util.URLUTF8Encoder;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.persistence.Preference;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceAccessMode;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSet;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSetAdapter;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSetCtrl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PersistenceProviderCookieImpl
implements InternalPersistenceProvider {
    private static final String CLASS_NAME = PersistenceProviderCookieImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static final String NULL_VALUE = "#*!0_NULL_0!*#";
    private static final String COOKIE_NAME = "PortletPreferenceCookie";
    private static final String[] EMPTY_ARRAY = new String[0];
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map storedCookies;

    public PersistenceProviderCookieImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "PersistenceProviderCookieImpl", new Object[]{httpServletRequest, httpServletResponse});
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.storedCookies = new HashMap();
        logger.exiting(CLASS_NAME, "PersistenceProviderCookieImpl");
    }

    public synchronized PreferenceSet load(PortletWindowIdentifier portletWindowIdentifier) throws IOException {
        logger.entering(CLASS_NAME, "load", portletWindowIdentifier);
        boolean bl = logger.isLoggable(Level.FINEST);
        Cookie cookie = this.getCookie(portletWindowIdentifier);
        Map map = this.analyzeCookie(cookie.getValue());
        PreferenceSetAdapter preferenceSetAdapter = new PreferenceSetAdapter();
        Iterator iterator = this.getPreferencesNamesDecoded(map);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = this.getPreferencesValuesDecoded(map, string);
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "load", "Name: " + string + " - Values: " + list);
            }
            preferenceSetAdapter.add(string, list, false);
        }
        logger.exiting(CLASS_NAME, "load", preferenceSetAdapter);
        return preferenceSetAdapter;
    }

    public synchronized void store(PortletWindowIdentifier portletWindowIdentifier, PreferenceSetCtrl preferenceSetCtrl) throws IOException {
        Iterator iterator;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "store", new Object[]{portletWindowIdentifier, preferenceSetCtrl});
        }
        boolean bl2 = logger.isLoggable(Level.FINEST);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        PreferenceSet preferenceSet = (PreferenceSet)((Object)preferenceSetCtrl);
        if (preferenceSet != null) {
            iterator = preferenceSet.iterator();
            while (iterator.hasNext()) {
                Preference preference = (Preference)iterator.next();
                String string = preference.getName();
                List list = preference.getValues();
                hashMap.put(this.encodePreferenceName(string), this.encodePreferenceValues(list));
            }
        }
        iterator = this.getCookie(portletWindowIdentifier);
        iterator.setValue(this.getPreferencesAsString(hashMap));
        iterator.setPath(this.getPortletWindowIdentifierPath(portletWindowIdentifier));
        this.storedCookies.put(iterator.getName(), iterator);
        logger.exiting(CLASS_NAME, "store");
    }

    public PreferenceAccessMode getPreferenceAccessMode(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getPreferenceAccessMode", portletWindowIdentifier);
        logger.exiting(CLASS_NAME, "getPreferenceAccessMode", "READ_ONLY_DEFAULT");
        return PreferenceAccessMode.WRITEABLE_DEFAULT;
    }

    public void addCookiesToResponse() {
        logger.entering(CLASS_NAME, "addCookiesToResponse");
        boolean bl = logger.isLoggable(Level.FINEST);
        Iterator iterator = this.storedCookies.values().iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "store", "Adding Cookie " + cookie);
            }
            this.response.addCookie(cookie);
        }
        logger.exiting(CLASS_NAME, "addCookiesToResponse");
    }

    private Cookie getCookie(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getCookie", portletWindowIdentifier);
        boolean bl = logger.isLoggable(Level.FINEST);
        String string = this.getPortletWindowIdentifierPath(portletWindowIdentifier);
        Cookie cookie = null;
        Cookie[] cookieArray = this.request.getCookies();
        if (cookieArray != null) {
            int n;
            for (n = 0; n < cookieArray.length; ++n) {
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getCookie", "Checking Cookie - Name: " + cookieArray[n].getName() + " - Path: " + cookieArray[n].getPath());
                }
                if (!COOKIE_NAME.equals(cookieArray[n].getName()) || !string.equals(cookieArray[n].getPath())) continue;
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getCookie", "Cookie found.");
                }
                cookie = cookieArray[n];
                break;
            }
            if (cookie == null) {
                for (n = 0; n < cookieArray.length; ++n) {
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "getCookie", "Checking Cookie - Name: " + cookieArray[n].getName() + " - Path: " + cookieArray[n].getPath());
                    }
                    if (!COOKIE_NAME.equals(cookieArray[n].getName()) || cookieArray[n].getPath() != null) continue;
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "getCookie", "Cookie found.");
                    }
                    cookie = cookieArray[n];
                    break;
                }
            }
        }
        if (cookie == null) {
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "getCookie", "No Cookie found. Creating new with name: PortletPreferenceCookie and path: " + string);
            }
            cookie = new Cookie(COOKIE_NAME, "");
        }
        cookie.setPath(string);
        logger.exiting(CLASS_NAME, "getCookie", cookie);
        return cookie;
    }

    private String getPortletWindowIdentifierPath(PortletWindowIdentifier portletWindowIdentifier) {
        logger.entering(CLASS_NAME, "getPortletWindowIdentifierPath", portletWindowIdentifier);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('/');
        stringBuffer.append(URLUTF8Encoder.encode(portletWindowIdentifier.getContextRoot().substring(1)));
        stringBuffer.append('/');
        stringBuffer.append(URLUTF8Encoder.encode(portletWindowIdentifier.getPortletName()));
        stringBuffer.append('/');
        stringBuffer.append(URLUTF8Encoder.encode(PortletURL.stripPortletWindowId(portletWindowIdentifier)));
        string = stringBuffer.toString();
        logger.exiting(CLASS_NAME, "getPortletWindowIdentifierPath", string);
        return string;
    }

    private Map analyzeCookie(String string) {
        logger.entering(CLASS_NAME, "analyzeCookie", string);
        boolean bl = logger.isLoggable(Level.FINEST);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "analyzeCookie", "Token: " + string2);
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            String string3 = stringTokenizer2.nextToken();
            String[] stringArray = null;
            if (stringTokenizer2.hasMoreTokens()) {
                stringArray = new String[stringTokenizer2.countTokens()];
                int n = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer2.nextToken();
                }
            }
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "analyzeCookie", "Name: " + string3 + " - Values: " + stringArray);
            }
            hashMap.put(string3, stringArray);
        }
        logger.exiting(CLASS_NAME, "analyzeCookie", hashMap);
        return hashMap;
    }

    private String encodePreferenceName(String string) {
        logger.entering(CLASS_NAME, "encodePreferenceName", string);
        String string2 = PersistenceProviderCookieImpl.encode(string);
        logger.exiting(CLASS_NAME, "encodePreferenceName", string2);
        return string2;
    }

    private String decodePreferenceName(String string) {
        logger.entering(CLASS_NAME, "decodePreferenceName", string);
        String string2 = PersistenceProviderCookieImpl.decode(string);
        logger.exiting(CLASS_NAME, "decodePreferenceName", string2);
        return string2;
    }

    private String encodePreferenceValue(String string) {
        logger.entering(CLASS_NAME, "encodePreferenceValue", string);
        String string2 = string == null ? NULL_VALUE : PersistenceProviderCookieImpl.encode(string);
        logger.exiting(CLASS_NAME, "encodePreferenceValue", string2);
        return string2;
    }

    private String decodePreferenceValue(String string) {
        logger.entering(CLASS_NAME, "decodePreferenceValue", string);
        String string2 = NULL_VALUE.equals(string) ? null : PersistenceProviderCookieImpl.decode(string);
        logger.exiting(CLASS_NAME, "decodePreferenceValue", string2);
        return string2;
    }

    private String[] encodePreferenceValues(List list) throws UnsupportedEncodingException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "encodePreferenceValues", new Object[]{list});
        }
        String[] stringArray = EMPTY_ARRAY;
        if (list != null) {
            stringArray = new String[list.size()];
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringArray[n] = this.encodePreferenceValue((String)iterator.next());
                ++n;
            }
        }
        logger.exiting(CLASS_NAME, "encodePreferenceValues", stringArray);
        return stringArray;
    }

    private Iterator getPreferencesNamesDecoded(Map map) {
        logger.entering(CLASS_NAME, "getPreferencesNamesDecoded");
        boolean bl = logger.isLoggable(Level.FINEST);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = this.decodePreferenceName((String)iterator.next());
            arrayList.add(string);
            if (!bl) continue;
            logger.logp(Level.FINEST, CLASS_NAME, "getPreferencesNamesDecoded", "Found a match. Adding '" + string + "'");
        }
        logger.exiting(CLASS_NAME, "getPreferencesNamesDecoded");
        return arrayList.iterator();
    }

    private List getPreferencesValuesDecoded(Map map, String string) throws UnsupportedEncodingException {
        logger.entering(CLASS_NAME, "getPreferencesValuesDecoded", string);
        String[] stringArray = (String[])map.get(this.encodePreferenceName(string));
        ArrayList<String> arrayList = null;
        if (stringArray != null && stringArray.length != 0) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(this.decodePreferenceValue(stringArray[i]));
            }
        }
        logger.exiting(CLASS_NAME, "getPreferencesValuesDecoded", stringArray);
        return arrayList;
    }

    private String getPreferencesAsString(Map map) {
        String string;
        logger.entering(CLASS_NAME, "getPreferencesAsString", map);
        StringBuffer stringBuffer = new StringBuffer(map.size() * 10);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("/");
            string = (String)iterator.next();
            stringBuffer.append(string);
            String[] stringArray = (String[])map.get(string);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("=");
                stringBuffer.append(stringArray[i]);
            }
        }
        string = stringBuffer.toString();
        logger.exiting(CLASS_NAME, "getPreferencesAsString", string);
        return string;
    }

    public static String encode(String string) {
        logger.entering(CLASS_NAME, "encode", string);
        string = CookieEncoder.encode(string);
        logger.exiting(CLASS_NAME, "encode", string);
        return string;
    }

    public static String decode(String string) {
        logger.entering(CLASS_NAME, "decode", string);
        string = CookieDecoder.decode(string);
        logger.exiting(CLASS_NAME, "decode", string);
        return string;
    }
}

