/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.portletserving.wrappers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class PortletServingServletResponseWrapper
extends HttpServletResponseWrapper
implements HttpServletResponse {
    private static final String CLASS_NAME = PortletServingServletResponseWrapper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    Map cookies = new HashMap();

    public PortletServingServletResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void addCookie(Cookie cookie) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "addCookie", cookie);
        }
        this.cookies.put(cookie.getName(), cookie);
        if (bl) {
            logger.exiting(CLASS_NAME, "addCookie");
        }
    }

    public void propagateCookies() {
        boolean bl = logger.isLoggable(Level.FINER);
        boolean bl2 = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.entering(CLASS_NAME, "propagateCookies");
        }
        if (!this.cookies.isEmpty()) {
            Iterator iterator = this.cookies.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Cookie cookie = (Cookie)entry.getValue();
                if (bl2) {
                    logger.logp(Level.FINEST, CLASS_NAME, "propagateCookies", "next cookie name:" + cookie.getName());
                }
                ((HttpServletResponse)this.getResponse()).addCookie(cookie);
            }
        } else if (bl2) {
            logger.logp(Level.FINEST, CLASS_NAME, "propagateCookies", "cookies is empty");
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "propagateCookies");
        }
    }
}

