/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.runtime;

import com.ibm.etools.portletapplication.init.PortletApplicationInit;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.portletcontainer.PortletContainer;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.ext.ExtensionHandler;
import com.ibm.ws.portletcontainer.ext.ExtensionScope;
import com.ibm.ws.portletcontainer.portletserving.PortletServingExtensionFactory;
import com.ibm.ws.portletcontainer.runtime.PortletMetaDataListener;
import com.ibm.ws.portletcontainer.service.factorymanager.FactoryManager;
import com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerAccess;
import com.ibm.ws.portletcontainer.util.CacheHelper;
import com.ibm.ws.portletcontainer.util.CustomPropertyHelper;
import com.ibm.ws.portletcontainer.webextension.PortletExtensionFactory;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class PortletContainerComponentImpl
extends WsComponentImpl {
    private static final String CLASS_NAME = PortletContainerComponentImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private static Class portletContainerType = PortletContainer.class;
    private static Class applicationServerType = ApplicationServer.class;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        logger.entering(CLASS_NAME, "initialize");
        super.initialize(object);
        PortletApplicationInit.init();
        try {
            FactoryManager factoryManager = FactoryManagerAccess.getInstance();
            factoryManager.init(new String[][]{{"factory.javax.portlet.ActionRequest", "com.ibm.ws.portletcontainer.factory.impl.ActionRequestFactoryImpl"}, {"factory.javax.portlet.ActionResponse", "com.ibm.ws.portletcontainer.factory.impl.ActionResponseFactoryImpl"}, {"factory.javax.portlet.PortalContext", "com.ibm.ws.portletcontainer.factory.impl.PortalContextFactoryImpl"}, {"factory.javax.portlet.PortletConfig", "com.ibm.ws.portletcontainer.factory.impl.PortletConfigFactoryImpl"}, {"factory.javax.portlet.PortletContext", "com.ibm.ws.portletcontainer.factory.impl.PortletContextFactoryImpl"}, {"factory.javax.portlet.PortletPreferences", "com.ibm.ws.portletcontainer.factory.impl.PortletPreferencesFactoryImpl"}, {"factory.javax.portlet.PortletSession", "com.ibm.ws.portletcontainer.factory.impl.PortletSessionFactoryImpl"}, {"factory.javax.portlet.PortletURL", "com.ibm.ws.portletcontainer.factory.impl.PortletURLFactoryImpl"}, {"factory.javax.portlet.RenderRequest", "com.ibm.ws.portletcontainer.factory.impl.RenderRequestFactoryImpl"}, {"factory.javax.portlet.RenderResponse", "com.ibm.ws.portletcontainer.factory.impl.RenderResponseFactoryImpl"}, {"factory.com.ibm.ws.portletcontainer.invoker.PortletInvoker", "com.ibm.ws.portletcontainer.invoker.impl.PortletInvokerFactoryImpl"}, {"factory.com.ibm.ws.portletcontainer.util.NamespaceMapper", "com.ibm.ws.portletcontainer.util.impl.NamespaceMapperFactoryImpl"}, {"factory.com.ibm.ws.portletcontainer.om.ControllerFactory", "com.ibm.ws.portletcontainer.om.ControllerFactoryImpl"}, {"factory.com.ibm.ws.portletcontainer.servlet.ServletResponseWrapper", "com.ibm.ws.portletcontainer.servlet.ServletResponseWrapperFactoryImpl"}, {"factory.com.ibm.ws.portletcontainer.om.OMFactory", "com.ibm.ws.portletcontainer.om.ext.OMFactoryImpl"}});
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.portletcontainer.runtime.PortletContainerComponentImpl.initialize", (String)"56", (Object)((Object)this));
            throw new ConfigurationError((Throwable)exception);
        }
        logger.exiting(CLASS_NAME, "initialize");
    }

    public void start() throws RuntimeError, RuntimeWarning {
        logger.entering(CLASS_NAME, "start");
        try {
            Object object;
            Object object2;
            Server server = (Server)WsServiceRegistry.getService((Object)((Object)this), (Class)Server.class);
            if (server == null) {
                throw new RuntimeError("Can not find Server service");
            }
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)new ExtensionHandler(ExtensionScope.GLOBAL), "com.ibm.ws.portletcontainer");
            ExtensionHandler.initExtensions(iExtensionRegistry, ExtensionScope.GLOBAL);
            server.addPropertyChangeListener("state", (PropertyChangeListener)new ExtensionPropertyChangeListener());
            PortletContainer portletContainer = this.getPortletContainer();
            if (portletContainer != null) {
                CacheHelper.setPortletContainerCachingEnabled(portletContainer.isEnablePortletCaching());
                object2 = portletContainer.getProperties().iterator();
                while (object2.hasNext()) {
                    object = (Property)object2.next();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "PortletContainer", "setPortletContainerSettings", "custom properties (key--> " + object.getName().toLowerCase() + ", value --> " + object.getValue());
                    }
                    CustomPropertyHelper.addPortletContainerProperty(object.getName().toLowerCase(), object.getValue());
                }
            }
            MetaDataService metaDataService = (MetaDataService)WsServiceRegistry.getService((Object)((Object)this), (Class)MetaDataService.class);
            metaDataService.addMetaDataListener((MetaDataListener)new PortletMetaDataListener());
            object2 = new PortletExtensionFactory();
            object = new PortletServingExtensionFactory();
            WebContainer.registerExtensionFactory((ExtensionFactory)object2);
            WebContainer.registerExtensionFactory((ExtensionFactory)object);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.portletcontainer.runtime.PortletContainerComponentImpl.start", (String)"99", (Object)((Object)this));
            throw new RuntimeError((Throwable)exception);
        }
        logger.exiting(CLASS_NAME, "start");
    }

    private static void registerAppExtensions() {
        try {
            InitialContext initialContext = new InitialContext();
            IExtensionRegistry iExtensionRegistry = (IExtensionRegistry)initialContext.lookup("services/extensionregistry/global");
            iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)new ExtensionHandler(ExtensionScope.APPLICATION), "com.ibm.ws.portletcontainer");
            ExtensionHandler.initExtensions(iExtensionRegistry, ExtensionScope.APPLICATION);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.portletcontainer.runtime.PortletContainerComponentImpl.registerAppExtensions", (String)"116");
            logger.logp(Level.SEVERE, CLASS_NAME, "registerAppExtensions", "app.collaborators.init.error.0", throwable);
        }
    }

    private PortletContainer getPortletContainer() {
        com.ibm.websphere.models.config.process.Server server = this.getServer();
        if (server == null) {
            return null;
        }
        ApplicationServer applicationServer = this.getApplicationServer(server);
        if (applicationServer == null) {
            return null;
        }
        EList eList = applicationServer.getComponents();
        if (eList != null && eList.size() > 0) {
            Object var4_4 = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                var4_4 = iterator.next();
                if (!portletContainerType.isInstance(var4_4)) continue;
                return var4_4;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPortletContainer", "PortletContainer not found in ApplicationServer: " + applicationServer);
        }
        return null;
    }

    private ApplicationServer getApplicationServer(com.ibm.websphere.models.config.process.Server server) {
        EList eList = server.getComponents();
        if (eList != null && eList.size() > 0) {
            Object var3_3 = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                var3_3 = iterator.next();
                if (!applicationServerType.isInstance(var3_3)) continue;
                return var3_3;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getApplicationServer", "ApplicationServer not found in server: " + server);
        }
        return null;
    }

    private com.ibm.websphere.models.config.process.Server getServer() {
        com.ibm.websphere.models.config.process.Server server;
        block2: {
            server = null;
            try {
                Repository repository = (Repository)WsServiceRegistry.getService((Object)((Object)this), (Class)Repository.class);
                Resource resource = repository.getConfigRoot().getResource(4, "server.xml");
                com.ibm.websphere.models.config.process.Server server2 = (com.ibm.websphere.models.config.process.Server)resource.getContents().get(0);
                EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
                server = (com.ibm.websphere.models.config.process.Server)etoolsCopyUtility.copy((EObject)server2);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.logp(Level.FINE, CLASS_NAME, "getServer", "Failed to load resource server.xml from process: " + exception.toString());
            }
        }
        return server;
    }

    static class ExtensionPropertyChangeListener
    implements PropertyChangeListener {
        ExtensionPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (string.equals("STARTED")) {
                PortletContainerComponentImpl.registerAppExtensions();
            }
        }
    }
}

