/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.runtime;

import com.ibm.etools.portletapplication.PortletApplication;
import com.ibm.etools.portletapplication.PortletApplicationResource;
import com.ibm.etools.portletapplicationext.PortletApplicationExtension;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.deploytask.PortletExtXMLParser;
import com.ibm.ws.portletcontainer.om.ControllerObjectAccess;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinition;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.translator.wccm.WCCMWebApplicationDefinitionTranslator;
import com.ibm.ws.portletcontainer.runtime.PortletWebAppInitializationCollaborator;
import com.ibm.ws.portletcontainer.runtime.WebAppInitializationCollaborator;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.wsspi.webcontainer.collaborator.WebAppCollaborator;
import com.ibm.wsspi.wswebcontainer.metadata.WebModuleMetaData;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;

class PortletMetaDataListener
implements MetaDataListener {
    private static final String CLASS_NAME = PortletMetaDataListener.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        logger.entering(CLASS_NAME, "metaDataCreated");
        MetaData metaData = metaDataEvent.getMetaData();
        if (metaData instanceof WebModuleMetaData && metaDataEvent.getDeployedObject().getModuleFile().isWARFile()) {
            logger.logp(Level.FINEST, CLASS_NAME, "metaDataCreated", "WAR file found");
            DeployedObject deployedObject = metaDataEvent.getDeployedObject();
            WARFile wARFile = (WARFile)deployedObject.getModuleFile();
            WebModuleMetaData webModuleMetaData = (WebModuleMetaData)metaData;
            if (wARFile.containsFile("WEB-INF/portlet.xml") && PortletExtXMLParser.isPortletDeploymentEnabled(wARFile)) {
                try {
                    Resource resource = wARFile.getMofResource("WEB-INF/portlet.xml");
                    XMIResource xMIResource = this.getPortletExtXMI(wARFile);
                    logger.logp(Level.FINEST, CLASS_NAME, "metaDataCreated", "Portlet application found");
                    PortletApplication portletApplication = null;
                    if (resource != null) {
                        portletApplication = ((PortletApplicationResource)resource).getPortletApplication();
                    }
                    PortletApplicationExtension portletApplicationExtension = null;
                    if (xMIResource != null) {
                        portletApplicationExtension = (PortletApplicationExtension)xMIResource.getContents().get(0);
                    }
                    if (portletApplication != null) {
                        WebApplicationDefinition webApplicationDefinition = WCCMWebApplicationDefinitionTranslator.translate(portletApplication, portletApplicationExtension, deployedObject.getClassLoader());
                        logger.logp(Level.FINEST, CLASS_NAME, "metaDataCreated", "WebApplicationDefinition = " + webApplicationDefinition);
                        WebApplicationDefinitionCtrl webApplicationDefinitionCtrl = (WebApplicationDefinitionCtrl)ControllerObjectAccess.get(webApplicationDefinition);
                        webApplicationDefinitionCtrl.setEarName(webModuleMetaData.getApplicationMetaData().getName());
                        webModuleMetaData.addWebAppCollaborator((WebAppCollaborator)new PortletWebAppInitializationCollaborator(webApplicationDefinition));
                    }
                    logger.logp(Level.FINEST, CLASS_NAME, "metaDataCreated", "Portlet application of unknown format");
                    webModuleMetaData.addWebAppCollaborator((WebAppCollaborator)new WebAppInitializationCollaborator());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    webModuleMetaData.addWebAppCollaborator((WebAppCollaborator)new WebAppInitializationCollaborator());
                }
                catch (ResourceLoadException resourceLoadException) {
                    webModuleMetaData.addWebAppCollaborator((WebAppCollaborator)new WebAppInitializationCollaborator());
                }
                catch (RuntimeException runtimeException) {
                    FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.portletcontainer.runtime.PortletMetaDataListener.metaDataCreated", (String)"68", (Object)this);
                    logger.logp(Level.WARNING, CLASS_NAME, "metaDataCreated", "portlet.wccm.load.error.0", runtimeException);
                    throw runtimeException;
                }
            } else {
                webModuleMetaData.addWebAppCollaborator((WebAppCollaborator)new WebAppInitializationCollaborator());
            }
        }
        logger.exiting(CLASS_NAME, "metaDataCreated");
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
        logger.entering(CLASS_NAME, "metaDataDestroyed");
        logger.exiting(CLASS_NAME, "metaDataDestroyed");
    }

    private XMIResource getPortletExtXMI(WARFile wARFile) throws RuntimeWarning, RuntimeError {
        XMIResource xMIResource = null;
        try {
            xMIResource = (XMIResource)wARFile.getMofResource("WEB-INF/ibm-portlet-ext.xmi");
            logger.logp(Level.FINER, CLASS_NAME, "getPortletExtXMI", "Portlet deployment descriptor extension file found (ibm-portlet-ext.xmi) for this application.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "getPortletExtXMI", "No portlet deployment descriptor extension file found for this application. Default configurations are used.", fileNotFoundException);
            } else {
                logger.logp(Level.FINER, CLASS_NAME, "getPortletExtXMI", "No portlet deployment descriptor extension file (ibm-portlet-ext.xmi) found for this application. Default configurations are used.");
            }
        }
        catch (ResourceLoadException resourceLoadException) {
            logger.logp(Level.WARNING, CLASS_NAME, "getPortletExtXMI", "portlet.ext.load.error.0", resourceLoadException);
        }
        catch (RuntimeException runtimeException) {
            logger.logp(Level.WARNING, CLASS_NAME, "getPortletExtXMI", "portlet.ext.load.error.0", runtimeException);
        }
        return xMIResource;
    }
}

