/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.runtime;

import com.ibm.ws.portletcontainer.management.portlet.PortletApplicationCollaborator;
import com.ibm.ws.portletcontainer.om.ControllerObjectAccess;
import com.ibm.ws.portletcontainer.om.ext.portlet.PortletApplicationDefinition;
import com.ibm.ws.portletcontainer.om.ext.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.ext.portlet.PortletDefinitionCtrl;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinition;
import com.ibm.ws.portletcontainer.om.servlet.WebApplicationDefinitionCtrl;
import com.ibm.ws.portletcontainer.pmi.server.modules.InternalPortletApplicationPerf;
import com.ibm.ws.portletcontainer.registry.webapplicationdefinitionregistry.WebApplicationDefinitionRegistry;
import com.ibm.ws.portletcontainer.runtime.WebAppInitializationCollaborator;
import com.ibm.ws.portletcontainer.util.CustomPropertyHelper;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.webcontainer.collaborator.WebAppCollaboratorConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.wswebcontainer.metadata.WebModuleMetaData;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class PortletWebAppInitializationCollaborator
extends WebAppInitializationCollaborator {
    private static final String CLASS_NAME = PortletWebAppInitializationCollaborator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private WebApplicationDefinition webApp;

    public PortletWebAppInitializationCollaborator(WebApplicationDefinition webApplicationDefinition) {
        this.webApp = webApplicationDefinition;
    }

    public void starting(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        logger.entering(CLASS_NAME, "starting");
        super.starting(webAppCollaboratorConfig);
        WebApplicationDefinitionCtrl webApplicationDefinitionCtrl = (WebApplicationDefinitionCtrl)((Object)this.webApp);
        boolean bl = logger.isLoggable(Level.FINEST);
        IServletContext iServletContext = webAppCollaboratorConfig.getIServletContext();
        webApplicationDefinitionCtrl.setName(iServletContext.getWebAppConfig().getModuleName());
        webApplicationDefinitionCtrl.setContextRoot(iServletContext.getContextPath());
        webApplicationDefinitionCtrl.setServletContext((ServletContext)iServletContext);
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "starting", "OM initialization done: " + iServletContext.getContextPath());
        }
        WebApplicationDefinitionRegistry.getInstance().addWebApplicationDefinition(this.webApp);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "started", "added web app definition to registry: " + this.webApp.getContextRoot());
        }
        if (StatsFactory.isPMIEnabled()) {
            PortletApplicationDefinition portletApplicationDefinition = (PortletApplicationDefinition)this.webApp.getPortletApplicationDefinition();
            portletApplicationDefinition.createPortletApplicationPerf(this.getPMIappName(webAppCollaboratorConfig));
            Iterator iterator = this.webApp.getPortletApplicationDefinition().getPortletDefinitionList().iterator();
            while (iterator.hasNext()) {
                PortletDefinition portletDefinition = (PortletDefinition)iterator.next();
                portletDefinition.getPortletPerf();
            }
        }
        if (CustomPropertyHelper.isEnabled("useshortmbeannames", true)) {
            this.startingPortletApplicationCollaborator(new PortletApplicationCollaborator(this.webApp.getName() + "_portletapplication", this.webApp));
        }
        this.startingPortletApplicationCollaborator(new PortletApplicationCollaborator(this.webApp));
        logger.exiting(CLASS_NAME, "starting");
    }

    private void startingPortletApplicationCollaborator(PortletApplicationCollaborator portletApplicationCollaborator) {
        logger.entering(CLASS_NAME, "startingPortletApplicationCollaborator", portletApplicationCollaborator.getMBeanName());
        boolean bl = logger.isLoggable(Level.FINEST);
        portletApplicationCollaborator.activateMBeans();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "starting", "MBean activated: " + portletApplicationCollaborator.getMBeanName());
        }
        portletApplicationCollaborator.registerAsMBeanListener();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "starting", "MBean registered as listener: " + portletApplicationCollaborator.getMBeanName());
        }
        portletApplicationCollaborator.sendStartingNotification();
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "starting", "MBean send starting notification done: " + portletApplicationCollaborator.getMBeanName());
        }
        logger.exiting(CLASS_NAME, "startingPortletApplicationCollaborator");
    }

    public void started(WebAppCollaboratorConfig webAppCollaboratorConfig) {
    }

    public void stopping(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        logger.entering(CLASS_NAME, "stopping");
        super.stopping(webAppCollaboratorConfig);
        WebApplicationDefinition webApplicationDefinition = WebApplicationDefinitionRegistry.getInstance().getWebApplicationDefinition(webAppCollaboratorConfig.getIServletContext().getContextPath());
        if (webApplicationDefinition != null) {
            InternalPortletApplicationPerf internalPortletApplicationPerf = ((PortletApplicationDefinition)webApplicationDefinition.getPortletApplicationDefinition()).getPortletApplicationPerf();
            if (internalPortletApplicationPerf != null) {
                Iterator iterator = webApplicationDefinition.getPortletApplicationDefinition().getPortletDefinitionList().iterator();
                while (iterator.hasNext()) {
                    PortletDefinition portletDefinition = (PortletDefinition)iterator.next();
                    PortletDefinitionCtrl portletDefinitionCtrl = (PortletDefinitionCtrl)ControllerObjectAccess.get(portletDefinition);
                    portletDefinitionCtrl.disposePortletPerf();
                }
                internalPortletApplicationPerf.dispose();
            }
            WebApplicationDefinitionRegistry.getInstance().removeWebApplicationDefinition(webApplicationDefinition);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "stopping", "removed web app definition from registry: " + webApplicationDefinition.getContextRoot());
            }
        }
        logger.exiting(CLASS_NAME, "stopping");
    }

    public void stopped(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        logger.entering(CLASS_NAME, "stopped");
        super.stopped(webAppCollaboratorConfig);
        logger.exiting(CLASS_NAME, "stopped");
    }

    private String getPMIappName(WebAppCollaboratorConfig webAppCollaboratorConfig) {
        logger.entering(CLASS_NAME, "getPMIappName");
        String string = ((WebModuleMetaData)webAppCollaboratorConfig.getModuleMetaData()).getJ2EEName().toString();
        logger.exiting(CLASS_NAME, "getPMIappName", string);
        return string;
    }
}

