/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.service.factorymanager;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.factory.Factory;
import com.ibm.ws.portletcontainer.service.factorymanager.FactoryManager;
import com.ibm.ws.portletcontainer.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactoryManagerImpl
implements FactoryManager {
    private static final String CONFIG_FACTORY_PRE = "factory.";
    private static final String CLASS_NAME = FactoryManagerImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private Map factoryMapDefinitions = new HashMap();
    private Map factoryMapObjects = new HashMap();
    private List factoryList = new LinkedList();
    private boolean initialized = false;

    public void init(String[][] stringArray) throws Exception {
        logger.entering(CLASS_NAME, "init");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            if (!string.startsWith(CONFIG_FACTORY_PRE)) continue;
            String string2 = string.substring(CONFIG_FACTORY_PRE.length());
            String string3 = stringArray[i][1];
            this.factoryMapDefinitions.put(string2, string3);
        }
        logger.exiting(CLASS_NAME, "init");
    }

    private synchronized void lazyInit() throws Exception {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        int n = 0;
        boolean bl = logger.isLoggable(Level.FINE);
        boolean bl2 = logger.isLoggable(Level.FINEST);
        Iterator iterator = this.factoryMapDefinitions.keySet().iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            String string = (String)iterator.next();
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "init", "interface: " + string);
            }
            ++n;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerServiceImpl.init", (String)"96", (Object)this);
                logger.logp(Level.WARNING, CLASS_NAME, "init", "factory.not.found.1", string);
                continue;
            }
            String string2 = (String)this.factoryMapDefinitions.get(string);
            if (bl2) {
                logger.logp(Level.FINEST, CLASS_NAME, "init", "class: " + string2);
            }
            Class<?> clazz2 = null;
            Factory factory = null;
            try {
                clazz2 = Class.forName(string2);
                factory = (Factory)clazz2.newInstance();
                if (bl) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", StringUtils.nameOf(clazz) + " initializing...");
                }
                factory.init(new HashMap());
                if (bl) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", StringUtils.nameOf(clazz) + " done.");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerServiceImpl.init", (String)"124", (Object)this);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "factory.impl.not.found.1", string2);
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "Factory implementation not found:", classNotFoundException);
                }
                throw classNotFoundException;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerServiceImpl.init", (String)"133", (Object)this);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "factory.impl.wrong.type.1", string2);
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "Factory implementation is not of required type:", classCastException);
                }
                throw classCastException;
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerServiceImpl.init", (String)"142", (Object)this);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "factory.impl.instantiation.failed.1", string2);
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "Factory implementation could not be instantiated:", instantiationException);
                }
                throw instantiationException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerServiceImpl.init", (String)"151", (Object)this);
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "factory.unknown.error.0", exception);
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "Factory could not be initialized:", exception);
                }
                throw exception;
            }
            if (factory == null) continue;
            this.factoryMapObjects.put(clazz, factory);
            this.factoryList.add(0, factory);
        }
        if (bl) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "Factories initialized (" + n + " successful)");
        }
    }

    protected void destroy() {
        logger.entering(CLASS_NAME, "destroy");
        Iterator iterator = this.factoryList.iterator();
        while (iterator.hasNext()) {
            Factory factory = (Factory)iterator.next();
            try {
                factory.destroy();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerServiceImpl.destroy", (String)"194", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "destroy", "factory.destroy.failed.0", exception);
            }
        }
        this.factoryList.clear();
        this.factoryMapObjects.clear();
        logger.exiting(CLASS_NAME, "destroy");
    }

    public Factory getFactory(Class clazz) {
        logger.entering(CLASS_NAME, "getFactory", clazz.getName());
        Factory factory = null;
        try {
            this.lazyInit();
            factory = (Factory)this.factoryMapObjects.get(clazz);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.portletcontainer.service.factorymanager.FactoryManagerImpl.getFactory", (String)"203", (Object)this);
        }
        logger.exiting(CLASS_NAME, "getFactory", factory);
        return factory;
    }
}

