/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.VariableInfo;

public abstract class BasicURLTag
extends TagSupport {
    private static final String CLASS_NAME = BasicURLTag.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    protected String portletMode;
    protected String secure;
    protected Boolean secureBoolean;
    protected String windowState;
    protected PortletURL url;
    protected String var;

    protected abstract PortletURL createURL(RenderResponse var1);

    public int doStartTag() throws JspException {
        RenderResponse renderResponse;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doStartTag", new Object[]{this.portletMode, this.windowState, this.secure, this.var});
        }
        if (this.var != null) {
            this.pageContext.removeAttribute(this.var, 1);
        }
        if ((renderResponse = (RenderResponse)this.pageContext.getRequest().getAttribute("javax.portlet.response")) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Creating url for render response " + renderResponse);
            }
            this.url = this.createURL(renderResponse);
            if (this.portletMode != null) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Adding portlet mode " + this.portletMode + " to url");
                    }
                    this.url.setPortletMode(TEI.getPortletMode(this.portletMode));
                }
                catch (PortletModeException portletModeException) {
                    FFDCFilter.processException((Throwable)portletModeException, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doStartTag", (String)"43", (Object)((Object)this));
                    throw new JspException((Throwable)portletModeException);
                }
            }
            if (this.windowState != null) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Adding window state " + this.windowState + " to url");
                    }
                    this.url.setWindowState(TEI.getWindowState(this.windowState));
                }
                catch (WindowStateException windowStateException) {
                    FFDCFilter.processException((Throwable)windowStateException, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doStartTag", (String)"55", (Object)((Object)this));
                    throw new JspException((Throwable)windowStateException);
                }
            }
            if (this.secure != null) {
                try {
                    boolean bl = this.getSecureBoolean();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Adding security " + bl + " to url");
                    }
                    this.url.setSecure(bl);
                }
                catch (PortletSecurityException portletSecurityException) {
                    FFDCFilter.processException((Throwable)portletSecurityException, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doStartTag", (String)"67", (Object)((Object)this));
                    throw new JspException((Throwable)portletSecurityException);
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "doStartTag", new Object[]{this.url});
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doEndTag", new Object[]{this.var, this.url, this.portletMode, this.windowState, this.secure, this.secureBoolean});
        }
        if (this.var == null) {
            try {
                JspWriter jspWriter = this.pageContext.getOut();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "doStartTag", "Using JspWriter " + jspWriter);
                }
                jspWriter.print((Object)this.url);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doEndTag", (String)"131", (Object)((Object)this));
                throw new JspException("actionURL/renderURL Tag Exception: cannot write to the output writer.", (Throwable)iOException);
            }
        } else {
            this.pageContext.setAttribute(this.var, (Object)((Object)this.url).toString(), 1);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "doEndTag");
        }
        return 6;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public String getSecure() {
        return this.secure;
    }

    public boolean getSecureBoolean() {
        return this.secureBoolean;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public PortletURL getUrl() {
        return this.url;
    }

    public String getVar() {
        return this.var;
    }

    public void setPortletMode(String string) {
        this.portletMode = string;
    }

    public void setSecure(String string) {
        this.secure = string;
        this.secureBoolean = Boolean.valueOf(string);
    }

    public void setWindowState(String string) {
        this.windowState = string;
    }

    public void setUrl(PortletURL portletURL) {
        this.url = portletURL;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public static class TEI
    extends TagExtraInfo {
        private static final String HELP_NAME = PortletMode.HELP.toString();
        private static final String EDIT_NAME = PortletMode.EDIT.toString();
        private static final String VIEW_NAME = PortletMode.VIEW.toString();
        private static final String NORMAL_NAME = WindowState.NORMAL.toString();
        private static final String MINIMIZED_NAME = WindowState.MINIMIZED.toString();
        private static final String MAXIMIZED_NAME = WindowState.MAXIMIZED.toString();

        public static PortletMode getPortletMode(String string) {
            if (string == null) {
                return null;
            }
            if (string.equalsIgnoreCase(VIEW_NAME)) {
                return PortletMode.VIEW;
            }
            if (string.equalsIgnoreCase(EDIT_NAME)) {
                return PortletMode.EDIT;
            }
            if (string.equalsIgnoreCase(HELP_NAME)) {
                return PortletMode.HELP;
            }
            return new PortletMode(string);
        }

        public static WindowState getWindowState(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals(NORMAL_NAME)) {
                return WindowState.NORMAL;
            }
            if (string.equals(MAXIMIZED_NAME)) {
                return WindowState.MAXIMIZED;
            }
            if (string.equals(MINIMIZED_NAME)) {
                return WindowState.MINIMIZED;
            }
            return new WindowState(string);
        }

        public VariableInfo[] getVariableInfo(TagData tagData) {
            VariableInfo[] variableInfoArray = null;
            String string = tagData.getAttributeString("var");
            if (string != null) {
                variableInfoArray = new VariableInfo[]{new VariableInfo(string, "java.lang.String", true, 2)};
            }
            return variableInfoArray;
        }
    }
}

