/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util;

import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheHelper {
    private static final String CLASS_NAME = CacheHelper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static boolean globalCacheEnabled = false;

    public static void setPortletContainerCachingEnabled(boolean bl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPortletContainerCachingEnabled", globalCacheEnabled);
        }
        globalCacheEnabled = bl;
        logger.exiting(CLASS_NAME, "isPortletContainerCachingEnabled", globalCacheEnabled);
    }

    public static boolean isCachingEnabled(PortletDefinition portletDefinition) {
        boolean bl;
        logger.entering(CLASS_NAME, "isCachingEnabled", portletDefinition);
        boolean bl2 = bl = CacheHelper.isPortletContainerCachingEnabled() && CacheHelper.isPortletCacheable(portletDefinition);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "isCachingEnabled", bl);
        }
        return bl;
    }

    private static boolean isPortletCacheable(PortletDefinition portletDefinition) {
        logger.entering(CLASS_NAME, "isPortletCacheable", portletDefinition);
        logger.exiting(CLASS_NAME, "isPortletCacheable", Boolean.TRUE);
        return true;
    }

    public static boolean isPortletContainerCachingEnabled() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPortletContainerCachingEnabled");
            logger.exiting(CLASS_NAME, "isPortletContainerCachingEnabled", globalCacheEnabled);
        }
        return globalCacheEnabled;
    }
}

