/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class LocaleIterator {
    private static Hashtable localeListTable = new Hashtable(101);
    private Locale iLocale;
    private Locale iDefault;
    private LocaleList list;
    private int iMax;
    private int iCount;

    public LocaleIterator(Locale locale) {
        this(locale, null);
    }

    public LocaleIterator(Locale locale, Locale locale2) {
        if (locale == null) {
            throw new IllegalArgumentException("LocaleIterator: Argument \"aLocale\" cannot be null.");
        }
        this.iLocale = locale;
        this.iDefault = locale2;
        this.list = LocaleIterator.findLocaleList(locale);
        this.iMax = this.list.size();
        this.iCount = 0;
    }

    private static LocaleList findLocaleList(Locale locale) {
        LocaleList localeList = null;
        localeList = (LocaleList)localeListTable.get(locale);
        if (null == localeList) {
            localeList = new LocaleList(locale);
            localeListTable.put(locale, localeList);
        }
        return localeList;
    }

    public boolean hasNext() {
        return this.iCount < this.iMax;
    }

    public Locale next() {
        Locale locale = null;
        locale = this.list.get(this.iCount);
        ++this.iCount;
        if (this.iCount == this.iMax && this.iDefault != null) {
            this.iLocale = this.iDefault;
            this.iDefault = null;
            this.list = LocaleIterator.findLocaleList(this.iLocale);
            this.iCount = 0;
            this.iMax = this.list.size();
        }
        return locale;
    }

    private static class LocaleList {
        ArrayList localeAlternatives = null;

        private LocaleList(Locale locale) {
            Locale locale2;
            int n = LocaleList.sizeOf(locale);
            this.localeAlternatives = new ArrayList(n);
            this.localeAlternatives.add(locale);
            if (n >= 3) {
                locale2 = new Locale(locale.getLanguage(), locale.getCountry());
                this.localeAlternatives.add(locale2);
            }
            if (n >= 2) {
                locale2 = new Locale(locale.getLanguage(), "");
                this.localeAlternatives.add(locale2);
            }
        }

        private Locale get(int n) {
            return (Locale)this.localeAlternatives.get(n);
        }

        private int size() {
            return this.localeAlternatives.size();
        }

        private static int sizeOf(Locale locale) {
            int n = locale.getVariant() != null && locale.getVariant().length() > 0 ? 3 : (locale.getCountry() != null && locale.getCountry().length() > 0 ? 2 : 1);
            return n;
        }
    }
}

